@ECHO OFF

REM ######################
REM # SCRIPT HISTORY:
REM # 10600: First Created
REM ######################

REM ############# MIGRATE JVM PROCEDURE ############
REM ## RESOLVING PATHS ##########################################################################################
REM # NOTE: 1. Assume that the script current path is inside "%APP_HOME%\aua\%VERSION%\upgrade\".
REM #       2. Assume that all the APP related java processes are killed / shut down before running this script.
REM #############################################################################################################

SET JVM_FILE_HOME=%CD%

CD "..\.."
SET AUA_HOME=%CD%
SET AUA_JVM_DIR=%AUA_HOME%\jvm

CD ".."
SET APP_HOME=%CD%
SET APP_JVM_HOME=%APP_HOME%\jvm
SET APP_JVM_BIN_DIR=%APP_JVM_HOME%\bin
SET APP_JVM_HOME_ORI=%APP_HOME%\jvm.ori
SET APP_JVM32_HOME=%APP_HOME%\jvm32
SET APP_JVM32_BIN_DIR=%APP_JVM32_HOME%\bin
SET APP_JVM32_HOME_ORI=%APP_HOME%\jvm32.ori
SET UTIL_BIN_HOME=%APP_HOME%\util\bin

SET FILENAME_JAVA_EXEC_JAVAW=javaw.exe

SET FILENAME_AUA_XML_VERSION=version.xml
SET FILENAME_APP_TXT_VERSION=version.txt

SET FILENAME_APP_EXEC_SERVICE=bJW.exe
SET FILENAME_APP_EXEC_SCHEDULER_SERVICE=bschJW.exe

SET FILENAME_UTIL_7Z=7za.exe

SET FILENAME_JVM_X86_UPDATE_PATCH=%JVM_FILE_HOME%\jre-std-windows-x86.7z
SET FILENAME_JVM_X86_64_UPDATE_PATCH=%JVM_FILE_HOME%\jre-std-windows-x64.7z

:START_INSTALL_JVM_UPDATE
REM ############# INSTALL UPDATE PROCESS ############

REM ## DETERMINE THE DIR TO EXTRACT FOR DIFFERENT OS ARCH ##################
ECHO Install APP's JVM update ... 
ECHO This OS is in "%PROCESSOR_ARCHITECTURE%" architecture.  
IF "%PROCESSOR_ARCHITECTURE%" == "x86" (
    SET FILENAME_JVM_UPDATE_PATCH=%FILENAME_JVM_X86_UPDATE_PATCH%
) ELSE (
    SET FILENAME_JVM_UPDATE_PATCH=%FILENAME_JVM_X86_64_UPDATE_PATCH%
)

REM ## EXTRACT AND REPLACE THE UPDATE ARCHIVE TO JVM DIRECTORY #############
:EXTRACT_AND_REPLACE_JVM_UPDATE
ECHO Rename the original JVM Home "%APP_JVM_HOME%" to "%APP_JVM_HOME_ORI%" ... 
MOVE "%APP_JVM_HOME%" "%APP_JVM_HOME_ORI%"

REM ## NOTE: "7za.exe" will create the output directory during extracting the 7z archive if the output directory does not exist.
ECHO Extract the JVM update patch contents to the directory "%APP_JVM_HOME%" ... 
"%UTIL_BIN_HOME%\%FILENAME_UTIL_7Z%" x "%FILENAME_JVM_UPDATE_PATCH%" -aoa -o"%APP_JVM_HOME%"

ECHO Config the new JVM ... 
ECHO Create the AUA Service Executable files by copying from the original java executables... 
IF EXIST "%APP_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" (
    ECHO Copy "%APP_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" to "%APP_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SERVICE%" ... 
    COPY "%APP_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" "%APP_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SERVICE%" /Y

    ECHO Copy "%APP_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" to "%APP_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SCHEDULER_SERVICE%" ... 
    COPY "%APP_JVM_BIN_DIR%\%FILENAME_JAVA_EXEC_JAVAW%" "%APP_JVM_BIN_DIR%\%FILENAME_APP_EXEC_SCHEDULER_SERVICE%" /Y
)

IF EXIST "%APP_JVM_HOME_ORI%" (
    ECHO Remove the original JVM directory "%APP_JVM_HOME_ORI%" ... 
    RMDIR /S /Q "%APP_JVM_HOME_ORI%"
)

REM ## Removing files / directories procedures  ######################################
:REMOVE_PROCEDURES
IF EXIST "%FILENAME_AUA_XML_VERSION%" (
    ECHO Remove the file "%FILENAME_AUA_XML_VERSION%" ... 
    DEL /F "%FILENAME_AUA_XML_VERSION%"
)

IF EXIST "%FILENAME_JVM_X86_UPDATE_PATCH%" (
    ECHO Removing the JVM update patch "%FILENAME_JVM_X86_UPDATE_PATCH%" ... 
    DEL /F "%FILENAME_JVM_X86_UPDATE_PATCH%"
)
IF EXIST "%FILENAME_JVM_X86_64_UPDATE_PATCH%" (
    ECHO Removing the JVM update patch "%FILENAME_JVM_X86_64_UPDATE_PATCH%" ... 
    DEL /F "%FILENAME_JVM_X86_64_UPDATE_PATCH%"
)

IF EXIST "%~0%" (
    ECHO Remove this script "%~0" ... 
    DEL /F "%~0"
)

:SCRIPT_END
EXIT

@ECHO ON