#!/bin/sh
# Ahsay Online Backup Manager 8.5.2.62

############################### WuiService.sh ##################################
# You can use this shell to run the wui service                                #
################################################################################

########################  Start: User Defined Section  #########################

# ------------------------------  SETTING_HOME  --------------------------------
# | Directory to your setting home.                                            |
# | Default to ${HOME}/.obm when not set.                                      |
# | e.g. SETTING_HOME="${HOME}/.obm"                                           |
# ------------------------------------------------------------------------------
SETTING_HOME="~/.obm"

PORT="32168"

##########################  END: User Defined Section  #########################

################################################################################
#                S C R I P T                         U S A G E                 #
################################################################################

# Input Arguments will overwrite the above settings
# defined in 'User Defined Section'.
if [ -n "$1" ]; then
    SETTING_HOME="$1"
fi
if [ -n "$2" ]; then
    PORT="$2"
fi

################################################################################
#          R E T R I E V E     A P P _ H O M E     P A T H                     #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`
DEP_LIB_PATH=

OS_NAME=
case "${SYSTEM_OS}" in
  Linux* )
    OS_NAME="Lin"
    ;;
  *BSD* )
    OS_NAME="Fbd"
    ;;
  Darwin* )
    DEP_LIB_PATH="MacX84"
    ;;
  SunOS )
    OS_NAME="Sos"
    SYSTEM_ARCH=`isainfo -b`
    ;;
  * )
    echo "OS \"${SYSTEM_OS}\" is not supported. Exit now."
    exit 1
    ;;
esac

OS_ARCH=
if [ -z "${DEP_LIB_PATH}" ]; then
    case "${SYSTEM_ARCH}" in
        i[3-6]86)
            OS_ARCH="X86"
        ;;
        x86_64 | amd64)
            OS_ARCH="X64"
        ;;
        armv6*)
            OS_ARCH="Av6"
        ;;
        armv7*)
            OS_ARCH="Av7"
        ;;
        armv5*)
            OS_ARCH="Arm"
        ;;
        aarch64*)
            OS_ARCH="A64"
        ;;
        * )
            echo "Arch \"${SYSTEM_ARCH}\" is not supported. Exit now."
            exit 1
        ;;
    esac
    DEP_LIB_PATH=${OS_NAME}${OS_ARCH}
fi

################################################################################
#          R E T R I E V E     J A V A _ H O M E     P A T H                   #
################################################################################

if [ "Darwin" = "${SYSTEM_OS}" ]; then
    JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Home"
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "'$APP_HOME/jvm' does not exist!"
    if [ ! -n "$JAVA_HOME" ]; then
        echo "Please set JAVA_HOME!"
        exit 0
    else
        ln -sf "$JAVA_HOME" "$APP_HOME/jvm"
        echo "Created JAVA_HOME symbolic link at '$APP_HOME/jvm'"
    fi
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "Please create symbolic link for '$JAVA_HOME' to '$APP_HOME/jvm'"
    exit 0
fi

JAVA_HOME="$APP_HOME/jvm"
JAVA_EXE="$JAVA_HOME/bin/java"

# Verify the JAVA_EXE whether it can be executed or not.
if [ ! -x "${JAVA_EXE}" ]
then
    echo "The Java Executable file \"${JAVA_EXE}\" cannot be executed. Exit \""`basename "$0"`"\" now."
    exit 1
fi

# Verify the JAVA_EXE whether it is a valid JAVA Executable or not.
STRING_JAVA_VERSION="java version,openjdk version"
OUTPUT_JAVA_VERSION=`"${JAVA_EXE}" -version 2>&1`
OUTPUT_JVM_SUPPORT=0
BACKUP_IFS=$IFS
IFS=","
for word in $STRING_JAVA_VERSION; do
    if [ `echo "${OUTPUT_JAVA_VERSION}" | grep "${word}" | grep -cv "grep ${word}"` -le 0 ]
    then
      #echo "The Java Executable \"${JAVA_EXE}\" is not a valid Java Executable. Exit \""`basename "$0"`"\" now."
      continue;
    else
      OUTPUT_JVM_SUPPORT=1
      break;
    fi
done
IFS=$BACKUP_IFS
if [ $OUTPUT_JVM_SUPPORT -eq 0 ]
then
    echo "The Java Executable \"${JAVA_EXE}\" is not a valid Java Executable. Exit \""`basename "$0"`"\" now."
    exit 1
fi

#get the suitable xmx
SUITABLE_XMX=`$APP_HOME/util/bin/get-suitable-xmx.sh`
if [ -z $SUITABLE_XMX ];
then
    SUITABLE_XMX=256
else
    echo $SUITABLE_XMX | grep "[^0-9]" > /dev/null 2>&1
    if [ "$?" -eq "0" ];
    then
        SUITABLE_XMX=256
    fi
fi

################################################################################
#                         J A V A     E X E C U T I O N                        #
################################################################################

# Change to APP_BIN for JAVA execution
cd "${APP_BIN}"

# Reference path will be used to avoid empty space in the parent directory
LIB_HOME=.
JAVA_OPTS="-Xrs -Xms64m -Xmx${SUITABLE_XMX}m -Dsun.nio.PageAlignDirectMemory=true"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/${DEP_LIB_PATH}"
CLASSPATH="$LIB_HOME:$LIB_HOME/cb.jar"
MAIN_CLASS=WuiService

echo "Using APP_HOME     : ${APP_HOME}"
echo "Using SETTING_HOME : ${SETTING_HOME}"

# Set locale to allow processing non-ascii file names
export LANG=en_US.utf8
# API Arguments: WuiService [APP_HOME] [SETTING_HOME] --port=<port> --debug=<Y/N>

# Do not include double-quote for java options, jni path, classpath and main class
# Only apply double-quote for path to java executable and execution arguments
"${JAVA_EXE}" $JAVA_OPTS $JNI_PATH -cp $CLASSPATH $MAIN_CLASS "${APP_HOME}" "${SETTING_HOME}" "--port=${PORT}" > "${APP_HOME}/log/WuiService/console.log" 2>&1 &

PID=$!
EXIT_STATUS=$?
echo $PID > ${APP_HOME}/WuiService.pid
echo "WuiService PID=${PID}" >> ${APP_HOME}/log/WuiService/console.log
echo "WuiService EXIT=${EXIT_STATUS}" >> ${APP_HOME}/log/WuiService/console.log
################################################################################
#                   R E S E T          A N D          E X I T                  #
################################################################################

cd "${EXE_DIR}"
exit $EXIT_STATUS
