quot = chr(34)

Set iServer = CreateObject ("CDOEXM.ExchangeServer")
Set iMDB = CreateObject ("CDOEXM.MailboxStoreDB")
Set iPDB = CreateObject ("CDOEXM.PublicStoreDB")
Set iSG = CreateObject ("CDOEXM.StorageGroup")
Set stdout = WScript.StdOut
Set stderr = WScript.StdErr
' check command line
GetArgs strMode,strComputerName,strSGName,strMDBName, strPath1, strPath2, CorrectSyntax
If CorrectSyntax Then
	Select Case strMode
	Case "listStorageGroup"
	 listStorageGroup strComputerName
	Case "listMailBoxDatabase"
	 listMailBoxDatabase strComputerName,strSGName
	Case "listPublicFolderDatabase"
	 listPublicFolderDatabase strComputerName,strSGName
	Case "moveDatabasePath"
	 moveMailBoxDatabase strComputerName,strSGName,strMDBName,strPath1,strPath2,Moved 
	if Not Moved Then
		movePublicFolderDatabase strComputerName,strSGName,strMDBName,strPath1,strPath2,Moved
		if Not Moved Then
	    stderr.WriteLine "Fail to move database"+strMDBName
		end if
	end if
	Case "moveStorageGroupPath" 
	 moveStorageGroupPath strComputerName,strSGName,strPath1,strPath2,Moved
	 if Not Moved Then
	    stderr.WriteLine "Fail to move database"+strMDBName
	end if
	Case "createMailboxDataBase"
	createMailBoxDatabase strComputerName,strSGName,strMDBName,strPath1,strPath2,created
	 if Not created Then
	    stderr.WriteLine "Fail to create mailbox database"+strMDBName
	end if
	Case "createPublicFolderDatabase"
	createPublicFolderDatabase strComputerName,strSGName,strMDBName,strPath1,strPath2,created
	 if Not created Then
	    stderr.WriteLine "Fail to create public folder database"+strMDBName
	end if
	Case "createStorageGroup"
	createStorageGroup strComputerName,strSGName,strPath1,strPath2,created
	 if Not created Then
	    stderr.WriteLine "Fail to create StorageGroup"+strSGName
	end if
	Case "mount"
		BindMailboxStore strComputerName,strSGName,strMDBName,strStoreType
		Select Case strStoreType
		Case "MailboxDB"
			iMDB.mount 5000
			'Do
			'iStatus = iMDB.Status
				'If InStr(1, iStatus, 1) = 0 Then
					'Exit Do
				'Else
				'wscript.Sleep 1000
				'End If
			'Loop

		Case "PublicDB"
			iPDB.mount 5000
			'Do
			'iStatus = iPDB.Status
				'If InStr(1, iStatus, 1) = 0 Then
					'Exit Do
				'Else
				'wscript.Sleep 1000
				'End If
			'Loop

		End Select
	Case "dismount"
		BindMailboxStore strComputerName,strSGName,strMDBName,strStoreType
		Select Case strStoreType
			Case "MailboxDB"	
			iMDB.dismount 5000
			'Do
				'iStatus = iMDB.Status
				'If InStr(1, iStatus, 1) <> 0 Then
					'Exit Do
				'Else
				'wscript.Sleep 1000
				'End If
			'Loop

	
			Case "PublicDB"
				iPDB.dismount 5000
				'Do
				'iStatus = iPDB.Status
					'If InStr(1, iStatus, 1) <> 0 Then
						'Exit Do
					'Else
					'wscript.Sleep 1000
					'End If
				'Loop
			End Select
	Case "delete"
		BindMailboxStore strComputerName,strSGName,strMDBName,strStoreType
		Select Case strStoreType
			Case "MailboxDB"
				iMDB.DataSource.delete
			Case "PublicDB"
				iPDB.DataSource.delete
		End Select
	End Select
' Cleanup
Else
 DisplayHelp
End If
Set iServer = Nothing
Set iMDB = Nothing
Set iPDB = Nothing
Set iSG = Nothing

'Else
'DisplayHelp
wscript.quit


Sub BindMailboxStore (strComputerName,strSGName,strMDBName,strStoreType)
' Bind to the Exchange Server
iServer.DataSource.Open strComputerName

' Build the first part of the URL to the MailboxStoreDB
strTemp = "LDAP://" & iServer.DirectoryServer & "/" & "cn=" & strMDBName & ","

' Set variant array to the ExchangeServer.StorageGroups
arrStGroup = iServer.StorageGroups

' Look in the StorageGroups array if the StorageGroup with strSGName exists
If strSGName = "" Then
	' Add last part to the URL to the MailboxStoreDB
	strMDBUrl = strTemp & iServer.StorageGroups(0)
Else
	For each sg in arrStGroup
		If InStr(1, UCase(sg), UCase(strSGName)) <> 0 Then
			iSG.DataSource.Open sg
			strUrl = sg
		End If
	Next			
			arrStMailBoxDB = iSG.MailboxStoreDBs	
			For each mailboxDB in arrStMailBoxDB
				If InStr(1, UCase(mailboxDB), UCase(strMDBName)) <> 0 Then
				'wscript.echo "MailBoxDB " & arrStMailBoxDB(j)
					strMDBUrl = strUrl
					Exit For
				End If
			Next
			if strMDBUrl = "" Then
				arrStPublicDB = iSG.PublicStoreDBs
				For each pfDB in arrStPublicDB 
					If InStr(1, UCase(pfDB), UCase(strMDBName)) <> 0 Then
					strPDBUrl = strUrl
					Exit For
					End If
				Next
			End If	
	If strMDBUrl <> "" Then
		strMDBUrl = strTemp & strMDBUrl
		iMDB.DataSource.Open strMDBUrl
		strStoreType = "MailboxDB"
	End If
	If strPDBUrl <> "" Then
		strPDBUrl = strTemp & strPDBUrl
		iPDB.DataSource.Open strPDBUrl
		strStoreType = "PublicDB"
	End If
End If
End Sub


Sub GetArgs(strMode,strComputerName,strSGName,strMDBName, strPath1, strPath2, CorrectSyntax)
CorrectSyntax = False
Set Args = WScript.Arguments
	If args.count = 2 Then
		strMode = args(0)
		strComputerName = args(1)
	Else
		If args.count = 3 Then
		strMode = args(0)
		strComputerName = args(1)
		strSGName = args(2)
		Else
			If args.count = 4 Then
				strMode = args(0)
				strComputerName = args(1)
				strSGName = args(2)
				strMDBName = args(3)
			Else
					If args.count = 6 Then
						strMode = args(0)
						strComputerName = args(1)
						strSGName = args(2)
						strMDBName = args(3)
						strPath1 = args(4)
						strPath2 = args(5)
					Else
					CorrectSyntax = False
					End If
			End If
		End If
	End If
Select Case lcase(strMode)
Case "mount","dismount","delete","liststoragegroup","listmailboxdatabase","listpublicfolderdatabase","movedatabasepath","movestoragegrouppath","createstoragegroup","createmailboxdatabase","createpublicfolderdatabase"
CorrectSyntax = True
End Select
End Sub
Sub listStorageGroup(strComputerName)
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
	arrStGroup = iServer.StorageGroups
	For each sg in arrStGroup
		iSG.DataSource.Open sg
		stdout.WriteLine iSG.name + "," + iSG.SystemFilePath + "," + iSG.LogFilePath 
	Next
End Sub

Sub listMailBoxDatabase(strComputerName, strGroupName)
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
	arrStGroup = iServer.StorageGroups
    strMailDB = ""
	  For each sg in arrStGroup
	  	iSG.DataSource.Open sg
		If UCase(iSG.name) = UCase(strGroupName) Then 
			iSG.DataSource.Open sg
			arrStMailBoxDB = iSG.MailboxStoreDBs	
			For each mailDB in arrStMailBoxDB
				iMDB.DataSource.Open mailDB
				strMounted ="true"
				If iMDB.Status <> 0 Then
				   strMounted ="false"
				   end If
				stdout.WriteLine iMDB.name + "," + iMDB.DBPath + "," + strMounted
			Next
		End If
	Next
End Sub

Sub listPublicFolderDatabase(strComputerName, strGroupName)
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
	arrStGroup = iServer.StorageGroups
	strPFDB = ""
	For each sg in arrStGroup
		iSG.DataSource.Open sg
		If UCase(iSG.name) = UCase(strGroupName) Then
			arrStPFDB = iSG.PublicStoreDBs	
			For each PFDB in arrStPFDB
				iPDB.DataSource.Open PFDB
				strMounted ="true"
				If iPDB.Status <> 0 Then
				   strMounted ="false"
				   end If
				stdout.WriteLine iPDB.name + "," + iPDB.DBPath + "," + strMounted
			Next
		End If
	Next
End Sub

Sub moveMailBoxDatabase(strComputerName, strGroupName, strDatabaseName, strEDBPath, strStreamPath, Moved)
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
	arrStGroup = iServer.StorageGroups
	strPFDB = ""
	For each sg in arrStGroup
		iSG.DataSource.Open sg
		If UCase(iSG.name) = UCase(strGroupName) Then
			arrStMailBoxDB = iSG.MailboxStoreDBs	
			For each mailDB in arrStMailBoxDB
				If InStr(1, UCase(mailDB), UCase(strDatabaseName)) <> 0 Then	
			    	iMDB.DataSource.Open mailDB
					iMDB.MoveDataFiles  strEDBPath,strStreamPath
			    	stdout.WriteLine "Move " + iMDB.name + " edb Path=" + strEDBPath
					Moved = true
					Exit For
					end If		
			Next
		End If
	Next
End Sub

Sub movePublicFolderDatabase(strComputerName, strGroupName, strDatabaseName, strEDBPath, strStreamPath, Moved)
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
	arrStGroup = iServer.StorageGroups
	strPFDB = ""
	For each sg in arrStGroup
		iSG.DataSource.Open sg
		If UCase(iSG.name) = UCase(strGroupName) Then
			arrStPFDB = iSG.PublicStoreDBs	
			For each PFDB in arrStPFDB
				If InStr(1, UCase(pfDB), UCase(strDatabaseName)) <> 0 Then	
			    	iPDB.DataSource.Open PFDB
					iPDB.MoveDataFiles  strEDBPath,strStreamPath
			    	stdout.WriteLine "Move " + iPDB.name + " edb Path=" + strEDBPath
					Moved = true
					Exit Sub
					end If		
			Next
		End If
	Next
End Sub

Sub moveStorageGroupPath(strComputerName, strGroupName, strSystemPath, strLogPath, Moved)
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
	arrStGroup = iServer.StorageGroups
	strPFDB = ""
	For each sg in arrStGroup
		iSG.DataSource.Open sg
		If UCase(iSG.name) = UCase(strGroupName) Then
			iSG.MoveSystemFiles  strSystemPath,0
			iSG.MoveLogFiles strLogPath,0
			Moved=true			
			Exit Sub
		End If
	Next
End Sub

Sub createMailBoxDatabase(strComputerName, strGroupName, strDatabaseName, strEDBPath, strStreamPath, created)
	strTemp = "LDAP://CN="& strDatabaseName & ","
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
    arrStGroup = iServer.StorageGroups
	For each sg in arrStGroup
		If InStr(1, UCase(sg), UCase(strGroupName)) <> 0 Then
	    strMDBUrl = strTemp & sg
		stdout.WriteLine strMDBUrl
		iMDB.DataSource.SaveTo strMDBUrl
		iMDB.Mount
		iMDB.MoveDataFiles  strEDBPath,strStreamPath
		created=true
		Exit Sub
    End If
	Next
End Sub

Sub createPublicFolderDatabase(strComputerName, strGroupName, strDatabaseName, strEDBPath, strStreamPath, created)
	strTemp = "LDAP://CN="& strDatabaseName & ","
	' Bind to the Exchange Server
	iServer.DataSource.Open strComputerName
	' Set variant array to the ExchangeServer.StorageGroups
    arrStGroup = iServer.StorageGroups
	For each sg in arrStGroup
		If InStr(1, UCase(sg), UCase(strGroupName)) <> 0 Then
	    strMDBUrl = strTemp & sg
		stdout.WriteLine strMDBUrl
		iPDB.DataSource.SaveTo strMDBUrl
		iPDB.Mount
		iPDB.MoveDataFiles  strEDBPath,strStreamPath
		created=true
		Exit Sub
    End If
	Next
End Sub

Sub createStorageGroup(strComputerName, strGroupName, strSystemPath, strLogPath, created)
	iServer.DataSource.Open strComputerName
	' This for loop is a bit of a hack to retrieve the first Storage Group
	' in the collection. 
	for each strSg in iServer.StorageGroups
		strTemp = strSg
		exit for
	next
	strTemp = mid(strTemp,instr(2,strTemp,"cn",1))
	strSGUrl = "LDAP://cn=" & strGroupName & "," & strTemp	
	stdout.WriteLine strSGUrl
	iSG.DataSource.SaveTo strSGUrl
	iSG.MoveSystemFiles  strSystemPath,0
	iSG.MoveLogFiles strLogPath,0
	created=true
End Sub

Sub DisplayHelp
stdout.WriteLine  "Mounts, Dismounts, or Deletes a Mailbox Store on an Exchange 2000/2003 server"
stdout.WriteLine  ""
stdout.WriteLine  "StoreDB.vbs /? or /Help ----------------------------------- Displays this help screen"
stdout.WriteLine  "StoreDB.vbs listStorageGroup Servername  ---- List Storage Group"
stdout.WriteLine  "StoreDB.vbs listMailBoxDatabase Servername StorageGroupName ---- List Mailbox Database"
stdout.WriteLine  "StoreDB.vbs listPublicFolderDatabase Servername StorageGroupName ---- List Public Folder Database"
stdout.WriteLine  "StoreDB.vbs Mount Servername StorageGroupName MDBName ----- Mounts Database"
stdout.WriteLine  "StoreDB.vbs Dismount Servername StorageGroupName MDBName -- Dismounts Database"
stdout.WriteLine  "StoreDB.vbs Delete Servername StorageGroupName MDBName ---- Deletes Database"
stdout.WriteLine  ""
stdout.WriteLine  ""
stdout.WriteLine  "Example:"
stdout.WriteLine  ""
stdout.WriteLine  "StoreDB.vbs Mount SERVER1 "&quot&"First Storage Group"&quot&" "&quot&"Mailbox Store (SERVER1)"&quot
stdout.WriteLine  ""
End Sub