@ECHO OFF
SETLOCAL ENABLEDELAYEDEXPANSION

REM get application home
SET "EXE_HOME=%CD%"
CD "%~dp0"
SET "APP_BIN=%CD%"
CD ".."
SET "APP_HOME=%CD%"
CD "%~dp0"
SET "SERVICE_UTIL=%APP_HOME%\util\bin\Service.exe"
IF NOT EXIST "%SERVICE_UTIL%" (
    SET "SERVICE_UTIL=%APP_BIN%\Service.exe"
    IF NOT EXIST "!SERVICE_UTIL!" (
        ECHO."No Service.exe could be found!"
        SET /A "RTN_CODE=1"
        GOTO _exit
    )
)

REM Define the service
SET "CONTROL_VERSION=1.0"
SET "DESCRIPTION=VMDK / VHD Mount Driver "
IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
    SET "OS_ARCH=X86"
    SET "SERVICE_EXEC=vstor2-mntapi10-shared.sys"
    SET "SERVICE_NAME=vstor2-mntapi10-shared"
) ELSE (
    SET "OS_ARCH=X64"
    SET "SERVICE_EXEC=vstor2-mntapi20-shared.sys"
    SET "SERVICE_NAME=vstor2-mntapi20-shared"
)

IF NOT EXIST "%CD%\%OS_ARCH%\%SERVICE_EXEC%" (
    ECHO.STATE_SUPPORT: 0
    GOTO _exit
)
ECHO.STATE_SUPPORT: 1
ECHO.

ECHO.NAME: %SERVICE_NAME%
CALL :sub_print_status "%SERVICE_NAME%"
ECHO.

SET /A "STATE_INSTALLED=0"
SET /A "STATE_RUNNING=0"
CALL :sub_check_running "%SERVICE_NAME%" STATE_RUNNING
IF %STATE_RUNNING% EQU 1 (
    SET /A "STATE_INSTALLED=1"
) ELSE (
    CALL :sub_check_installed "%SERVICE_NAME%" STATE_INSTALLED
)
ECHO.STATE_INSTALLED: %STATE_INSTALLED%
ECHO.STATE_RUNNING: %STATE_RUNNING%
ECHO.
SET "CURR_VERSION=0.0"
CALL :sub_check_version "%SERVICE_NAME%" "%DESCRIPTION%" CURR_VERSION
ECHO.CTRL_VERSION: %CONTROL_VERSION%
ECHO.CURR_VERSION: %CURR_VERSION%

ECHO.
SET /A "RTN_CODE=0"
IF %STATE_RUNNING% EQU 1 (
    SET /A "RTN_CODE=0"
    GOTO _exit
)
IF %STATE_INSTALLED% EQU 1 (
    SET /A "RTN_CODE=1"
    GOTO _exit
)
SET /A "RTN_CODE=2"

:_exit
CD "%EXE_HOME%"
EXIT /B %RTN_CODE%

REM ----------------------------------------------------------
:sub_print_status
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qs %~1"') DO (
    SET /A "FOUND=1"
    ECHO.    ^> %%i
)
IF %FOUND% EQU 1 (
    FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qc %~1"') DO (
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "PATH_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DISPLAY_NAME"') DO (
            ECHO.    ^> %%i
        )
        FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "DESCRIPTION"') DO (
            ECHO.    ^> %%i
        )
    )
)
EXIT /B

:sub_check_installed
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    REM all service states start with "SERVICE_"
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

:sub_check_running
SET /A "FOUND=0"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -q %~1"') DO (
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "SERVICE_RUNNING" /C') DO (
        SET /A "FOUND=%%j"
    )
)
IF NOT %FOUND% EQU 0 (
    SET /A "%2=1"
) ELSE (
    SET /A "%2=0"
)
EXIT /B

:sub_left_trim
FOR /f "tokens=* delims= " %%a IN ("%~1") DO (
    SET "%~2=%%a"
)
EXIT /B

:sub_check_version
SET "QUERY_TAG=%~2"
SET "VERSION_TAG=%DESCRIPTION%"
FOR /f "tokens=*" %%i IN ('""%SERVICE_UTIL%" -qc %~1"') DO (
    FOR /f "tokens=*" %%j IN ('ECHO %%i ^| find "%VERSION_TAG%"') DO (
        SET "QUERY_RESULT=%%j"
        SET "TARGET_RESULT=!QUERY_RESULT:%QUERY_TAG%=!"
        IF NOT "!TARGET_RESULT!"=="!QUERY_RESULT!" (
            SET "TARGET_RESULT=!TARGET_RESULT:%VERSION_TAG%=!"
            CALL :sub_left_trim "!TARGET_RESULT!" TARGET_RESULT
            FOR /F "tokens=2* delims=:" %%a IN ("!TARGET_RESULT!") DO (
                CALL :sub_left_trim "%%a" %~3
            )
            GOTO sub_check_version_exit
        )
    )
)
:sub_check_version_exit
EXIT /B

ENDLOCAL