#!/bin/sh

# --------------------------- Change to AUA_HOME -------------------------------
cd `dirname "$0"`
cd ..
AUA_HOME=`pwd`

# --------------------------- Set the Action Name ------------------------------
AUA_ACTION=update

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`
DEP_LIB_PATH=

OS_NAME=
case "${SYSTEM_OS}" in
  Linux* )
    OS_NAME="Lin"
    ;;
  *BSD* )
    OS_NAME="Fbd"
    ;;
  SunOS )
    OS_NAME="Sos"
    SYSTEM_ARCH=`isainfo -b`
    ;;
  * )
    echo "OS \"${SYSTEM_OS}\" is not supported. Exit now."
    exit 1
    ;;
esac

OS_ARCH=
if [ -z "${DEP_LIB_PATH}" ]; then
    case "${SYSTEM_ARCH}" in
        i[3-6]86 | 32)
            OS_ARCH="X86"
        ;;
        x86_64 | amd64 | 64)
            OS_ARCH="X64"
        ;;
        armv6*)
            OS_ARCH="Av6"
        ;;
        armv7*)
            OS_ARCH="Av7"
        ;;
        armv5*)
            OS_ARCH="Arm"
        ;;
        aarch64*)
            OS_ARCH="A64"
        ;;
        * )
            echo "Arch \"${SYSTEM_ARCH}\" is not supported. Exit now."
            exit 1
        ;;
    esac
    DEP_LIB_PATH=${OS_NAME}${OS_ARCH}
fi

LIB_HOME="./lib"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/${DEP_LIB_PATH}"

# ----------------- AutoUpdateAgent Execution via Java -------------------------
# Use JAVA to execute the AutoUpdateAgent Server
AUA_CLASSPATH=./lib:./lib/aua.jar:./lib/bcmail-jdk15to18-164.jar:./lib/bcpkix-jdk15to18-164.jar:./lib/bcprov-jdk15to18-164.jar:./lib/commons-logging-1.2.jar:./lib/httpclient-4.5.12.jar:./lib/httpcore-4.4.13.jar:./lib/jackson-annotations-2.7.4.jar:./lib/jackson-core-2.9.9.jar:./lib/jackson-databind-2.7.4.jar:./lib/jdom.jar:./lib/jersey-apache-client4-1.18.1.jar:./lib/jersey-bundle-1.18.1.jar:./lib/jersey-multipart-1.18.1.jar:./lib/log4j.jar:./lib/org.json-20150730.jar:./lib/snappy-java-1.1.7.3.jar:./lib/sqlite-jdbc-3.27.2.1.1.jar

# run auaJW here for migration from v6 or below only, don't use in v7 aua
"${AUA_HOME}/jvm/bin/auaJW" -Xrs $JNI_PATH -cp $AUA_CLASSPATH auas config.xml ${AUA_ACTION} &
exit 0
