if (!String.prototype.startsWith) {
	String.prototype.startsWith = function(search, pos) {
		return this.substr(!pos || pos < 0 ? 0 : +pos, search.length) === search;
	};
}

function setVisible(div, visible) {
	$_div = $(div);
	if (visible) $_div.show();
	else $_div.hide();
}

function setEnable(div, value) {
	if (value) {
		$(div + ' :input').removeAttr('disabled');
	} else {
		$(div + ' :input').attr('disabled', true);
	}
}

function addPageContent() {
	var $page_content = $("#cbs-page-content");
	// var main_body = "#cbs-main-body";
	var main_body = ".cbs-right-container";
	$page_content.appendTo(main_body);
}

function getAjaxErrMsg(response) {
	return response.substr(response.indexOf("]", response.lastIndexOf("][") + 1) + 1);
}

function getLineChart() {
	return {
		seriesColors: ["red", "green", "blue"],
		highlighter: {
			show: true,
			sizeAdjust: 1,
			tooltipOffset: 9
		},
		grid: {
			background: 'white',
			drawBorder: false,
			shadow: false,
			gridLineColor: '#E6E6E6',
			gridLineWidth: 1.5
		},
		seriesDefaults: {
			rendererOptions: {
				smooth: false
			},
			showMarker: true,
			lineWidth: 1
		},
		axesDefaults: {
			rendererOptions: {
				baselineWidth: 2,
				baselineColor: 'black',
				drawBaseline: true
			},
			tickOptions: {
				fontFamily: 'Arial, sans-serif',
				fontSize: '12px'
			}
		},
		axes: {
			xaxis: {
				renderer: $.jqplot.DateAxisRenderer,
				tickRenderer: $.jqplot.CanvasAxisTickRenderer,
				tickOptions: {
					formatString: "%e-%b",
					angle: 0,
					textColor: 'black'
				},
				tickInterval: "1 days",
				drawMajorGridlines: true,
				rendererOptions: {
					tickInset: 0.05
				}
			},
			yaxis: {
				pad: 1,
				rendererOptions: {
					minorTicks: 10
				},
				tickOptions: {
					formatString: "%'d",
					showMark: false,
					textColor: 'black'
				}
			}
		}
	};
}
function getLineChart4SysStatus() {
	var objLineChart = getLineChart();
	objLineChart.axesDefaults.max = null; // minimum numerical value of the axis.  Determined automatically.
	objLineChart.axes.yaxis.min = 0;
	objLineChart.axes.yaxis.pad = 1.2;

	objLineChart.seriesColors= ["#3C3", "#F90"];
	objLineChart.axes.xaxis.tickOptions.formatString = "%H:%M:%S";
	objLineChart.axes.xaxis.tickInterval = '2 minutes';

	objLineChart.seriesDefaults.showMarker = false; // hide the point
	objLineChart.axes.yaxis.max = null; // auto
	objLineChart.axes.yaxis.min = 0;
	objLineChart.axes.yaxis.pad = 1.2;
	// objLineChart.axes.yaxis.max = 100;
	// objLineChart.axes.yaxis.numberTicks = 3; // number of yaxes lables
	// objLineChart.axes.yaxis.ticks = ['0', '50','100'];

	objLineChart.axes.yaxis.tickOptions.formatString = "%'d%"; // yaxis lable

	// objLineChart.axes.yaxis.tickOptions.showMark = true; // hide the sub-line/minorTicks on the left of the yaxis
	// objLineChart.axes.yaxis.tickOptions.markSize = 4;// the length of the sub-line/minorTicks

	objLineChart.axes.yaxis.rendererOptions.minorTicks = 1;
	objLineChart.axes.yaxis.drawMinorGridlines = true;

	objLineChart.highlighter.show = false; // mouse over on the point

	objLineChart.axesDefaults.rendererOptions.drawBaseline = false;
	objLineChart.axesDefaults.rendererOptions.tickInset = 0;
	return objLineChart;
}
function getBarChart() {
	return {
		seriesDefaults: {
			renderer: $.jqplot.BarRenderer,
			pointLabels: { show: false },
			shadow: false,
			rendererOptions: {
				barDirection: 'horizontal',
				barWidth: 50
			},
			fillAndStroke: false
		},
		grid: {
			background: '#DFDFDF',
			shadow: false,
			drawBorder: false,
			drawGridLines: false,
			gridLineColor: '#DFDFDF'
		},
		axes: {
			xaxis: {
				min: "0",
				max: "100",
				drawMajorGridlines: false,
				showTicks: false
			},
			yaxis: {
				drawMajorGridlines: false,
				renderer: $.jqplot.CategoryAxisRendererBarRenderer,
				tickOptions: {
					show: false
				}
			}
		},
		gridPadding: {top:2, right:2, bottom:2, left:2}
	}
}

function showTopBox(url, width, height) {
	// 2014-12-22 (cliff.yeung) Hide the bottom buttons in editTabs.jsp
	$(".css-buttons-table").hide();
	var frameid = "iframeTopBox";
	var $iframe = $('<iframe id="' + frameid + '" name="' + frameid + '" src="' + url + '" frameborder="0" width="100%" height="100%"></iframe>');

	width = getWidth(Number.MAX_VALUE);
	height = getHeight(Number.MAX_VALUE);
	var frameContainer = $('<div></div>');
	$iframe.appendTo(frameContainer);
	currentDialog = frameContainer.dialog({
		title: "",
		modal: true,
		position: 'center',
		width: getWidth(width),
		height: getHeight(height),
		open: function(event, ui) {
			jQuery('.ui-dialog-titlebar').hide();
		}
	}).width(width - 5).height(height);
	// 11293: 2015-06-11 (kevin.wong) Not to return boolean to avoid showing "false" in Firefox
	// return false;
}

function replotBar(plot, dataUsed, aHtmlElem, aHtmlElemValue) {
	if (!isPlotExist(plot)) {
		return;
	}
	plot.series[0].data = dataUsed;
	plot.resetAxesScale();
	plot.axes.xaxis.min = 0;
	plot.axes.xaxis.max = 100;
	replot(plot);
	updateHtml(aHtmlElem, aHtmlElemValue);
}

function updateHtml(aHtmlElem, aHtmlElemValue) {
	for (i = 0; i < aHtmlElem.length; i++) {
		var htmlElem = aHtmlElem[i];
		if (htmlElem != null) {
			htmlElem.html(aHtmlElemValue[i]);
		}
	}
}

function replotGraph(plot, data0, data1, data2, data3, iYMin, iYMax, sYFormat) {
	if (!isPlotExist(plot)) {
		return;
	}
	if (data0 != null) {
		plot.series[0].data = data0;
	}
	if (data1 != null) {
		plot.series[1].data = data1;
	}
	plot.resetAxesScale();
	if (iYMin != null) {
		plot.axes.yaxis.min = iYMin;
	}
	if (iYMax != null) {
		plot.axes.yaxis.max = iYMax;
	}
	if (sYFormat != null) {
		plot.axes.yaxis.tickOptions.formatString = sYFormat;
	}
	replot(plot);
}

function isPlotExist(plot) {
	// Retain the line chart when it is hidden. When the line chart is hidden, it will be removed by not able to be replotted.
	if ($("#" + plot.target.attr("id")).is(':hidden')) {
		return false;
	}
	return true;
}

function replot(plot) {
	if (plot == null) {
		return;
	}
	if (!isPlotExist(plot)) {
		return;
	}
	if (plot) {
		plot.destroy(); // Releases all resources occupied by the plot
	}
	plot.replot();
}
// 2015-11-06 10219: (cliff.yeung) Support mobile for jqplot
function replot4Resize(plot) {
	if (plot == null) {
		return;
	}
	// For bar charts
	if (plot.target == null) {
		for (var key in plot) {
			replot(plot[key]);
		}
	// For line charts
	} else {
		replot(plot);
	}
}

// 2015-11-06 10219: (cliff.yeung) Support mobile for jqplot
function getDashboardBarChartWidth() {
	var winWidth = $(window).width();
	return (winWidth - 800) > 0 ? winWidth - 550 : winWidth - 150;
}

// 2014-10-08 (kevin.wong) Adjust the width and height of pop-up
function getWidth(width) {
	var browserWidth = $(window).width();
	// 2015-01-06 (cliff.yeung) Remove the border of pop-up
	// return (width > browserWidth) ? browserWidth - 10 : width;
	return (width > browserWidth) ? browserWidth : width;
}

function getHeight(height) {
	var browserHeight = $(window).height();
	// 2015-01-06 (cliff.yeung) Remove the border of pop-up
	// return (height > browserHeight) ? browserHeight - 10 : height;
	return (height > browserHeight) ? browserHeight - 5: height;
}

function getSelectedTabIndex(className) {
	var iSelectedTabIndex = $.cookie(className);
	if (iSelectedTabIndex==null) iSelectedTabIndex = 0;
	return iSelectedTabIndex;
}

// [Start] 23445: Added util function for getting position of nth occurrence of substring in a string
function getPositionOfOccurrence(string, subString, n) {
	var result = string.split(subString, n).join(subString).length;
	return result >= string.length ? -1 : result;
}
// [End] 23445

// [Start] 23445: Added util function for setting nav tab to be active
function setTabActive(index) {
	$(".ui-tabs").tabs({ active: index });
}
// [End] 23445

$(function() {
	setButtonTblColor();
	removeSaveButton();
	// var BUTTON_TABLE_HEIGHT = 48;
	// var TABS_HEIGHT = 29;
	// // For iframe
	// if($(".cbs-main_container").hasClass("cbs-iframe_main_container")) {
	// 	$(".cbs-main_container").css('min-height', $(window).height() - TABS_HEIGHT);
	// // For pop-up
	// } else {
	// 	if ($(".cbs-right-container").height() != null) {
	// 		return;
	// 	}
	// 	var horizontalTab = $(".css-tabs.ui-tabs-nav.ui-helper-reset.ui-helper-clearfix.ui-widget-header.ui-corner-all");
	// 	// For the page with vertical and horizontal tabs
	// 	if (horizontalTab.height() != null) {
	// 		$(".cbs-tab-body").css('min-height', $(window).height() - BUTTON_TABLE_HEIGHT - TABS_HEIGHT);
	// 	// For the page without vertical/horizontal tabs
	// 	} else {
	// 		$("body").css('background-image', "none");
	// 	}
	// 	// For the page with vertical tabs and without horizontal tabs
	// 	setCbsTabBodyHeight4VertTabWithoutHoriTabs();
	// 	$(".ui-tabs-anchor").click(function(){
	// 		setCbsTabBodyHeight4VertTabWithoutHoriTabs();
	// 	});
	// }

	// function setCbsTabBodyHeight4VertTabWithoutHoriTabs() {
	// 	$(".ui-tabs-panel.ui-widget-content.ui-corner-bottom").each(function() {
	// 		if ("false" == $(this).attr('aria-hidden') && "tab_popup_left_block" != $(this).children("div").children("div").attr('class') && $(this).parent().is(".ui-tabs-vertical")) {
	// 			$(this).children("div").css('min-height', $(window).height() - BUTTON_TABLE_HEIGHT  - 2);
	// 		}
	// 	});
	// }

	if ($(".helpcontent").height() != null) {
		$(".helpcontent").css("min-height", screen.height - 200);
	}
});

function setButtonTblColor() {
	// Set button table color in Javascript instead in CSS because the style attribute selector is not supported in IE
	$( "input[type='button'][name^='RightBtn']" ).css("background-color", "#000000");
	$( "input[type='button'][name^='RightBtn']" ).hover(
		function() {
			$(this).css("background-color", "#444");
		},
		function() {
			$(this).css("background-color", "#000000");
		}
	);
	$( "input[type='button'][name^='RightBtn'][style*='/cbs/images/btn_ico_save_72.png']" ).css("background-color", "#0a9348");
	$( "input[type='button'][name^='RightBtn'][style*='/cbs/images/btn_ico_add_72.png']" ).css("background-color", "#0a9348");
	$( "input[type='button'][name^='RightBtn'][style*='/cbs/images/btn_ico_save_72.png']" ).hover(
		function() {
			$(this).css("background-color", "#0dc35f");
		},
		function() {
			$(this).css("background-color", "#0a9348");
		}
	);
	$( "input[type='button'][name^='RightBtn'][style*='/cbs/images/btn_ico_add_72.png']" ).hover(
		function() {
			$(this).css("background-color", "#0dc35f");
		},
		function()	{
			$(this).css("background-color", "#0a9348");
		}
	);
}

function removeSaveButton() {
	$( "input[type='button'][name^='RightBtn'][style*='/cbs/images/btn_ico_empty_72.png']" ).remove();
}

window.onresize = function(event) {
	// var HEADER_HEIGHT = 40;
	// var STATUS_BAR_HEIGHT = 24;
	// var lWindowHeight = $(window).height() - HEADER_HEIGHT - STATUS_BAR_HEIGHT - 1;
	// var lLeftContainerHeight = $(".cbs-left-container").height();
	// if (lLeftContainerHeight > lWindowHeight) {
	// 	$(".cbs-right-container").css('height', lLeftContainerHeight);
	// } else {
	// 	$(".cbs-right-container").css('height', lWindowHeight);
	// }
};

function validateFieldByID(id, alertMsg) {
	if ($("#" + id).val().length == 0) {
		alert(alertMsg);
		return false;
	}
	return true;
}

function validateField(inputName, alertMsg) {
	if ($("input[name='" + inputName + "']").val().length == 0) {
		alert(alertMsg);
		return false;
	}
	return true;
}

function validatePort(inputName, alertMsg) {
	var port = $("input[name='" + inputName + "']").val();
	return validatePortCommon(port, alertMsg);
}

function validatePortByID(id, alertMsg) {
	var port = $("#" + id).val();
	return validatePortCommon(port, alertMsg);
}

function validatePortCommon(port, alertMsg) {
	if (/^\d{1,5}$/.test(port)) {
		iPort = parseInt(port);
		if (iPort < 0 || iPort > 65535 || isNaN(iPort)) {
			alert(alertMsg);
			return false;
		}
	} else {
		alert(alertMsg);
		return false;
	}
	return true;
}

function validateEmail(inputName) {
	if (!validateField(inputName, EMPTY_EMAIL)) {
		return false;
	}
	var email = $("input[name='" + inputName + "']").val();
	// 22206: Allow special characters of email format
	// var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
	var regex = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
	if (regex.test(email)) {
		return true;
	} else {
		alert("Invalid email address");
		return false;
	}
}

function validateIP(ip) {
	var pattern = /^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/;
	return pattern.test(ip);
}

function validateDecimal(decimal) {
	// [Start] 27867: Mobile MFA Added null checking
	if (!decimal) {
		return false;
  	}
	// [End] 27867
	var pattern = /^ *[0-9]+ *$/;
	if (decimal.search(pattern) == -1) {
		return false;
	} else {
		return true;
	}
}

function validateQuotaValue(quota) {
	var pattern = /^\d+\.\d{0,2}$/;
	if (quota.search(pattern) == -1) {
		return false;
	} else {
		return true;
	}
}

function validateHostname(hostname) {
	var pattern = /^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\-]*[A-Za-z0-9])$/;
	return pattern.test(hostname);
}

function resizeButtonTable() {
	// if ($(".cbs-right-container").css("left") == "0px") {
	// 	$(".css-buttons-table").css("width", "");
	// 	return;
	// }
	// $(".css-buttons-table").width($(window).width() - $(".cbs-left-container").width());
}

function resizeButtonTableInRightContainer() {
	// resizeButtonTable();
	// $(".ui-state-default").click(function(){
	// 	resizeButtonTable();
	// });
}

function resizeIframe(sHeaderFooterHeight4Desktop, sHeaderFooterHeight4Mobile) {
	// var HEADER_FOOTER_HEIGHT_4_DESKTOP = 187;
	// var HEADER_FOOTER_HEIGHT_4_MOBILE = HEADER_FOOTER_HEIGHT_4_DESKTOP + 78;
	// if (typeof sHeaderFooterHeight4Desktop === "undefined") {
	// 	sHeaderFooterHeight4Desktop = HEADER_FOOTER_HEIGHT_4_DESKTOP;
	// }
	// if (typeof sHeaderFooterHeight4Mobile === "undefined") {
	// 	sHeaderFooterHeight4Mobile = HEADER_FOOTER_HEIGHT_4_MOBILE;
	// }
	// var iHeaderNFooterHeight = sHeaderFooterHeight4Desktop;
	// if ($(window).width() < 800) {
	// 	iHeaderNFooterHeight = sHeaderFooterHeight4Mobile;
	// }
	// $("IFRAME").height($(window).height() - iHeaderNFooterHeight);
	// $(window).resize(function() {
	// 	iHeaderNFooterHeight = sHeaderFooterHeight4Desktop;
	// 	if ($(window).width() < 800) {
	// 		iHeaderNFooterHeight = sHeaderFooterHeight4Mobile;
	// 	}
	// 	$("IFRAME").height($(window).height() - iHeaderNFooterHeight);
	// });
}

// 2015-06-29 (cliff.yeung) 10658: Make blinking text
function blink(sClass, sHtmlValue) {
	$("." + sClass).html(sHtmlValue);
	$("." + sClass).fadeOut(500);
	$("." + sClass).fadeIn(500);
	setInterval(function() {
		$('.' + sClass).fadeOut(500);
		$('.' + sClass).fadeIn(500);
	}, 1000);
}

function openWindowWithPost(url, data) {
	var newWindow = window.open(url);
	if (!newWindow) {
		return false;
	}
	var html = "";
	html += "<html><head></head><body><form id='formid' method='post' action='" + url + "'>";
	for (var sName in data) {
		html += "<input type='hidden' name='" + sName + "' value='" + data[sName] + "'/>";
	}
	html += "</form><script type='text/javascript'>document.getElementById(\"formid\").submit()</script></body></html>";
	newWindow.document.write(html);
	return newWindow;
}

function openHelpWindowWithPost(sTab, sType, sFrom, sHelpItemOrdinal) {
	var iTabIndex = getSelectedTabIndex(sTab);
	openWindowWithPost("/cbs/help/ShowHelp.do", {'Tab':sTab, 'TabIndex':iTabIndex, 'Type':sType, 'From':sFrom, 'HelpItemOrdinal':sHelpItemOrdinal});
}

function ajax(form, callTriggerValue, sErrorTag, cookieName, loadingMask, callback) {
	var hasError = false;
	// 20318: Block the body with loading mask
	if (loadingMask) {
		$('body').getLoader().setMode('overlay').start();
	}
	$("input[name^='RightBtn']").prop("disabled", true);
	form.elements["callTrigger"].value = callTriggerValue;
	if ($("input[name=callTrigger]").val() == "") {
		$("input[name=callTrigger]").val(callTriggerValue);
	}
	$.ajax({
		type: 'POST',
		url: location.href,
		data: $(form).serialize(),
		success: function(data, textStatus, jqXHR) { // data:null, textStatus:success
			if (cookieName != null && cookieName != "") {
				$.cookie(cookieName, 1);
			}
			if (data == null || (data.substr(0, sErrorTag.length) != sErrorTag && data.substr(0, 6) != "[Info]")) {
				var sParentAction = jqXHR.getResponseHeader("parentAction");
				// session expired
				if (sParentAction == null) {
					sParentAction = location.href;
				}
				// For confirm pop up, do not set the window location that refresh the page
				if (data.substr(0, 9) != "[Confirm]") {
					// [Start] 21245: Try catch block is required for IE/Edge interpreter checking
					try {
						window.location.href = sParentAction;
					} catch (error) {
						// Ignore any error
					}
					// [End] 21245
				}
				// 20318: Remove the loading mask after ajax
				if (loadingMask) {
					$('body').getLoader('overlay').finish();
				}
			} else {
				hasError = true;
				$("input[name^='RightBtn']").prop("disabled", false);
				if (typeof handleAjaxJsonResp !== 'undefined' && $.isFunction(handleAjaxJsonResp)) {
					if (handleAjaxJsonResp(getAjaxErrMsg(data))) {
						return;
					}
				}
				alert(getAjaxErrMsg(data));
			}
		},
		error: function(data, textStatus, jqXHR) {
			hasError = true;
			var sMsg = '';
			if (data.status === 0) {
				sMsg = 'Not connect. Please verify Network.';
			} else if (data.status == 404) {
				sMsg = 'Requested page not found. [404]';
			} else if (data.status == 500) {
				sMsg = 'Internal Server Error [500].';
			} else if (textStatus === 'parsererror') {
				sMsg = 'Requested JSON parse failed.';
			} else if (textStatus === 'timeout') {
				sMsg = 'Time out error.';
			} else if (textStatus === 'abort') {
				sMsg = 'Ajax request aborted.';
			} else {
				sMsg = 'Uncaught Error. ' + data.responseText;
			}
			alert(sMsg);
		},
		complete: function(data, textStatus, jqXHR) {
			if (hasError || textStatus != "success") {
				$("input[name^='RightBtn']").prop("disabled", false);
				// 20318: Remove the loading mask after ajax
				if (loadingMask) {
					$('body').getLoader('overlay').finish();
				}
			}
			if (typeof(callback) == 'function') {
				callback(data, textStatus, jqXHR, hasError);
			}
		}
	});
}

function changeIndexDivWidth() {
	if ($(window).width() <= 800) {
		$(".cbs-menu_box-text4, .cbs-menu_box-text4-reseller").css('font-size', 24 - ((800 - $(window).width()) * (24 - 14) / (800 - 360)));
		$(".cbs-menu_box-text4 img, .cbs-menu_box-text4-reseller img").css('height', 220 / 800 * $(window).width());
		$(".cbs-menu_box-mon, .cbs-menu_box-sys, .cbs-menu_box-bkup_restore, .cbs-menu_box-rps, .cbs-menu_box-rdr, .cbs-menu_box-mon-reseller, .cbs-menu_box-sys-reseller, .cbs-menu_box-bkup_restore-reseller").css('height', "");
		return;
	}
	$(".cbs-right-container").css('max-height', '0px');
	var HEADER_N_FOOTER_HEIGHT = 48 + 48;
	var H2_HEIGHT = 50 * 3;
	var CONTAINER_HEIGHT = ($(window).height() - HEADER_N_FOOTER_HEIGHT - 20);
	var iRatio = 1.5;
	if ($(window).height() > 629) {
		iRatio = 1.73
	}
	/*$(".cbs-1280_container").css('max-width', ((CONTAINER_HEIGHT - H2_HEIGHT) * iRatio + H2_HEIGHT) + "px");*/
	var iMenuBoxHeight = (CONTAINER_HEIGHT * 0.33 - 50);
	$(".cbs-menu_box-mon").css('height', iMenuBoxHeight);
	$(".cbs-menu_box-sys").css('height', iMenuBoxHeight);
	$(".cbs-menu_box-bkup_restore").css('height', iMenuBoxHeight);
	$(".cbs-menu_box-rps").css('height', iMenuBoxHeight);
	$(".cbs-menu_box-rdr").css('height', iMenuBoxHeight);

	var iResellerMenuBoxHeight = (CONTAINER_HEIGHT * 0.5 - 55);
	$(".cbs-menu_box-mon-reseller").css('height', iResellerMenuBoxHeight);
	$(".cbs-menu_box-sys-reseller").css('height', iResellerMenuBoxHeight);
	$(".cbs-menu_box-bkup_restore-reseller").css('height', iResellerMenuBoxHeight);

	$(".cbs-menu_box-text4").css('font-size', (CONTAINER_HEIGHT / 737 * 18));
	$(".cbs-menu_box-text4-reseller").css('font-size', (CONTAINER_HEIGHT / 737 * 24));
	$(".cbs-menu_box-text4 img").css('height', (iMenuBoxHeight * 0.6));
	$(".cbs-menu_box-text4-reseller img").css('height', (iResellerMenuBoxHeight * 0.6));
}

function getNEditSerializedForm(form, dataName, dataValue) {
	var serializeArray = $(form).serializeArray();
	var idx;
	for (idx = 0; idx < serializeArray.length; idx++) {
		if (serializeArray[idx].name == dataName) {
			serializeArray[idx].value = dataValue;
			break;
		}
	}
	if (idx >= serializeArray.length) {
		serializeArray.push({
			name: dataName,
			value: dataValue
		});
	}
	return jQuery.param(serializeArray);
}

function isFnExist(FunctionName) {
	if (typeof FunctionName == 'function') {
		return true;
	}
	return false;
}

// 20318: Global Loading Event
(function($) {
	$.fn.getLoader = function(mode) {
		return new Loader($(this), mode);
	};

	var Loader = function(elem, mode) {
		this.mode = (mode != undefined && mode != null) ? mode.toLowerCase() : "";
		this.elem = [];
		if (elem != undefined && elem != null) {
			if (elem instanceof jQuery) {
				for (var i = 0; i < elem.length; i++) {
					if (this.mode == "" || Loader.hasLoader($(elem[i]), this.mode)) this.elem.push($(elem[i]));
				}
			}
		}
	};

	Loader.hasLoader = function(elem, mode) {
		switch(mode) {
			case "spinner": default:
				return elem.find('.loader.loader-spinner').length > 0;
			case "overlay":
				return elem.find('.loader.loader-overlay').length > 0;
		}
	};

	Loader.prototype.get = function(index) {
		return (this.elem[index] != undefined && this.elem[index] != null) ? new Loader(this.elem[index]) : null;
	};

	Loader.prototype.getMode = function() { return this.mode; };

	Loader.prototype.setMode = function(mode) { this.mode = mode; return this; };

	Loader.prototype.start = function(callback, timeout, timeout_callback) {
		switch(this.mode) {
			case "spinner": default:
				return this.startSpinner(callback, timeout, timeout_callback);
			case "overlay":
				return this.startOverlay(callback, timeout, timeout_callback);
		}
		return this;
	};

	Loader.prototype.startSpinner = function(callback, timeout, timeout_callback) {
		var mode = this.mode;
		$.each(this.elem, function() {
			var $elem = $(this);
			if (!Loader.hasLoader($elem, mode)) {
				var $spinner = $('<div />').addClass('fa-pulse fa-pulse-12 loader loader-spinner');
				$elem.addClass('loader-wrapper').prepend($spinner);
			}
			if (timeout != undefined && timeout > 0) {
				setTimeout(function() { $elem.getLoader().finish(timeout_callback); }, timeout);
			}
		});
		if (typeof callback === 'function') callback();
		return this;
	};

	Loader.prototype.startOverlay = function(callback, timeout, timeout_callback) {
		var mode = this.mode;
		$.each(this.elem, function() {
			var $elem = $(this);
			if (!Loader.hasLoader($elem, mode)) {
				var $overlay = $('<div />').addClass('loader loader-overlay')
					.append($('<div />').addClass('fa-pulse fa-pulse-12 loader-spinner'));
				$elem.addClass('loader-wrapper').prepend($overlay);
			}
			if (timeout != undefined && timeout > 0) {
				setTimeout(function() { $elem.setLoaded(callback_loaded); }, timeout);
			}
		});
		if (typeof callback === 'function') callback();
		return self;
	};

	Loader.prototype.finish = function(callback) {
		$.each(this.elem, function() {
			var $elem = $(this);
			if (!$elem.hasClass('loader-wrapper')) return true; // continue;
			var $loader = $elem.find('.loader');
			if ($loader.length <= 0) return true; // continue;
			$loader.fadeOut().promise().done(function() {
				$loader.remove();
				$elem.removeClass('loader-wrapper');
			});
		});
		if (typeof callback === 'function') callback();
		return this;
	};

	var LoadingEvent = function () {
	};

	LoadingEvent.prototype.setLoading = function(selector, context, mode) {
		if (this.parent() != null) {
			this.parent().setLoading(selector, context, mode);
			return this;
		}
		$elem = $(selector, context);
		if ($elem.length <= 0) $elem = $('body', document); // loading overlay for the body
		if ($elem.find('.file-explorer').is(':visible')) return;
		$elem.getLoader().setMode(mode != undefined ? mode : 'spinner').start();
		return this;
	};

	LoadingEvent.prototype.setLoaded = function(selector, context, mode) {
		if (this.parent() != null) {
			this.parent().setLoaded(selector, context, mode);
		}
		$elem = $(selector, context);
		if ($elem.length <= 0) $elem = $('body', document); // loading overlay for the body
		$elem.getLoader(mode != undefined ? mode : 'spinner').finish();
		return this;
	};

	LoadingEvent.prototype.parent = function() {
		return parent.document != document
			&& parent.document._loadingEvent != undefined
			&& parent.document._loadingEvent != null
			? parent.document._loadingEvent
			: null;
	};

	document._loadingEvent = new LoadingEvent();
}(jQuery));

// 16573: On Leave Warning Class
var LeaveWarning = function (sClassName) {
	var self = this;
	self.sClassName = sClassName != undefined ? sClassName : '';
	self.sWarningMessage = '';
	self.isSkipWarning = false;
	if ($.cookie(self.sClassName+'.LeaveWarning') == null || $.cookie(self.sClassName+'.LeaveWarning') == '') {
		$.cookie(self.sClassName+'.LeaveWarning', 'N', {path : '/'});
	}
	self._triggerHandle = function() {
		// to be override
	};
	self._unloadHandle = function(event) {
		if (self.isSkipWarning) {
			return;
		}
		if (self.isWarnBeforeUnload()) {
			// self.destroy();
			return self.getWarningMessage();
		}
	};
	$(window).on('beforeunload', self._unloadHandle);
};

LeaveWarning.prototype.getClassName = function() { return this.sClassName; };

LeaveWarning.prototype.getWarningMessage = function() { return this.sWarningMessage; };

LeaveWarning.prototype.isWarnBeforeUnload = function() { return $.cookie(this.sClassName+'.LeaveWarning') === 'Y'; };

LeaveWarning.prototype.setWarningMessage = function(sWarningMessage) {
	this.sWarningMessage = sWarningMessage;
	return this;
};

LeaveWarning.prototype.setTriggerHandle = function(triggerHandle) {
	this._triggerHandle = triggerHandle;
	return this;
};

LeaveWarning.prototype.setWarnBeforeUnload = function(isWarnBeforeUnload) {
	$.cookie(this.sClassName+'.LeaveWarning', isWarnBeforeUnload == 'Y' || isWarnBeforeUnload == true ? 'Y' : 'N', {path : '/'});
	this._triggerHandle();
	return this;
};

LeaveWarning.prototype.skipWarning = function(isSkipWarning) {
	this.isSkipWarning = (isSkipWarning == undefined || isSkipWarning == true); // put nothing into this method = true
	return this;
};

LeaveWarning.prototype.destroy = function() {
	$(window).off('beforeunload', this._unloadHandle);
	$.cookie(this.sClassName+'.LeaveWarning', null, {path : '/'});
};

LeaveWarning.skipKeyCode = function(keyCode) {
	return keyCode != 8 // backspace
	&& keyCode != 9 // tab
	&& keyCode != 13 // enter
	&& keyCode != 32 // space
	&& keyCode != 46 // delete
	&& keyCode < 0x30 // invisible key code
}

// 24879: IE11 does not support javascript String.includes
if (!String.prototype.includes) {
	String.prototype.includes = function(search, start) {
		'use strict';
		if (typeof start !== 'number') {
			start = 0;
		}

		if (start + search.length > this.length) {
			return false;
		} else {
			return this.indexOf(search, start) !== -1;
		}
	};
}
