<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
<link rel="stylesheet" type="text/css" href="lib/help.css" />

<style>
#warningContainer {
	display:block;
	margin:20px 10% 10px 40px;
	padding:10px;
	width:80%;
	text-align:left;
	border:1px solid #ff0000;
}
#warningContainer p {margin:0 0 0 36px; padding:0; color:#ff0000; text-align:justify; font-weight:bold;}
#warningContainer ol, #warningContainer ul {color:#090; text-align:justify; margin-left:20px;}
#warningContainer .icon {
	display:block;
	float:left;
	color:#FFF;
	font-family:sans-serif, Verdana, Arial;
	font-size:18px;
	line-height:18px;
	background-color:#ff0000;
	padding:2px 10px 5px 10px;
	-moz-border-radius:12px;
	-webkit-border-radius:12px;
	border-radius:12px;
	-moz-box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	-webkit-box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	margin-top:-4px;
}
</style>

</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Two-Factor Authentication (2FA)</h1>
<P>This page contains all the settings for <%=HelpManager.getCbsShortName(request)%> that you need to configure before backup and system users can log in using two-factor authentication.</P>
<BR>


<H3>Mobile Authentication</H3>
<P>Define the host name settings that will be used for two-factor authentication during log in of users.</P>
<BR><BR>

<P><b>Requirements for Mobile Authentication:</b></P>
<UL>
<LI><%=HelpManager.getCbsShortName(request)%> v8.5.0.0 or onwards must be installed.</LI>
<LI>To use Two-Factor Authentication with https protocol, a valid SSL certificate from a trusted CA must be installed on <%=HelpManager.getCbsShortName(request)%>.  Otherwise, you will have to use http instead which means all <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> users with Two-Factor Authentication enabled will need to connect using http as well. </LI>
<LI>The firewall on the <%=HelpManager.getCbsShortName(request)%> machine must be configured to allow outbound connections to pns.ahsay.com via port 80 and 443.  Failure to do so will prevent you from signing in to <%=HelpManager.getCbsShortName(request)%>, <%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%> using Push Notification feature.
</UL>
<BR>

<P><b>Requirements for <%=HelpManager.getMobileAppName(request)%> app:</b></P>
<UL>
<LI>A mobile device with the latest version of <%=HelpManager.getMobileAppName(request)%> app and/or a TOTP Authenticator App such as Google or Microsoft Authenticator installed is available for the Two-Factor Authentication. </LI>
<LI><%=HelpManager.getMobileAppName(request)%> app must be installed on a supported Android or iOS mobile device.
    <UL>
	    <LI>For android device, android version must be Android 8 or above. </LI>
		<LI>For apple device, iOS version must be 12.0 or above. </LI>
	</UL>
	</LI>
<LI>Ensure that <%=HelpManager.getMobileAppName(request)%> app is connected to the same local WIFI network as the <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> machine.  Failure to do so will prevent the <%=HelpManager.getMobileAppName(request)%> app from performing mobile backup/restore.  </LI>
<LI>The <%=HelpManager.getMobileAppName(request)%> app or third-party authenticator app must be registered with <%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%>.  </LI>
<LI><%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%> must be connected to the internet. </LI>
<LI>The mobile device must have a valid mobile service and be able to receive SMS notifications. </LI>
<LI>The mobile device must have a functioning camera for scanning QR code to register 2FA. </LI>
<LI>To use push notification for 2FA with the <%=HelpManager.getMobileAppName(request)%> app, the mobile device must have an internet connection. </LI>
<LI>Ensure to Allow Notification on the <%=HelpManager.getMobileAppName(request)%> app for your mobile devices. </LI>
</UL>

<BR>
<P><b>Limitations:</b></P>
<UL>
<LI>Not supported for <%=HelpManager.getCbsShortName(request)%> API type accounts.</LI>
<LI>For Replication, both sending and receiving are not covered.</LI>
<LI>For Redirector, both hosting and joining are not covered.</LI>
<LI>2FA will not work in <%=HelpManager.getObmShortName(request)%> and <%=HelpManager.getAcbShortName(request)%> with version earlier than 8.5.0.0.</LI>
<LI>Not supported in Restore Application. </LI>
<LI>Not supported in <%=HelpManager.getObmShortName(request)%> running on Synology and QNAP NAS. </LI>
<LI>Not supported in Linux CLI and FreeBSD CLI </LI>
</UL>


<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Host Name</td>
        <td>Protocol, IP address and port to be used in two-factor authentication.  The host name must be a FQDN (Fully Qualified Domain Name) which consists of the host name and domain name or an external IP address.  </td>
      </tr>
	  <tr>
        <td width="20%">Require Two-Factor Authentication for system user logon</td>
        <td>System users will be required to login using two-factor authentication.  </td>
      </tr>
	  
</table>

<h3>To setup your mobile authentication:</h3>
<p>To setup two-factor authentication of users involves setting up mobile authentication and enabling two-factor authentication of users.
<OL>
<LI>Select the protocol to be used, either http or https. </LI>
<LI>Enter the "Host Name".</LI> 
<LI>Select the port, either 80 or 443.</LI>
<LI>Option: Click the [Test] button to verify the connection.</LI>
<LI>Option: Check the "Require Two-Factor Authentication for system user logon" box. </LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
<LI>To enable two-factor authentication of users: <br>
    <UL>
	    <LI>For selected <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user account, enable the <b>Two-Factor Authentication</b> in Backup / Restore > Users, Groups & Policies > Backup User > %Login Name% > User Profile > Authentication > Two-Factor Authentication. </LI>
		<LI>For several/all <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user accounts at once go to Backup / Restore > Users, Groups & Policies > Backup User.  Change the "View" to 2FA.  Check the box in front of the users that you want to enable 2FA.  Click the <img src="../images/ico_24_mfa.png" class="round_button"> button and click "Enable".   </LI>
		<LI>For all <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user accounts, enable the <b>Require Two-Factor Authentication for user logon</b> setting in Backup / Restore > Users, Groups & Policies > Policy Group > %policy name% > User Settings > Two-Factor Authentication.  </LI>
	</UL>
	Once enabled, on the next login for all <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> v8.5.0.0 or above clients which support Mobile Authentication 2FA or <%=HelpManager.getCbsShortName(request)%> web console user login, will be required to register a mobile device for the new Mobile Authentication 2FA.  Otherwise, they will not be allowed to proceed with the login.  </LI>
</OL> 

<div id="tipsContainer"><div class="icon">!</div>
<p>Although the 2FA setting have been setup on the <%=HelpManager.getCbsShortName(request)%> server, you have to enable 2FA for each <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user account before they can use it. </p>
</div>
<BR>
<H3>To modify your mobile authentication:</H3>
<OL>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>

<BR>
<H3>To migrate users from Twilio to Mobile Authentication:</H3>

<div id="warningContainer">
	<div class="icon">!</div>
   <p>Warning: Once you have enabled Mobile Authentication, the Twilio Credentials Verification will automatically be deleted from the system and it will not be possible to re-enable it at a later date.</p>
</div>
<br>
<OL>
<LI>Switch on <b>Mobile Authentication</B>.  </LI>
<LI>Click "Confirm". </LI>
<LI>Twilio Credentials Verification is now deleted.  Set up mobile authentication and click <img src="../images/save.png"> to save.  </LI>
<LI>Enable for your users by enabling the <b>Require Two-Factor Authentication for user logon</b> setting. </LI>
</OL>



<br>


<hr>
<BR>
<H3>Twilio Credentials Verification</H3>
<P>For users on <%=HelpManager.getCbsShortName(request)%> v8.3.0.30 until v8.3.6.x using Twilio, after upgrading to the latest <%=HelpManager.getCbsShortName(request)%> v8.5.0.0 or above, the existing Twilio Credentials setup will be migrated to the new version.  So existing users can still continue using Twilio for two-factor authentication. <br>
However, if Twilio has not been setup in the previous <%=HelpManager.getCbsShortName(request)%> version, setup of Twilio is desupported in <%=HelpManager.getCbsShortName(request)%> v8.5.0.0.  Only modification of existing Twilio setting is allowed.</P>

<!--BR>
<P>Twilio Requirement:</P>
<UL>
<LI>A paid Twilio account is needed to be able to use your account without restrictions.</LI>
</UL>
<BR>
<P>Twilio Limitations:</P>
<UL>
<LI>A Twilio Free Trial account will also work but you will be limited to  using only the Phone number as the authentication method, once your balance runs out you cannot use it anymore.  For more information regarding the limitations of a free trial account please visit this <a href="https://support.twilio.com/hc/en-us/articles/223136107-How-does-Twilio-s-Free-Trial-work-">page</a>.  </LI>
<LI>For Trial account, the passcode will only be received by the user if it is added in the Verified Caller IDs of the account. </LI>
<LI>Verify if there are any service or feature restrictions in your country, due to legal regulations or restrictions imposed by local telecoms provider which will affect the operation of your backup service when Twilio Credentials Verification is turned on.  For examples of said restrictions, see country guidelines for <a href="https://www.twilio.com/guidelines/fr/sms">France</a> and <a href="https://www.twilio.com/guidelines/br/sms">Brazil</a>.</LI>
<LI>Not all 2FA authentication methods may be available in every country.  Phone Number, Alphanumeric Sender ID, Short Code and Messaging Service ID are the choices for the authentication method.  Short Code authentication method is only available in the <a href="https://www.twilio.com/docs/glossary/what-is-a-short-code">US, Canada and UK</a>. </LI>
<LI>The Alphanumeric Sender ID authentication method is not available for all countries, check out the <a href="https://support.twilio.com/hc/en-us/articles/223133767-International-support-for-Alphanumeric-Sender-ID">list of supported countries</a>. </LI>
<LI>For the <a href="https://support.twilio.com/hc/en-us/articles/223181388-Can-I-create-a-Messaging-Service-and-add-phone-numbers-using-API-">Messaging Service ID</a>, limitations are the same depending on which authentication method will be set up. </LI>
</UL>

<div id="tipsContainer"><div class="icon">!</div>
<p>To sign up for a Twilio account, please go to the <a href="https://www.twilio.com/try-twilio">Twilio sign up page</a>.  All Twilio account starts with a free trial, to upgrade to a paid Twilio account please refer to this <a href="https://support.twilio.com/hc/en-us/articles/223183208-Upgrading-to-a-paid-Twilio-Account">page</a> for instructions. </p> <br>
<p>SMS work differently in every country, check the <a href="https://www.twilio.com/guidelines/sms">country guidelines</a> for more information. </p> <br>
<p>Make sure your balance does not reach $0.00 because your account will be suspended and you will not be able to send SMS messages.  For more information on billing please refer to this <a href="https://support.twilio.com/hc/en-us/articles/223135487-How-Twilio-billing-works">page</a>. </p>
</div>
<BR-->


<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Account SID</td>
        <td>Twilio account security identifier.  </td>
      </tr>
	  <tr>
        <td width="20%">Auth Token</td>
        <td>Twilio authentication token.  </td>
      </tr>
	  <tr>
        <td width="20%">Sender</td>
        <td>The type of sender used for sending sms.    </td>
      </tr>
	  <tr>
        <td width="20%">Passcode length</td>
        <td>The length of the passcode that will be sent to the user.  Choice of 6, 7 or 8.  Default is 6.  </td>
      </tr>
	  <tr>
        <td width="20%">Resend cooldown time</td>
        <td>The time in minutes when the resend button will be available again.  Choice of 1, 2, 5, 10, 15, 30 or 60.  Default is 1 minute.  </td>
      </tr>
	  <tr>
        <td width="20%">Expiry time</td>
        <td>The alloted time in minutes to enter the passcode.  Choice of 5, 10, 15, 30 or 60.  Default is 5 minutes. </td>
      </tr>
	  <tr>
        <td width="20%">Consecutive invalid passcode attempts allowed</td>
        <td>The number of times the user will be allowed to enter the passcode before the account is locked.  Choice of 5, 10, 15, 30 or 60.  Default is 5 times. </td>
      </tr>
	  <tr>
        <td width="20%">Consecutive send allowed</td>
        <td>The number of times resending of passcode will be allowed.  Choice of 5, 10, 15, 30 or Unlimited.  Default is 5 times.   </td>
      </tr>
	  <tr>
        <td width="20%">Allow legacy client to skip SMS authentication</td>
        <td>Legacy clients will be allowed to skip SMS authentication.  Legacy clients are <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> users who has an old version of <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> installed who then upgraded to the latest version.  Examples of legacy clients are those who still use version 6, 7 or versions earlier than 8.3.0.0  </td>
      </tr>
</table>

<div id="warningContainer">
	<div class="icon">!</div>
   <p>Warning: Do not forget to check the <b>Allow legacy client to skip SMS authentication</b> box if you are using an older version of <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> or else your users will not be able to login and your scheduled and continuous backups will not run.  All functions requiring access and authentication to <%=HelpManager.getCbsShortName(request)%> will not work.</p>
</div>

<!--h3>To setup your two-factor authentication:</h3>
<OL>
<LI>Enter the "Account SID" and "Auth Token" in the boxes.</LI> 
<LI>Select the "Sender" type, "Country Code" and enter the details of the sender.</LI>
<LI>Option: Click the [Test] button to verify Twilio credentials.</LI>
<LI>Select the "Passcode length", "Resend cooldown time", "Expiry time", "Consecutive invalid passcode attempts allowed" and "Consecutive send allowed". </LI>
<LI>Option: Check the "Allow legacy client to skip SMS authentication" box </LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 

<div id="tipsContainer"><div class="icon">!</div>
<p>Although the 2FA setting have been setup on the <%=HelpManager.getCbsShortName(request)%> server, you have to enable 2FA for each <%=HelpManager.getObmShortName(request)%>/<%=HelpManager.getAcbShortName(request)%> user account before they can use it. </p>
</div-->
<BR>
<H3>To modify your Twilio Credentials:</H3>
<OL>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>



<BR><BR>
<BR><BR>



</div>
</body>
<jsp:include page="footer.jsp" />


</html>
