<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
<style>
#warningContainer {
	display:block;
	margin:20px 10% 10px 40px;
	padding:10px;
	width:80%;
	text-align:left;
	border:1px solid #ff0000;
}
#warningContainer p {margin:0 0 0 36px; padding:0; color:#ff0000; text-align:justify; font-weight:bold;}
#warningContainer ol, #warningContainer ul {color:#090; text-align:justify; margin-left:20px;}
#warningContainer .icon {
	display:block;
	float:left;
	color:#FFF;
	font-family:sans-serif, Verdana, Arial;
	font-size:18px;
	line-height:18px;
	background-color:#ff0000;
	padding:2px 10px 5px 10px;
	-moz-border-radius:12px;
	-webkit-border-radius:12px;
	border-radius:12px;
	-moz-box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	-webkit-box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	box-shadow:2px 2px 3px rgba(0,0,0,0.2);
	margin-top:-4px;
}
</style>
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorSystemPanel">General</h1>
<P>This page contains all the settings for the <%=HelpManager.getCbsShortName(request)%> server that you need to configure before backup users can visit your <%=HelpManager.getCbsShortName(request)%>.</P>

<H3>Host</H3>
<P>Define the host name of this <%=HelpManager.getCbsShortName(request)%> instance.</P>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Host Name</td>
        <td>The host name of your <%=HelpManager.getCbsShortName(request)%>.  You can use the following formats: www.mybackup.com:port_number or IP:port_number 
        </td>
      </tr>
</table>

<BR>
<h4>To add a host name:</h4>
<OL>
<LI>Enter the name of the host.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<BR>
<h4>To modify the host name:</h4>
<OL>
<LI>Modify the name of the host.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 

<div id="tipsContainer"><div class="icon">i</div>

<p>The port_number is only needed for non-conventional ports.  It can be omitted for the usual ports, such as 80 and 443. </p>
 <p>Ensure that the host name is accessible to users from external network environment since this will be the access link for users to get access to <%=HelpManager.getCbsShortName(request)%>. </p>
</div>


<BR><BR>

<hr>
<H3>System Home</H3>
<P>Define the system directory to store the group policy settings and log files for <%=HelpManager.getCbsShortName(request)%>, Backup Server, Replication Server, and Redirector. It is recommended that the system home is located on a separate drive from the system drive to improve performance.</P>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">System home directory</td>
        <td>Relative path of the system home.  By default set to the path of your installation home. 
        </td>
      </tr>
</table>
<BR>
<h4>To modify the system home:</h4>
<OL>
<LI>Modify the path of the system home.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<div id="tipsContainer"><div class="icon">i</div>
<p>It is recommended the system home be located on a dedicated local drive for optimal performance and not on the same drive as the operating system.</p></div>
<BR><BR>


<hr>
<H3>Connectors</H3>
<P><%=HelpManager.getCbsShortName(request)%> is bundled with Apache Tomcat web server for running the web management console. Define the web server IPs and their settings so that visitors to <%=HelpManager.getCbsShortName(request)%> web console and the backup users can access their required services correctly.</P>

<div id="warningContainer">
	<div class="icon">!</div>
   <p>Warning: Do not remove the last HTTPS connector in the <%=HelpManager.getCbsShortName(request)%>. If you remove the last HTTPS connector, you will not be able to login to <%=HelpManager.getCbsShortName(request)%> again.</p>
</div>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">IP</td>
        <td>This is designed for servers with multiple IP addresses. This attribute specifies which IP address will be used for listening on the specified port. If only 1 IP address is used on your system, the default value 0.0.0.0 can be used. 
        </td>
      </tr>
      <tr>
        <td width="20%">Port</td>
        <td>The TCP port number on which this connector will create a server socket and await incoming connections. Please make sure this port is not occupied by other application in your system. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Protocol</td>
        <td>Sets the protocol to handle incoming traffic.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Max Threads</td>
        <td>The maximum number of threads that <%=HelpManager.getCbsShortName(request)%> will process at any given time.  Default is set at 200.
        </td>
      </tr>
      <tr>
        <td width="20%">Max Connection</td>
        <td>The maximum number of connections that <%=HelpManager.getCbsShortName(request)%> will accept and process at any given time.  Default is set at 10000. 
        </td>
      </tr>
      <tr>
        <td width="20%">Connection Timeout</td>
        <td>The number in milliseconds that this connector will wait.  Default is set at 10000.
        </td>
      </tr>
	  <tr>
        <td width="20%">Connection Upload Timeout</td>
        <td>The number in milliseconds that this connector will wait during upload.  Default is set at 900000.
        </td>
      </tr>
      <tr>
        <td width="20%">Max Keep Alive Request</td>
        <td>This is the maximum number of requests to serve on a TCP connection.  Default is set at 9999.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Socket Receive Buffer Size</td>
        <td>This is the size in bytes of the receive buffer socket.  Default is set at 25188.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Socket Send Buffer Size</td>
        <td>This is the size in bytes of the send buffer socket.  Default is set at 43800.  
        </td>
      </tr>
	  <tr>
        <td width="20%">SSL Certificate</td>
        <td>This is the SSL certificate installed.  
        </td>
      </tr>
</table>
<BR>

<h3>To add a new web server connector:</h3>
<OL>
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Enter the value in the boxes.</LI> 
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
 
<BR>
<H3>To modify an existing web server connector:</H3>
<OL>
<LI>Click on an existing web server connector.</LI>
<LI>Modify the values according to your requirement.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>

<BR>
<H3>To delete an existing web server connector:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>


<hr>

<H3>SSL Certificate</H3>
<P>Generate CSR (Certificate Signing Request) for this <%=HelpManager.getCbsShortName(request)%>. </P>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>The name of the certificate.
        </td>
      </tr>
      <tr>
        <td width="20%">Common Name</td>
        <td>To secure https://www.backup.com, your common name must be www.backup.com or *.backup.com for a wildcard certificate.
        </td>
      </tr>
      <tr>
        <td width="20%">Organization Unit</td>
        <td>This is the department within your organization which you want to appear in the certificate. It will be listed in the certificate's subject as Organizational Unit, or "ou." Common examples: "Web Administration", "Web Security", "Marketing"
        </td>
      </tr>
      <tr>
        <td width="20%">Organization Name</td>
        <td>The exact legal name of your organization. Example: "Backup Vault Inc." 
        </td>
      </tr>
      <tr>
        <td width="20%">Location</td>
        <td>The city where your organization is legally located.
        </td>
      </tr>	 
      <tr>
        <td width="20%">State</td>
        <td>The state or province where your organization is legally located.
        </td>
      </tr>
      <tr>
        <td width="20%">Country</td>
        <td>The country code where your organization is legally located. 
        </td>
      </tr>
      <tr>
        <td width="20%">Expiry Date</td>
        <td>The expiry date of the certificate.
        </td>
      </tr>
      <tr>
        <td width="20%">Status</td>
        <td>The status of the certificate.  
        </td>
      </tr>
</table>

<BR>

<h4>To generate a new CSR to apply the SSL certificate:</h4>
<OL>
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Enter the fields required in the boxes.</LI> 
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Save the newly generated CSR and apply your SSL certificate through valid CA.</LI>
</OL> 
<BR>

<h4>To import a SSL cert or CA cert for the generated CSR:</h4>
<OL>
<LI>Click on the certificate entry in this section. </LI>
<LI>Click on the [Choose File] button under the "SSL Private Key" to locate for the ssl.key file.</LI> 
<LI>Click on the [Choose File] button under the "SSL Certificate" to locate for the ssl.crt file.</LI>
<LI>Save the newly generated CSR and apply your SSL certificate through valid CA.</LI>
</OL> 
<BR><BR>

<hr>

<H3>Cookie Banner Notification</H3>
<p>To comply with the new General Data Protection Regulation (GDPR) requirements, a banner will be displayed stating the organizations cookie policy when processing to login to the <%=HelpManager.getCbsShortName(request)%> server and web console. From <%=HelpManager.getCbsShortName(request)%> version 7.15.6.0 onwards, administrator can configure a notification banner to be displayed on the <%=HelpManager.getCbsShortName(request)%> web console (displayed at the login interface), and HTML codes can be used for content of the banner.  </p>


<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
