<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
<link rel="stylesheet" type="text/css" href="lib/help.css" />
</head>

<body>
<div class="helpcontent">
  
 <h1 class="colorSystemPanel">Password</h1>
<P>Setup password complexity requirement that will be followed when system user change their password.</P>
<BR>

<P>Here are the following conditions wherein the user needs to change the password:
<UL>
<LI>User logs in as default system user for the first time </LI>
<LI>Password of default system user was changed back to "system" </LI>
<LI>System user password has expired </LI>
</UL>
</P>


<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Password Age</td>
        <td>Allow administrator to define the period of time when the login password of a system user account expires.  Default is 90 days.
		</td>
      </tr>
      <tr>
        <td width="20%">Enforce password history</td>
        <td>If this option is selected, it will not allow users to re-use password within the last 30 password change.  Enabled by default. 
		</td>
      </tr>
      <tr>
        <td width="20%">Complexity Requirements</td>
        <td>Allow administrator to set password complexity using a mixture of numbers, upper and lower case, minimum length and special characters. Regular expression and Custom Description are also supported.  'Default' is selected by default with numbers, uppercase, lowercase, special characters and minimum length of 6 required.  
		</td>
      </tr>
</table>
<BR>
<H3>To add the password complexity requirement:</H3>
<OL>
<LI>Slide the switch to the right hand side to turn on the password option. </LI>
<LI>Select the desired number of days before password expires, either select 'Never expire' or check the radio button then select the password age days from the drop down box.</LI>
<LI>Option: Check the check box of "Enforce password history".</LI>
<LI>Select the password complexity requirement, either 'Default' or 'Custom'.  If 'Default' is selected, click on the required check box in the default section.  If 'Custom' is selected, enter the regular expression and/or custom description in the field provided.</LI>  
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>

<BR><BR>

  
  
<hr> 
<BR>
<h1 class="colorSystemPanel">Manage System User</h1>
<P>Manage system user accounts with different user type to manage your <%=HelpManager.getCbsShortName(request)%>.</P>

<H3>System User</H3>
<P>Allow you to setup admin, sub-admin and non-admin users with different access privileges to manage your <%=HelpManager.getCbsShortName(request)%>.</P>
<BR>
<P><Strong>"Admin"</Strong> role has the same privilege as the build-in "system" account. For example, you can assign this account for your administrator(s) to configure/administrate the <%=HelpManager.getCbsShortName(request)%> for you. </p>
<BR>
<P><Strong>"Read-only Admin"</Strong> role system user shares the similar accessibility as its creator except with read permission only.</P>
<BR>
<P><Strong>"API"</Strong> user has the full access right to the system, it has the same privilege as the build-in "system" account. This account is created for programmers which required to put the API user name and password into their program source.</P>
<BR>
<P><Strong>"Sub Admin"</Strong> user has the full access right to the users that was created under this sub admin and has the right to manage the backup and restore jobs/activity similar as the system administrator with less admin options. </P>
<BR>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
	  <tr>
        <td width="20%">View</td>
        <td>Information displayed regarding the system users may be changed, either by Default or 2FA.  This will only be available if 2FA is enabled.  By default, the Default view is displayed. 
        </td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>Name of the account. 
        </td>
      </tr>
      <tr>
        <td width="20%">Type</td>
        <td>4 types of system accounts are available:
		   <UL>
		       <LI>Admin -- From v7.15.0.0 onwards, <%=HelpManager.getCbsShortName(request)%> allow Admin role user account to independently disable or enable Sub Admin user account access right to the branding pages.</LI> 
		       <LI>Read-only Admin</LI>
			   <LI>API</LI>
			   <LI>Sub Admin</LI>
		   </UL>
        </td>
      </tr>
	  <tr>
        <td width="20%">Owner</td>
        <td>Owner of the account. 
        </td>
      </tr>
      <tr>
        <td width="20%">Status </td>
        <td>Status of the account, either Enable, Suspended or Locked.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Two-Factor Authentication </td>
        <td>The status of two-factor authentication, either Enabled or Disabled.  Will only be displayed in 2FA view.
        </td>
      </tr>
</table>
<BR>

<P>There are four (4) functions available for each system user:</P>
<UL>
<LI><img src="../images/ico_24_add.png" class="round_button"> <b>Create</b> - this is used to create a new system user account.</LI>
<LI><img src="../images/ico_24_delete.png" class="round_button"> <b>Delete</b> - this is used to delete an existing system user account.</LI>
<LI><img src="../images/ico_24_broadcast.png" class="round_button"> <b>Broadcast</b> - this is used to send messages to system user account.  Message will be sent to the email address that was provided in the contacts for each system user account.  This is very useful when there is an announcement that must be sent to system users, i.e. backup server system maintenance.</LI>
<LI><img src="../images/ico_24_mfa.png" class="round_button"> <b>Enable / Disable Two-Factor Authentication</b> - this is used to enable or disable the 2FA feature for several system users all at once.  This will only be available if 2FA view is selected. </LI>
</UL>


<BR>
<h3>To add a new system user account:</h3>
<OL>
<LI>Click the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Configure the details according to your requirement.</LI> 
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<BR>
<H3>To modify an existing system user account:</H3>
<OL>
<LI>Click on an existing system account.</LI>
<LI>Modify the values according to your requirement.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>
<H3>To delete an existing system user account:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click <img src="../images/ok.png"> to delete or <img src="../images/cancel.png"> to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>

<BR>
<h3>To send message to system user:</h3>
<OL>
<LI>Click on the check box at the front of the entry. </LI>
<LI>Click the <img src="../images/ico_24_broadcast.png" class="round_button"> button in this section. </LI>
<LI>Configure the details according to your requirement.</LI> 
<LI>Click [Send] to send the message.</LI>
</OL> 

<BR>
<h3>To enable/disable 2FA of system user:</h3>
<OL>
<LI>Click on the check box at the front of the entry. </LI>
<LI>Click the <img src="../images/ico_24_mfa.png" class="round_button"> button in this section. </LI>
<LI>Select either [Enable] or [Disable].</LI> 
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 

<BR><BR>
<BR><BR>
<BR><BR>




</div>
<jsp:include page="footer.jsp" />
</body>

</html>
