<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorBackupServer">Runtime Options</h1>

<H3>Java Options</H3>
<P>Maximum Java heap is the heap allocated to JVM (Java Virtual Machine), the JVM has a heap that is the runtime data area from which memory for all class instances and arrays are allocated, it is created at the JVM start-up. If the memory usage exceeds the maximum Java heap size this will result in out of memory errors which will cause <%=HelpManager.getCbsShortName(request)%> to become unstable. The runtime options are recommended to be modified by experienced administrators.</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Maximum Java heap size to be used</td>
        <td>The maximum amount of memory allocated.  Default is 2048 MB.  
        </td>
      </tr>  
      <tr>
        <td width="20%">Minimum Java heap size to be used</td>
        <td>The minimum amount of memory allocated.  Default is 512 MB.
        </td>
      </tr>
	  <tr>
        <td width="20%">Thread stack size to be used</td>
        <td>The amount of memory allocated for the thread stack.  Default is 384 KB.
        </td>
      </tr>
	  <tr>
        <td width="20%">Whether to disable signal handlers</td>
        <td>Allows user not to use signal handlers.  This is enabled by default.
        </td>
      </tr>
</table> 

<div id="tipsContainer"><div class="icon">!</div>
<p>When editing the maximum heap size, ensure that there is sufficient memory reserved for the operating system. </p> <br>
<p>It is not recommended to set excessively high values for the maximum Java heap size, as this could result in <%=HelpManager.getCbsShortName(request)%> performance issues during internal Java VM garbage collection or memory recycling routines. </p> <br>
<p>For changes in the Java heap size setting the <%=HelpManager.getCbsShortName(request)%> service needs to be restarted before it becomes effective. </p>
</div>

<BR>
<H3>To modify the java options:</H3>
<OL>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>



<BR>
<hr>

<H3>IP Allowed</H3>  
<P>Set the IP address range that will be allowed to access the system. For example, you can set a range of internal IP for your system administrator to access the <%=HelpManager.getCbsShortName(request)%>. </P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">From</td>
        <td>The "from" range of IPs allowed to access the system.   
        </td>
      </tr>  
      <tr>
        <td width="20%">To</td>
        <td>The "to" range of IPs allowed to access the system.
        </td>
      </tr>
</table> 
<BR>

<H3>To add the IP Allowed option:</H3>
<OL>
<LI>Click on <img src="../images/round_add.png"> in this section to add an IP Allowed. </LI>
<LI>Enter the "From" IP range and "To" IP range.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>

<H3>To modify an existing IP Allowed:</H3>
<OL>
<LI>Click on an existing IP Allowed.</LI>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/ok.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>

<H3>To delete an existing IP Allowed:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>

<hr>

<H3>Prevent Session Hijacking</H3>  
<P>To prevent session hijacking, if this feature is enabled, the system will force the current user session to be logged out immediately once it detects that the IP address of the session has changed from the IP address used when it logged in. </P>


<BR><BR>
<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
