<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorBackupServer">Replication</h1>
<P>You can replicate backup sets on this Backup Server to the cloud, or to a receiver of another Replication Server. Configure the replication settings of the Backup Server below. You also need to configure the receiver settings on the target Replication Server. <BR></BR> From v7.11.0.0 or above you can replicate v6 backup sets to a receiver on a v7/v8 replication server<!--this feature can be enabled by switching on the <b>Replicate v6 backup sets to v7 server</b> option-->. The v6 backup set replication feature is designed to support data migration on your backup server <i>(conversion from v6 data format to v8 data block format)</i>, it is not intended to be used as a permanent replication solution. Once the data migration process is completed the v6 replication should be disabled as the backup server will automatically remove v6 backup set data on both the backup server and replication server after the completion of data migration for each backup set.</P>
<BR>

<H3>Replicate backed up data to another server or predefined cloud storage </H3>
<P>To setup a storage for replication, please add a destination to <%=HelpManager.getCbsShortName(request)%> &gt; "System Settings" &gt; "Basic" &gt; "Predefined Destination" first. </P>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="30%">To another <%=HelpManager.getCbsShortName(request)%></td>
        <td>To replicate the backup data to a Replication Server on another <%=HelpManager.getCbsShortName(request)%>. 
      </td>
      </tr>
      <tr>
        <td width="30%">To a predefined destination. Select a destination for replication</td>
        <td>To select the cloud destination for replication. Please setup a "Predefined Destination" in the "System Settings" &gt; "Basic" tab.
      </td>
      </tr>
      <tr>
        <td width="30%">Host Name</td>
        <td>The hostname of another <%=HelpManager.getCbsShortName(request)%> for replication.  Will only be enabled if 'To another <%=HelpManager.getCbsShortName(request)%> is selected.
      </td>
      </tr>
      <tr>
        <td width="30%">Port </td>
        <td>The port number of another <%=HelpManager.getCbsShortName(request)%>.  Will only be enabled if 'To another <%=HelpManager.getCbsShortName(request)%> is selected. 
      </td>
      </tr>
      <tr>
        <td width="30%">Replicate User Name</td>
        <td>The username to login to the replication server for replication. Please create this login name on the Receiver User Account of another <%=HelpManager.getCbsShortName(request)%> first.  Will only be enabled if 'To another <%=HelpManager.getCbsShortName(request)%> is selected.  
      </td>
      </tr>
      <tr>
        <td width="30%">Replicate User Password</td>
        <td>The password to login to the replication server for replication. Please create this password on the Receiver User Account of another <%=HelpManager.getCbsShortName(request)%> first.  Will only be enabled if 'To another <%=HelpManager.getCbsShortName(request)%> is selected.  
      </td>
      </tr>
	  <tr>
        <td width="30%">Connect with SSL</td>
        <td>Connect using SSL.  Will only be enabled if 'To another <%=HelpManager.getCbsShortName(request)%> is selected. 
      </td>
      </tr>
      <tr>
        <td width="30%">Folder name in selected destination for storing replication data</td>
        <td>The replication folder name created in the storage.    
      </td>
      </tr>
	  <tr>
        <td width="30%">Use proxy</td>
        <td>Use the proxy server settings defined in "System Settings" &gt; "Advanced"  &gt;  "Proxy" 
        </td>
      </tr>
	  	  <tr>
        <td width="30%">No. of backup sets to replicate concurrently</td>
        <td>Select the number of backup set to replicate at the same time.  Default is Auto.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Port (SSL)</td>
        <td>The ssl port of the v6 backup server. 
        </td>
      </tr>
	  <tr>
        <td width="20%">From</td>
        <td>Start time of traffic limit. 
        </td>
      </tr>
      <tr>
        <td width="20%">To</td>
        <td>End time of traffic limit. 
        </td>
      </tr>
      <tr>
        <td width="20%">Maximum Transfer (Kb/s)</td>
        <td>Maximum bandwidth used between the start and end time. 
        </td>
	  </tr>
	  <tr>
        <td width="20%">Replicate new backup sets of paid users</td>
        <td>Only new backup sets of paid users will be replicated. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Replicate new backup sets of trial users</td>
        <td>Only new backup sets of trial users will be replicated. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Login Name (Alias)</td>
        <td>Name of the backup user. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Backup Set</td>
        <td>Name of the backup set. 
        </td>
      </tr><tr>
        <td width="20%">Used</td>
        <td>The amount of space used to replicate this backup set. 
        </td>
      </tr>
</table>
<BR>

<h3>To add a replication:</h3>
<OL>
<LI>Slide the switch to the right hand side to turn on replication. </LI>
<LI>For replication to another <%=HelpManager.getCbsShortName(request)%>, select "To another <%=HelpManager.getCbsShortName(request)%>".
    <UL>
     <LI>Enter the "Host Name" of the <%=HelpManager.getCbsShortName(request)%>.</LI>
	 <LI>Enter the "Port" of the <%=HelpManager.getCbsShortName(request)%>.</LI>
	 <LI>Enter the "Replicate User Name".</LI>
	 <LI>Enter the "Replicate User Password".</LI> 
	 <LI>Option: Select "Connect with SSL" if you want to connect using SSL.</LI>
    </UL>
</LI>
<LI>For replication to a predefined destination.
    <UL>
        <LI>Create a predefined destinations in <%=HelpManager.getCbsShortName(request)%> &gt; System Settings &gt; Basic &gt; Predefined Destination first.</LI>
	    <LI>Select one of the predefined destination by clicking on the radio button in front of it. </LI>
	</UL>
</LI>
<LI>Enter a "Folder name" for storing replication data.</LI> 	
<LI>Option: Select "Use proxy" if you need the proxy server to access the internet.
    
</LI>
<LI>Select the maximum number of backup sets allowed to replicate at the same time.</LI>
<LI>Option: Slide the switch to the right hand side to turn on replication of v6 backup sets to v7 or above server.    
    <UL>
		<LI>Set the ssl port of the v6 backup set server. </LI> 
	</UL> 
</LI>

<LI>Option: Slide the switch to the right hand side to turn on the traffic limit.    
    <UL>
		<LI>Click on <img src="../images/round_add.png"> button in this section. </LI>
		<LI>Set the start time of the traffic limit. </LI> 
		<LI>Set the end time of the traffic limit. </LI> 
		<LI>Set the maximum transfer rate. </LI> 
		<LI>Click <img src="../images/ok.png"> to continue.</LI>
	</UL> 
</LI>
<LI>Option: Slide the switch to the right hand side to turn on replication of individual backup sets.
    <UL>
	    <LI>Option: Select the "Replicate new backup sets of paid users" if you want to replicate new backup set created by paid users by default.</LI>
		<LI>Option: Select the "Replicate new backup sets of trial users" if you want to replicate new backup set created by trial users by default.</LI> 
		<LI>Click on <img src="../images/round_add.png"> button in this section. </LI>
		<LI>Select the users for replication.</LI>
		<LI>Click <img src="../images/next.png"> to continue.</LI>
		<LI>Select the backup sets that you want to replicate.</LI>
		<LI>Click <img src="../images/add.png"> to continue.</LI>
	</UL>
</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 

<P>
<div id="tipsContainer"><div class="icon">!</div>
<p>By default the number of backup sets to replicate concurrently is set to Auto.  This is automatically computed depending on the setting of the maximum threads for replication option which can be added in the %CBS_INSTALL_PATH%\conf\cbs.opt file.
<BR>
  <UL>
     <LI>If the maximum allowed number of replication threads is enabled, com.ahsay.cbs.obs.config.Index.RepMaxThreads=true.  <BR>
	 The default (Auto) number of concurrent backup sets = the number of CPU cores <BR>
	 There is no maximum value for the Auto value, so if the <%=HelpManager.getCbsShortName(request)%> server has a total of 64 CPU cores then the Auto value will be 64.  </LI>
	 <LI>If the maximum allowed number of replication threads is disabled (default setting), com.ahsay.cbs.obs.config.Index.RepMaxThreads=false.  <BR>
	 The default (Auto) number of concurrent backup sets = Total number of CPU cores / 8 <BR>
	 The minimum number for the Auto value is 1 while the maximum is 4. </LI>
  </UL>	 
</p>

</div>

<P>
<div id="tipsContainer"><div class="icon">!</div>
<p>In order to enable replicating v6 backup set to v7 or above server, replicate "To another <%=HelpManager.getCbsShortName(request)%>" and "Connect with SSL" must be selected. 
</p></div>

<BR>
<H3>To modify an existing replication:</H3>
<OL>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>
<H3>To disable an existing replication:</H3>
<OL>
<LI>Slide the switch to the left hand side to turn off the replication. </LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>


<!--hr>

<H3>Replicate v6 backup sets to v7 server</H3>

<P>To setup replication for v6 backup sets to a v7 replication server, slide the <b>Replicate v6 backup sets to v7 server</b> switch to right hand side to turn on the v6 backup set replication. The <b>Port (SSL)</b> is set as "9444" by default, change the parameter if necessary.</P>
<BR>

<b>Notes:</b>
 <OL>
 <LI>To use v6 backup set replication feature, the v7 replication must also be enabled to another replication server.</LI>
 <LI>v6 backup sets can only be replicated to v7 replication server but not cloud storage.</LI>
 <LI>Replication for v6 backup sets is in single thread mode only. The v6 replication thread is in addition to the v7 replication threads.</LI>
 <LI><b>Set traffic limit</b> is supported for v6 backup sets.</LI>
 <LI><b>Use proxy</b> is supported for v6 backup sets.</LI>
 <LI>Only v6 backup set data found in the <b>%USER_HOME%\%USERNAME%\files</b> folder will be replicated. The replication of other folders and files are handled by v7 replication process.</LI>
 <LI>Once the settings have been saved, the v6 replication mode (UNSYNC, SYNC, or LOGGING) will be shown next to the <b>Replicate v6 backup sets to v7 server</b> switch.</LI>
 <LI>Details of the v6 replication status can be viewed under <b>[Monitoring]>[Replication Logs]>[Replication Sending]</b>. The replication status of v6 backup sets will not be shown in <b>[Monitoring]>[Live Activities]</b>.</LI>
 <LI>Once the v6 backup set has successfully undergone data migration <i>(conversion from v6 data format to v7 data block format)</i> the backup set on the replication server will be automatically removed at the same time as the v6 backup set on the backup server.</LI>
 </OL>
</LI>
<BR>
<hr>

<!--- Set traffic limit >
<H3>Set traffic limit</H3>
<P>Limit the usage of network bandwidth by the replication service.</P>

<div id="tipsContainer">
<div class="icon">!</div>
<p>Note</p>
<UL>
<LI>The actual value will be around +/- 5% of the limit when the bandwidth control set to below 32Mb/s. When the bandwidth control set to above 64Mb/s, the gap between actual value and limit value might be over 5%.</LI>
<LI>Network stability may affect bandwidth control effectiveness.</LI>
</UL>
</div>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">From</td>
        <td>This is the start time of the traffic limit.   
      </td>
      </tr>
	  <tr>
        <td width="20%">To</td>
        <td>This is the end time of the traffic limit. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Maximum Transfer (Kb/s) </td>
        <td>Maximum transfer rate in kilo bytes per second.   
        </td>
      </tr>
</table>
<BR><BR>

<h3>To add a traffic limit:</h3>
<OL>
<LI>Slide the switch to right hand side to turn on the traffic limit. </LI>
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Set the start time of the traffic limit. </LI> 
<LI>Set the end time of the traffic limit. </LI> 
<LI>Set the maximum transfer rate. </LI> 
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<BR><BR>
<H3>To modify an existing traffic limit:</H3>
<OL>
<LI>Click on an existing traffic limit.</LI>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/ok.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>
<H3>To delete an existing traffic limit:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>
<hr>

<!--Replicate individual backup sets >
<H3>Replicate individual backup sets</H3>
<P>You can select either to replicate new backup sets created by paid users or trial users.</P>

<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Login Name (Alias)</td>
        <td>Name of the user account. 
      </td>
      </tr>
	  <tr>
        <td width="20%">Backup Set</td>
        <td>The new backup set of the user. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Used</td>
        <td>The amount of space used to replicate this backup set. 
        </td>
      </tr>
</table>
<BR><BR>

<h3>To add a user's backup set to replicate:</h3>
<OL>
<LI>Slide the switch to right hand side to turn on the replicate individual backup sets. </LI>
<LI>Option: Select the "Replicate new backup sets of paid users" if you want to replicate new backup set created by paid users by default.</LI>
<LI>Option: Select the "Replicate new backup sets of trial users" if you want to replicate new backup set created by trial users by default.</LI> 
<LI>Click on the <img src="../images/round_add.png"> button in this section. </LI>
<LI>Select the users for replication.</LI>
<LI>Click <img src="../images/next.png"> to continue.</LI>
<LI>Select the backup sets that you want to replicate.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<BR><BR>
<H3>To delete an existing user's backup set to replicate:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL-->

<hr>

<H3>To modify an existing traffic limit:</H3>
<OL>
<LI>Click on the traffic limit you want to modify. </LI>
<LI>Modify the values according to your requirement.</LI>
<LI>Click on <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>
<H3>To delete an existing traffic limit:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<hr>
<H3>To delete an existing user's backup set to replicate:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>


<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
