<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
<h1 class="colorUtilities">How to setup a different region?</h1> 

<H3>Introduction:</H3>
<P>This chapter will show you how to setup a different region in the OpenStack for your backup users.</P>
<P>If you are new to OpenStack, you should check with their documentation on general setup available at <a href="http://docs.openstack.org/">http://docs.openstack.org/</a></P>
<P>If you already have a running OpenStack, you can follow our steps to setup the different region for users. </P>
<BR><BR>

<H3>Assumptions:</H3>
<P>Here are the OpenStack version used in the following examples:</P>
<UL>
   <LI>OpenStack Havana Series, Release 2013.2.3 </LI>
   <LI>Swift version: 2.0.2</LI>
   <LI>Keystone version: 0.7.1</LI>
</UL>
<BR>
<P>Here are the values used in the following examples:</P>
<UL>
   <LI>OpenStack admin user name: admin </LI>
   <LI>OpenStack admin user password: admin</LI>
   <LI>Tenant (project) name: mybackup</LI>
   <LI>Keystone server IP: 10.7.54.7 </LI>
   <LI>Keystone user authentication URL: http://10.7.54.7:5000/v2.0 </LI>
   <LI>Keystone admin URL: http://10.7.54.7:35357/v2.0  </LI>
   <LI>Keystone admin token: 7b05dab9722d44e7b9a82dc0d1ff74ea </LI>
   <LI>Keystone server IP (Region 2): 10.7.54.8  </LI>
</UL>
<BR>
<P>Note: The value of the Keystone admin token can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf . </P>
<BR><BR>

<H3>Requirements and preparations:</H3>
<P>Please setup the following variables in bash profile before you setup a tenant (project), user, roles and storage quota etc. </P>
<P><B>Step 1: Add the environment variable in the .bash_profile</B></P>

<I>Example</I> (/root/.bash_profile)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
  Trimmed
    :
    :
export OS_USERNAME=admin
export OS_PASSWORD=admin
export OS_TENANT_NAME=mybackup
export OS_AUTH_URL=http://10.7.54.7:5000/v2.0
export OS_SERVICE_ENDPOINT=http://10.7.54.7:35357/v2.0
export OS_SERVICE_TOKEN=7b05dab9722d44e7b9a82dc0d1ff74ea
    :
    :
  Trimmed
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>Please login again for profile to take effect. </P>
<P>Note: The value of the OS_SERVICE_TOKEN can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf . </P>
<BR><BR>

<B>Step 2: Create a new region for OpenStack. </B>
<P>If you have a second OpenStack storage which you want to mount on your current OpenStack, you can setup a second region on your current OpenStack. </P>
<P>Assume the IP of the second region OpenStack is 10.7.54.8 . You need to find out the swift service id and map the second region on your current OpenStack according to the below instruction. </P>
<BR><BR>
<P>To list swift service id by keystone service list command: </P>
<P>Usage: keystone service-list</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone service-list
WARNING: Bypassing authentication using a token & endpoint (authentication credentials are being ignored).
+----------------------------------+------------+--------------+--------------------------------+
|              id                  |    name    |     type     |           description          |
+----------------------------------+------------+--------------+--------------------------------+
| 5f805cc7df2a43eb90db6fe11ed682f6 | ceilometer |   metering   |   Openstack Metering Service   |
| 3134116675a8420a88ef01cdcb0c8728 |   cinder   |    volume    |         Cinder Service         |
| b703b91737954d01a2d180f6c3d575ba |  cinder_v2 |   volumev2   |        Cinder Service v2       |
| cc787cf0258e46d6a342e1502e7bf6be |   glance   |    image     |      Openstack Image Service   |
| b3af7d0a95d34aa7883629df7a7f7f56 |  keystone  |   identity   |    OpenStack Identity Service  |
| 10f1a022ada246138aba5834e3622a91 |  neutron   |   network    |    Neutron Networking Service  |
| 218b5356d65e4d8382297f72d65c8bbb |    nova    |   compute    |    Openstack Compute Service   |
| a809ad43f380400cb55ff2520bb27ab0 |  nova_ec2  |     ec2      |          EC2 Service           | 
| 8b517bd82d4345c895384f9596a29880 |    swift   | object-store | Openstack Object-Store Service |
| 11882e74696547b0ba1e4d276074ae37 |  swift_s3  |     s3       |       Openstack S3 Service     |
+----------------------------------+------------+--------------+--------------------------------+
[root@os ~]# </font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>To add the second region (RegionTwo) to the 'swift' keystone service</P>
<P>Usage: keystone endpoint-create --region &lt;endpint-region&gt; --service-id=&lt;swift service-id&gt; --publicurl &lt;public-url&gt; --adminurl &lt;admin URL&gt; --internalurl &lt;internal-url&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone endpoint-create --region RegionTwo --service-id=8b517bd82d4345c895384f9596a29880 --publicurl
 'http://10.7.54.8:8080/v1/AUTH_%(tenant_id)s' --adminurl 'http://10.7.54.8:8080/v1' --internalurl 'http://10.7.54
.8:8080/v1/AUTH_%(tenant_id)s'
+-------------+---------------------------------------------+
|   Property  |                    Value                    |
+-------------+---------------------------------------------+
|   adminurl  |          http://10.7.54.8:8080/v1           |
|      id     |       40c018c7ff934bc4b3d8c0ce8c78d8db      |
| internalurl | http://10.7.54.8:8080/v1/AUTH_%(tenant_id)s |
|  publicurl  | http://10.7.54.8:8080/v1/AUTH_%(tenant_id)s |
|    region   |                   RegionTwo                 |
|  service_id |       8b517bd82d4345c895384f9596a29880      |
+-------------+---------------------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>

<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
 