<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Advanced Retention Policy</h1>

<!--P>Retention policy defines the policies of persistent data management for meeting business data archival requirements.</P>

<P>When a backup job is performed, for data that are modified or deleted on your computer, the existing version on the backup storage (backed up previously) would be moved into retention area, while newly backed up file would be placed in the current data area.</P>

<P>Specifically, retention policy setting defines how long are these data kept within the retention area before they are deleted permanently from the backup storage.</P>

<P>For backed up data that have not been updated or deleted from your computer, they are kept in the data area on the backup storage and remain untouched.</P>

<P>Two types of retention policy settings can be set:</P>
<P>A simple retention policy defines a basic policy where retained file (in the retention area) are removed automatically after a user specific number of days or backup jobs.</P-->

<P>An advanced retention policy defines a more advanced and flexible policy where retained file (in the retention area) are removed automatically after a combination of user defined policy, such as:</P>
<UL>
<LI>A specific number of days</LI>
<LI>A specific number of weeks, including the day of the week</LI>
<LI>A specific number of months, including the day of the month</LI>
<LI>A specific number of quarters, including the day in the quarter</LI>
<LI>A specific number of years, including the day of the year</LI>
<LI>A specific date</LI>
</UL>
<BR><BR>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>Retention policy name.
        </td>
      </tr>
      <tr>
        <td width="20%">Type</td>
        <td>Type of the retention period setting. Daily, Weekly, Monthly, Quarterly, Yearly, and Custom can be selected. 
        </td>
      </tr>
	  <tr>
        <td width="20%">The past number of days on which different versions of your files are retained</td>
        <td>Number of days how long these files are kept within the retention area.  This will only be displayed if "Daily" is selected.  Default is 7 days.
        </td>
      </tr>
	  <tr>
        <td width="20%">The days within a week on which different versions of your files are retained</td>
        <td>Specific day(s) of the week when these files are kept within the retention area.  This will only be displayed if "Weekly" is selected. 
        </td>
      </tr>
	  <tr>
        <td width="20%">The number of weeks to repeat the above selection</td>
        <td>Number of  week(s) when these files are kept within the retention area.  This will only be displayed if "Weekly" is selected.  Default is 7 weeks. 
        </td>
      </tr>
	  <tr>
        <td width="20%">The days within a month on which different versions of your files are retained</td>
        <td>The specific day of the month when these files are kept within the retention area.  It can be a specific day (1 - 31) or a general day (First, Second, Third, Fourth and Last / Sunday - Saturday, Weekday and Weekend).  This will only be displayed if "Monthly" is selected.  Default is Day 1.
        </td>
      </tr>
	  <tr>
        <td width="20%">The number of months to repeat the above selection</td>
        <td>Number of  month(s) when these files are kept within the retention area.  This will only be displayed if "Monthly" is selected.  Default is 10 months.
        </td>
      </tr>
	  <tr>
        <td width="20%">The day within a quarter on which different versions of your files are retained</td>
        <td>The specific day of the quarter when these files are kept within the retention area.  It can be a specific day (1 - 31) or a general day (First, Second, Third, Fourth and Last / Sunday - Saturday, Weekday and Weekend).  This will only be displayed if "Quarterly" is selected.  Default is Day 1.
        </td>
      </tr>
	  <tr>
        <td width="20%">Months of quarter</td>
        <td>The specific months of the quarter when these files are kept within the retention area.  This will only be displayed if "Quarterly" is selected.  Default is January, April, July, October.
        </td>
      </tr>
	  <tr>
        <td width="20%">The number of quarters to repeat the above selection</td>
        <td>Number of  quarter(s) when these files are kept within the retention area.  This will only be displayed if "Quarterly" is selected.  Default is 1 quarter.
        </td>
      </tr>
	  <tr>
        <td width="20%">The day within a year on which different versions of your files are retained</td>
        <td>The specific day of the year when these files are kept within the retention area.  It can be a specific day (January - December / 1 - 31; First, Second, Third, Fourth and Last / Sunday - Saturday, Weekday and Weekend) or a general day (Sunday - Saturday / Week 1 - Week 53 and Last Week).  This will only be displayed if "Yearly" is selected.  Default is January 1.
        </td>
      </tr>
	   <tr>
        <td width="20%">The number of years to repeat the above selection</td>
        <td>Number of  year(s) when these files are kept within the retention area.  This will only be displayed if "Yearly" is selected.  Default is 10 years.
        </td>
      </tr>
	  <tr>
        <td width="20%">A specific day on which different versions of your files are retained</td>
        <td>The specific day when these files are kept within the retention area.  It can be a specific day (January - December / 1 - 31; First, Second, Third, Fourth and Last / Sunday - Saturday, Weekday and Weekend) or a general day (Sunday - Saturday / Week 1 - Week 53 and Last Week).  This will only be displayed if "Custom" is selected.  Default is January 1. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Year</td>
        <td>The specific year when these files are kept within the retention area.  This will only be displayed if "Custom" is selected.  Default is the current year.
        </td>
      </tr>
</table>
<BR><BR>


<h3>To define an advanced retention policy:</h3> 
<OL>
<LI>Select the [Advanced] option.</LI>
<LI>Click the <img src="../images/round_add.png"> button to add new retention policy.</LI>
<LI>Type in a meaningful retention policy name. </LI>
<LI>Select the type of retention, eg: Daily. </LI>
<LI>Select the period to keep the deleted files in the retention area. </LI>
<LI>Click on <img src="../images/add.png"> to save the settings.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>
 
<P>For example, you are required to keep your company's data for 7 years according to the following rules. </P>
<UL>
<LI>Keep the backup for the last 7 days.</LI>
<LI>Keep the backup for the last 4 Saturdays.</LI>
<LI>Keep the backup for the 1st day of each month in the last 3 months.</LI>
<LI>Keep the backup for the 1st day of each quarter in the last 12 months.</LI>
<LI>Keep the backup for the 1st day of each year in the last 7 years.</LI>
</UL>

<P>To achieve the above example policy, configured the advanced retention policy as follows:<BR>
<BR>
Type: Daily<BR>
Number of days to keep: 7<BR>
<BR>
Type: Weekly<BR>
Keep retention files for the following days: Saturday<BR>
Number of weeks to keep: 4<BR>
<BR>
Type: Monthly<BR>
Keep retention files for the following days: Day 1<BR>
Number of months to keep: 3<BR>
<BR>
Type: Quarterly<BR>
Keep retention files for the following days:<BR>
Month - January, April, July, October<BR>
Day 1<BR>
Number of quarters to keep: 4<BR>
<BR>
Type: Yearly<BR>
Keep retention files for the following days: January - 01<BR>
Number of years to keep: 7<BR>
<BR>
Assuming that a file is updated and being backed up everyday for the past 7 years, and today is January 15, 2020. A total of 25 restorable versions of the file would be available for restore:<BR>
<BR>

<TABLE cellspacing="0" cellpadding="4">
<TR ALIGN=CENTER>
<TD class="firstTitles">Daily</TD><TD class="titles">Weekly</TD><TD class="titles">Monthly</TD><TD class="titles">Quarterly</TD><TD class="titles">Yearly</TD>
</TR>
<TR ALIGN=CENTER>
<TD valign=top>15-Jan-2020<BR>
14-Jan-2020<BR>
13-Jan-2020<BR>
12-Jan-2020<BR>
11-Jan-2020<BR>
10-Jan-2020<BR>
09-Jan-2020<BR></TD>

<TD valign=top>11-Jan-2020<BR>
03-Jan-2020<BR>
28-Dec-2019<BR>
21-Dec-2019<BR></TD>

<TD valign=top>01-Jan-2020<BR>
01-Dec-2019<BR>
01-Nov-2019<BR>
<BR></TD>

<TD valign=top>01-Jan-2020<BR>
01-Oct-2019<BR>
01-Jul-2019<BR>
01-Apr-2019<BR>
<BR></TD>

<TD valign=top>01-Jan-2020<BR>
01-Jan-2019<BR>
01-Jan-2018<BR>
01-Jan-2017<BR>
01-Jan-2016<BR>
01-Jan-2015<BR>
01-Jan-2014<BR></TD>

</TR>

<TR>
</TABLE>

</P>

<BR><BR>
<BR><BR>


<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
