<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>


<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Monthly Backup Schedule</h1>

<P>A monthly backup schedule defines the day and time that a backup job will run automatically every month.  A specific day of the month may be selected, e.g. 1 or a general one e.g. every Fourth Monday of the month.
</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>Schedule task name.
        </td>
      </tr>
      <tr>
        <td width="20%">Type</td>
        <td>Type of backup schedule, which is "Monthly".
        </td>
      </tr>
	  <tr>
        <td width="20%">Backup on the following day every month</td>
        <td>The particular day in a month to backup.  The backup schedule can be set at
		<UL>
		<LI>a specific day in a month, which is from 1 - 31 and Last. (default is 1). </LI>
		</UL>
		<b>or</b>
		<UL>
		<LI>a general one, select from First, Second, Third, Fourth and Last.  The day must also be set, choice of Sunday - Saturday, Weekday and Weekend.  </LI>
		</UL>
        </td>
      </tr>
      <tr>
        <td width="20%">Start backup at</td>
        <td>Start backup time.
        </td>
      </tr>
      <tr>
        <td width="20%">Stop</td>
        <td>Stop backup time. The backup schedule can be set to stop either
		    <UL>
		    <LI>Full backup is completed regardless of how much time it takes. (default)</LI> 
			</UL>
			<b>or</b>
			<UL>
			<LI>After the backup has started for the set time (1-24 hr) regardless if the backup is done.</LI>
			</UL>
        </td>
      </tr>
	  <tr>
        <td width="20%">Run Retention Policy after backup</td>
        <td>After the backup job, the system will trigger the retention policy.
        </td>
      </tr>
</table>
<BR><BR>

<H3>To set up a backup schedule:</H3>
<OL>
<LI>Configure a meaningful backup schedule name if necessary. </LI>
<LI>Select the type of backup schedule.</LI>
<LI>Select the day that you want the backup to run.</LI>
<LI>Configure the start time according to your requirement.</LI>
<LI>Configure the stop option according to your requirement.</LI>
<LI>Option: Configure the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<H3>To modify an existing backup schedule:</H3>
<OL>
<LI>Configure a meaningful backup schedule name if necessary.  </LI>
<LI>The type of the backup schedule cannot be modified. If you need another type of schedule, you need to create a new schedule type. </LI>
<LI>Select the day that you want the backup to run.</LI>
<LI>Configure the start time according to your requirement.</LI>
<LI>Configure the stop option according to your requirement.</LI>
<LI>Option: Configure the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>

<h3>Example:</h3>
<P>To configure a Monthly backup schedule where backup job will run on first weekend of every month at 8:00pm until full backup is complete:</P>
<OL>
<LI>Enter name of the backup schedule.</LI> 
<LI>Select "Monthly" from the schedule [Type] dropdown menu.</LI> 
<LI>Select the second radio button, choose "First", and "Weekend" from the dropdown menu.</LI> 
<LI>Configure start time to 20:00 from the dropdown menu.</LI>
<LI>Select "until full backup completed" from the [Stop] dropdown menu.</LI> 
<LI>Option: Configure the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<h3>To delete an existing backup schedule:</h3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI> 
<LI>Click on <img src="../images/save.png"> to continue.</LI>
</OL>
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>

