<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>


<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Daily Backup Schedule</h1>

<P>A daily backup schedule defines either a specific time or a time interval that a backup job will run automatically everyday.
</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>Schedule task name.
        </td>
      </tr>
      <tr>
        <td width="20%">Type</td>
        <td>Type of backup schedule, which is "Daily".
        </td>
      </tr>
      <tr>
        <td width="20%">Start backup</td>
        <td>Start backup time.  The scheduled backup can be set to start either  
			<UL>
			<LI>At a specific time. (default)</LI> 
			</UL>
			<b>or</b>
			<UL>
			<LI>Every, set interval in minutes or hours. (this option is only available for Daily or Weekly schedule types) 
			<br>Minute interval: 1, 2, 3, 4, 5, 6, 10, 12, 15, 20 or 30 minutes.
			<br>Hourly interval: 1, 2, 3, 4, 6, 8 or 12 hours.
			</LI>
			</UL>
        </td>
      </tr>
      <tr>
        <td width="20%">Stop</td>
        <td>Stop backup time. This only applies to schedules with start backup "at" and is not supported for periodic backup schedule (start backup "every").  The scheduled backup can be set to stop either
		        <UL>
			<LI>Until full backup is completed regardless of how much time it takes. (default)</LI> 
			</UL>
			<b>or</b>
			<UL>
			<LI>After the backup has started for the set time (1-24 hr) regardless if the backup is done.</LI>
			</UL>
        </td>
      </tr>
	  <tr>
        <td width="20%">Run Retention Policy after backup</td>
        <td>After the backup job, the system will trigger the retention policy.
        </td>
      </tr>
</table>
<BR><BR>

<H3>To set up a backup schedule:</H3>
<OL>
<LI>Configure a meaningful backup schedule name if necessary. </LI>
<LI>Select the type of backup schedule.</LI>
<LI>Configure the start time according to your requirement.</LI>
<LI>Configure the stop option according to your requirement.</LI>
<LI>Option: Check the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<H3>To modify an existing backup schedule:</H3>
<OL>
<LI>Configure a meaningful backup schedule name if necessary.  </LI>
<LI>The type of the backup schedule cannot be modified. If you need another type of schedule, you need to create a new schedule type. </LI>
<LI>Modify the start time according to your requirement.</LI>
<LI>Modify the stop option according to your requirement.</LI>
<LI>Option: Check/Uncheck the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>

</OL>
<BR><BR>

<h3>Example:</h3>
<P>To configure a Daily backup schedule where backup job will run everyday at 8:00pm until full backup is complete: </P>
<OL>
<LI>Enter name of the backup schedule.</LI>
<LI>Select "Daily" from the schedule [Type] dropdown menu.</LI>
<LI>Select "at" from the [Start backup] dropdown menu and configure start time to 20:00 from the dropdown menu.</LI>
<LI>Select "until full backup completed" from the [Stop] dropdown menu.</LI>
<LI>Option: Check the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>

<P>To configure a periodic backup schedule where backup job will run every hour daily: </P>
<OL>
<LI>Enter name of the backup schedule.</LI>
<LI>Select "Daily" from the schedule [Type] dropdown menu.</LI>
<LI>Select "every" from the [Start backup] dropdown menu and select the interval which is "1 hour" from the dropdown menu.</LI>
<LI>Option: Check the "Run Retention Policy after backup" if necessary.</LI>
<LI>Click <img src="../images/add.png"> to continue.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>


<H3>To delete an existing backup schedule:</H3>
<OL>
<LI>Click on the check box at the front of the entry.</LI>
<LI>Click on the <img src="../images/trash.png"> icon in this section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI> 
<LI>Click on <img src="../images/save.png"> to continue.</LI>
</OL>
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>

