<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
 
<h1 class="colorBackupServer">Progressive Data Integrity Check</h1>
<P>The progressive data integrity check feature is introduced since <%=HelpManager.getCbsShortName(request)%> v7.17.0.0. The feature is enabled by default after installation / upgrade to <%=HelpManager.getCbsShortName(request)%> version 7.17.0.0 or above.  </P>
<BR><P>Below is the features of progressive data integrity check (DIC): </P>
<UL>
<LI>Automatic Apply: When the progressive data integrity check (DIC) feature is enabled, a progressive data integrity check (DIC) job will be performed automatically before the start of each backup job to ensure that the integrity of the backup data are correct. </LI>
<LI>Regularly Apply: The progressive data integrity check (DIC) will perform check for backup data regularly based on the value configured for the progressive DIC interval. </LI>
<LI>Centralized Control: The progressive data integrity check (DIC)feature centralized the control of progressive DIC for all backup users and backup sets. </LI>
<LI>Fast: The progressive data integrity check (DIC)feature will only perform check for backup files in the current data area and the latest index, so therefore, the progressive DIC process can be completed quickly. </LI>
<LI>Efficient: The progressive data integrity check (DIC) feature will only check for backup files outside of the progressive DIC interval. </LI>
</UL>

<BR><BR>
<p>Below is the table of comparison between Progressive DIC and Manual DIC. </p>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="10%"></td>
        <td class="titles">Progressive DIC</td>
		<td class="titles">Manual DIC</td>
      </tr>
      <tr>
        <td width="10%">Speed & Performance </td>
        <td> <UL><LI>Regular progressive DIC will be applied automatically to ensure the integrity of data. </LI>
                 <LI>Backup time will be longer as the progressive DIC process needs to be completed before each backup job is started. </LI>	
                 <LI>Progressive DIC is faster than manual DIC, as it only performs check for backup files in current data area and the latest index, that are outside of the progress DIC interval. </LI>				 
	    </UL></td>
		<td> <UL><LI>DIC must be applied manually. </LI>
                 <LI>Manual DIC will not influence the backup process time. </LI>	
                 <LI>Manual DIC takes longer to complete, as it performs check for all backup data in both the current and retention area, along with all indexes. </LI>				 
	    </UL></td>
      </tr>
	  <tr>
        <td width="10%">Checked Data & Index </td>
        <td> <UL><LI>Current data area.</LI>
                 <LI>The latest index. </LI>	
	    </UL></td>
		<td> <UL><LI>Current & retention data area. </LI>
                 <LI>All indexes. </LI>	
	    </UL></td>
      </tr>
	  <tr>
        <td width="10%">Run on Server or Run on Client </td>
        <td>Support both Run on Server and Run on Client backup set. </td>
		<td>Only Cloud File backup set and Office 365 Exchange Online backup set can support both Run on Server and Run on Client. Others backup types can only support Run on Client. </td>
      </tr>
	  <tr>
        <td width="10%">DIC Log </td>
        <td>Only sentences for the start and end of the progressive DIC job and progressive DIC interval but no detailed logs. </td>
		<td>Detailed logs about which files were checked and the whole DIC process will be shown in the manual DIC log page. </td>
      </tr>
	  <tr>
        <td width="10%">Removal Action</td>
        <td> <UL><LI>If a backup file does not exist physically at the backup destination, the process will automatically remove record of the corresponding backup file from the index file. </LI>
                 <LI>If a backup file exists, but the index file does not contain record of the backup file, no removal action will be executed. </LI>					 
	         </UL>
		</td>
		<td>For both cases where a backup file does not exist physically at the backup destination, or the index file does not contain record of a backup file, the user will need to manually click to start and confirm on the data removal of the backup file, or record from the index file. </td>
      </tr>
	  <tr>
        <td width="10%">Trigger Replication </td>
        <td>No as progressive DIC will not delete or modify any backup files. </td>
		<td>Yes if manual DIC delete any corrupted file. </td>
      </tr>
	  <tr>
        <td width="10%">Deployments </td>
        <td>Suitable for administrator who wants to perform regular simple data integrity check for all users automatically to ensure that the integrity of all data are correct. </td>
		<td>Suitable for end user who wants to perform a full data integrity check manually to locate any mismatch between the backup data and index, that may cause backup failure. </td>
      </tr>
</table>

<BR><BR>
<H4>Key:</H4>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">X Days</td>
        <td>Specified progressive DIC interval.  
      </td>
      </tr>
</table>
<BR><BR>

<h3>To enable Progressive Data Integrity Check:</h3>
<OL>
<LI>Slide the switch to right hand side to turn on the Progressive Data Integrity Check. </LI>
<LI>Enter the progressive data integrity check interval that you want to configured, in the textbox under "Progressive Data Integrity Check (DIC) is executed before running backup". 
<BR>The progress data integrity check job will only perform check for backup files that have not been checked within the specified interval. Precisely, this means that there will be a last DIC check time marked for each backup file, and the progressive data integrity check (DIC) will perform check for file if its last data integrity check (DIC) time exceeded the progressive data integrity check (DIC) interval. 
<div id="tipsContainer"><div class="icon">!</div>
<P>Please kindly note that: </P>
<UL>
<LI>The progressive data integrity check job will only perform check for backup files that have not been checked within the PDIC interval configured, but a manual DIC job will perform check for all backup files, in both the current and retention area, even if the file are within the progressive DIC interval. </LI>
<LI>The minimum value that you can configure for the PDIC interval is 1 day, there is no limit to the maximum value that you can configure. </LI>
<LI>If the Progressive DIC interval is set to a small value, the time for each backup job to complete will be longer, as data file would be checked more often (due to the small Progressive DIC interval). 
However, setting the Progressive DIC interval to a small value can further minimize the possibility of data corruption (e.g. backup files and index mismatch).  </LI>
<LI>If the PDIC interval is set to a large value, the time for each backup job to complete will be shorter (compared to if the interval is set to a small value), as data file would be checked less often (due to the larger PDIC interval).  
However, setting the PDIC interval to a large value may increase the possibility of data corruption (e.g. backup files and index mismatch). </LI>
</UL>
</div>
</LI> 
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
 
<BR><BR>
<BR><BR>


<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
