#!/bin/sh
# [Ahsay Cloud Backup Suite] (version 8.5.2.62)

# get application home
EXE_HOME=`pwd`
cd `dirname "$0"`
APP_BIN=`pwd`
APP_HOME=`dirname ${APP_BIN}`
cd "${EXE_HOME}"

# define utility scripts
UTIL_PRIVILEGE=${APP_BIN}/privilege.sh
UTIL_UNINSTALL_SERVICE=${APP_BIN}/remove-service.sh
UTIL_SHUTDOWN=${APP_BIN}/shutdown.sh

# verify if the privilege is enough for uninstall
if [ "$1" != "skipVerify" ]; then
    # print Logging Message Header
    echo "Log Time: `date`"

    # verify the privilege if the shell script "privilege.sh" exist.
    echo ""
    if [ -f "${UTIL_PRIVILEGE}" ]; then
        echo "Verifying current user privilege ..."
        "${UTIL_PRIVILEGE}" "uninstall"
        [ $? -ne 0 ] && echo "Exit \"`basename $0`\" now!" && exit 1
    else
        echo "The shell script \"${UTIL_PRIVILEGE}\" is missing."
        echo "Exit \"`basename $0`\" now!" && exit 1
    fi
    echo "Current user has enough privilege to \"uninstall\"."
    echo ""
fi

# shutdown service
echo "Try to shutdown [ NFS Service (Ahsay Systems Corporation) ]"
sh "${UTIL_SHUTDOWN}"
sleep 5
echo "Wait 5 seconds before [ NFS Service (Ahsay Systems Corporation) ] is down"

# remove service
SCRIPT_NAME=cbsnfs
echo "Remove [ NFS Service (Ahsay Systems Corporation) ] (${SCRIPT_NAME}) from service"
sh "${UTIL_UNINSTALL_SERVICE}" ${SCRIPT_NAME}
echo "[ NFS Service (Ahsay Systems Corporation) ] uninstall service is complete!"

exit 0
