#!/bin/sh
# Ahsay Cloud Backup Suite (version 8.5.2.62)

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`
echo "$APP_HOME"
# -------------- Check provided name and path of the script --------------------

# --------------------- Verify uname -------------------------------------------
case "`uname`" in
  Linux*)   INSTALL_TYPE=NIX ;;
  Solaris*) INSTALL_TYPE=NIX ;;
  SunOS*)   INSTALL_TYPE=NIX ;;
  OpenBSD*) INSTALL_TYPE=OPENBSD ;;
  *BSD*)    INSTALL_TYPE=BSD ;;
  **)       INSTALL_TYPE=NOT_SUPPORTED ;;
esac


# ------------------------ Installl according to OS type -----------------------
if [ $INSTALL_TYPE = "NIX" ];
then

    ############################################################################
    #         N I X                        I N S T A L L A T I O N             #
    ############################################################################

    echo "Get Startup path for NIX type OS"

    # -------------- Check local machine init Service Path ---------------------
    # Setup INIT_PATH if not given

    if [ -z "$INIT_PATH" ]; then
      if [ -d /etc/init.d ]; then
        INIT_PATH=/etc/init.d
      else
        if [ -d /etc/rc.d/init.d ]; then
          INIT_PATH=/etc/rc.d/init.d
        else
          echo "INIT_PATH not found!"
          return -1
        fi
      fi
    fi

elif [ $INSTALL_TYPE = "BSD" ];
then

    ############################################################################
    #         B S D                        I N S T A L L A T I O N             #
    ############################################################################

    echo "Get Startup path for BSD type OS"

    # Special handling for UBS
    # INIT_PATH=/usr/local/etc/rc.d
    OBSR_HOME=$APP_HOME

elif [ $INSTALL_TYPE = "OPENBSD" ];
then

    ############################################################################
    #     O P E N B S D                        I N S T A L L A T I O N         #
    ############################################################################

    echo "Get Startup path for OpenBSD type OS"    

    #get OpenBSD version
    OPENBSD_VERSION=`uname -r | cut -f1 -d"."`

    if [ $OPENBSD_VERSION -ge 5 ]
    then
      INIT_PATH=/etc/rc.d
    
    else
      INIT_PATH=/etc

    fi
    
else

    ############################################################################
    #       O T H E R         O S        N O T         S U P P O R T E D       #
    ############################################################################

    echo "This OS `uname` is not supported by this script! Exit `basename $0` now!"

fi

# get string after "="
get_column_value() {
  local STRING_PATTERN="$1"
  local COL_NUM=$2
  echo $STRING_PATTERN | awk -F "=" '{print $'"${COL_NUM}"'}'
}


RDR_SCRIPT_FILE=$INIT_PATH/rdr
OBS_SCRIPT_FILE=$INIT_PATH/obs
OBSR_SCRIPT_FILE=$INIT_PATH/obsr
RPS_SCRIPT_FILE=$INIT_PATH/rps
   ###############################Check RDR script file###############################################
  if [ -f "$RDR_SCRIPT_FILE" ];
  then 
	 RDR_HOME_INFO=`cat $RDR_SCRIPT_FILE | grep RDR_HOME=`
     RDR_HOME=`get_column_value "$RDR_HOME_INFO" 2`
	 echo "Stop RDR Service"
	 sh "$RDR_HOME/bin/shutdown.sh"
  fi
  
   ###############################Check OBS script file###############################################
  if [ -f "$OBS_SCRIPT_FILE" ];
  then 
	 OBS_HOME_INFO=`cat $OBS_SCRIPT_FILE | grep OBS_HOME=`
     OBS_HOME=`get_column_value "$OBS_HOME_INFO" 2`
	 echo "Stop OBS Service"
	 sh "$OBS_HOME/bin/shutdown.sh"
  fi


   ###############################Check OBSR script file###############################################
  if [ -f "$OBSR_SCRIPT_FILE" ];
  then   
	 OBSR_HOME_INFO=`cat $OBSR_SCRIPT_FILE | grep OBSR_HOME=`
     OBSR_HOME=`get_column_value "$OBSR_HOME_INFO" 2`
	 echo "Stop OBSR Service"
	 sh "$OBSR_HOME/bin/shutdown.sh"
  fi
 
   if [ -f "$RPS_SCRIPT_FILE" ];
  then   
	 RPS_HOME_INFO=`cat $RPS_SCRIPT_FILE | grep RPS_HOME=`
     RPS_HOME=`get_column_value "$RPS_HOME_INFO" 2`
	 echo "Stop RPS Service"
	 sh "$RPS_HOME/bin/shutdown.sh"
  fi
 
  echo RDR_HOME $RDR_HOME
  echo OBS_HOME $OBS_HOME
  echo OBSR_HOME $OBSR_HOME
  echo RPS_HOME $RPS_HOME
  
  # -------------------------- Migrate ----------------------------------
echo "Run MigrateV6 script"
sh "${APP_BIN}/migrateV6.sh" "$APP_HOME" "$RDR_HOME" "$OBSR_HOME" "$OBS_HOME" "$RPS_HOME" >$APP_HOME/logs/migrate.log
  

  ###############################Uninstall service file###############################################
if [ -d "$RDR_HOME" ];
then 
	if [ "$APP_HOME" != "$RDR_HOME" ]; then
		echo "Uninstall RDR Service"
		sh "$RDR_HOME/bin/uninstall.sh"
	fi
fi
  
if [ -d "$OBS_HOME" ];
then 
	if [ "$APP_HOME" != "$OBS_HOME" ]; then
		echo "Uninstall OBS Service"
		sh "$OBS_HOME/bin/uninstall.sh"
	fi
fi

if [ -d "$OBSR_HOME" ];
then 
	if [ "$APP_HOME" != "$OBSR_HOME" ]; then
		echo "Uninstall OBSR Service"
		sh "$OBSR_HOME/bin/uninstall.sh"
	fi
fi

if [ -d "$RPS_HOME" ];
then 
	if [ "$APP_HOME" != "$RPS_HOME" ]; then
		echo "Uninstall RPS Service"
		sh "$RPS_HOME/bin/uninstall.sh"
	fi
fi

exit 0