#!/bin/sh
# [Ahsay Cloud Backup Suite] (version 8.5.2.62)

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`
CBS_HOME=$APP_HOME
echo "$APP_HOME"

# --------------------- Verify uname -------------------------------------------
case "`uname`" in
    Linux*)   INSTALL_TYPE=NIX ;;
    Solaris*) INSTALL_TYPE=NIX ;;
    SunOS*)   INSTALL_TYPE=NIX ;;
    OpenBSD*) INSTALL_TYPE=OPENBSD ;;
    *BSD*)    INSTALL_TYPE=BSD ;;
    **)       INSTALL_TYPE=NOT_SUPPORTED ;;
esac

# ------------------------ Installl according to OS type -----------------------

if [ $INSTALL_TYPE = "NIX" ];
then

    ############################################################################
    #         N I X                        I N S T A L L A T I O N             #
    ############################################################################

    echo "Get Startup path for NIX type OS"

    # -------------- Check local machine init Service Path ---------------------
    # Setup INIT_PATH if not given

    if [ -z "$INIT_PATH" ];
    then
        if [ -d /etc/init.d ];
        then
            INIT_PATH=/etc/init.d
        else
            if [ -d /etc/rc.d/init.d ];
            then
                INIT_PATH=/etc/rc.d/init.d
            else
                echo "INIT_PATH not found!"
                return -1
            fi
        fi
    fi

elif [ $INSTALL_TYPE = "BSD" ];
then

    ############################################################################
    #         B S D                        I N S T A L L A T I O N             #
    ############################################################################

    echo "Get Startup path for BSD type OS"

    # Special handling for UBS
    # INIT_PATH=/usr/local/etc/rc.d
    OBSR_HOME=$APP_HOME

elif [ $INSTALL_TYPE = "OPENBSD" ];
then

    ############################################################################
    #     O P E N B S D                        I N S T A L L A T I O N         #
    ############################################################################

    echo "Get Startup path for OpenBSD type OS"    

    #get OpenBSD version
    OPENBSD_VERSION=`uname -r | cut -f1 -d"."`

    if [ $OPENBSD_VERSION -ge 5 ]
    then
        INIT_PATH=/etc/rc.d
    else
        INIT_PATH=/etc
    fi

else

    ############################################################################
    #       O T H E R         O S        N O T         S U P P O R T E D       #
    ############################################################################

    echo "This OS `uname` is not supported by this script! Exit `basename $0` now!"

fi

# get string after "="
get_column_value() {
    local STRING_PATTERN="$1"
    local COL_NUM=$2
    echo $STRING_PATTERN | awk -F "=" '{print $'"${COL_NUM}"'}'
}

OBS_SCRIPT_FILE=$INIT_PATH/obs
OBSR_SCRIPT_FILE=$INIT_PATH/obsr

############################### Check OBS script file ###############################################

if [ -f "$OBS_SCRIPT_FILE" ];
then
    OBS_HOME_INFO=`cat $OBS_SCRIPT_FILE | grep OBS_HOME=`
    OBS_HOME=`get_column_value "$OBS_HOME_INFO" 2`
    echo "Check OBS License"
fi

############################### Check OBSR script file ###############################################

if [ -f "$OBSR_SCRIPT_FILE" ];
then
    OBSR_HOME_INFO=`cat $OBSR_SCRIPT_FILE | grep OBSR_HOME=`
    OBS_HOME=`get_column_value "$OBSR_HOME_INFO" 2`
    echo "Check OBSR License"
fi

if [ ! -z "$OBS_HOME" ];
then

    create_symlink_for_java_home() {
        if [ ! -n "$JAVA_HOME" ];
        then
            log_message "Please set JAVA_HOME!"
            exit 1
        else
            log_message "Create JAVA_HOME symbolic link at $CBS_HOME/java"
            cd "$CBS_HOME"
            ln -sf "${JAVA_HOME}" "java"
            return 0
        fi
    }

    log_message() {
        echo "$1"
    }

    get_physical_memory_in_kb() {
        case "${SYSTEM_TYPE}" in
            linux )
                linux_get_ram_info_in_kb
                ;;
            bsd )
                bsd_macos_get_ram_info_in_kb
                ;;
            macos )
                bsd_macos_get_ram_info_in_kb
                ;;
            solaris )
                solaris_get_ram_info_in_kb
                ;;
            * )
                echo "0"
                ;;
        esac
    }

    linux_get_ram_info_in_kb() {
        # Check the value by "cat /proc/meminfo"
        MEMORY_INFO=`cat /proc/meminfo | grep MemTotal:`
        TOTAL_MEMORY_IN_KB=`get_column_value "$MEMORY_INFO" 2`
        echo "$TOTAL_MEMORY_IN_KB"
    }

    bsd_macos_get_ram_info_in_kb() {
        REAL_MEM="`/sbin/sysctl -n hw.physmem`"
        REAL_MEM_IN_KB="`expr $REAL_MEM / 1024`"
        echo "${REAL_MEM_IN_KB}"
    }

    solaris_get_ram_info_in_kb() {
        REAL_MEM="`/usr/bin/kstat -p unix:0:system_pages:physmem | cut -f2`"
        PAGESIZE="`/usr/bin/pagesize`"
        REAL_MEM_IN_KB="`expr "$REAL_MEM" "*" "$PAGESIZE" "/" "1024"`"
        echo "${REAL_MEM_IN_KB}"
    }

    ##################################################################
    # Setup JAVA environment, including JAVA_HOME and the options limit

    # Prepare JAVA_HOME
    if [ -z "$JRE_HOME" ];
    then

        # If $CBS_HOME/java exist, it will always be used as JRE_HOME.
        # Otherwise, we have to create symbolic link for the $CBS_HOME/java to the predefined JRE_HOME

        if [ -d "$CBS_HOME/java" ];
        then
            JRE_HOME="$CBS_HOME/java"
        else
            case "${SYSTEM_TYPE}" in
                # Modify JRE_HOME for Mac OS X
                # It is required to be here for this file will be used in upgrade patch as well
                macos)
                    JRE_HOME=/System/Library/Frameworks/JavaVM.framework/Home
                    ln -sf "$JRE_HOME" "$CBS_HOME/java"
                    ;;
                linux)
                    # use bundled java if available
                    case "${SYSTEM_ARCH}" in
                        i[3-6]86)
                            if [ -d $CBS_HOME/java-linux-x86 ];
                            then
                                JRE_HOME=$CBS_HOME/java-linux-x86
                                cd $CBS_HOME
                                ln -sf "java-linux-x86" "java"
                            else
                                create_symlink_for_java_home
                            fi
                            ;;
                        x86_64 | amd64)
                            if [ -d $CBS_HOME/java-linux-x64 ];
                            then
                                JRE_HOME=$CBS_HOME/java-linux-x64
                                ln -sf "java-linux-x64" "java"
                            else
                                create_symlink_for_java_home
                            fi
                            ;;
                        arm*)
                            ;;
                        ppc*)
                            ;;
                        *)
                            create_symlink_for_java_home
                            ;;
                    esac
                    ;;
                bsd)
                    #  use bundled java if available
                    case "${SYSTEM_ARCH}" in
                        i[3-6]86)
                            if [ -d "$CBS_HOME/java-freebsd-x86" ];
                            then
                                JRE_HOME=$CBS_HOME/java-freebsd-x86
                            else
                                create_symlink_for_java_home
                            fi
                            ;;
                        x86_64 | amd64)
                            if [ -d "$CBS_HOME/java-freebsd-x64" ];
                            then
                                JRE_HOME=$CBS_HOME/java-freebsd-x64
                            else
                                create_symlink_for_java_home
                            fi
                            ;;
                        *)
                            create_symlink_for_java_home
                            ;;
                    esac
                    ;;
                *)
                    create_symlink_for_java_home
                    ;;
            esac
        fi

        # Assumed we always have this directory for JAVA_HOME and JRE_HOME at this stage
        [ -d "$CBS_HOME/java" ] && JRE_HOME=$CBS_HOME/java
        JAVA_HOME=$JRE_HOME

    fi

    CLASSPATH="$CBS_HOME/lib/*:$CBS_HOME/tomcat/lib/*"
    JAVA_JNI_OPTS="-Djava.library.path=$CBS_HOME/lib/LinX64"
    MAIN_CLASS=InstallerCheckLicense

    $JAVA_HOME/bin/java -cp "$CLASSPATH" "$MAIN_CLASS" "$OBS_HOME" en 2>&1

    filename="$OBS_HOME/conf/LicenseResult"
    echo "IMPORTANT: If your license is not covered by valid maintenance, you are not entitled to upgrade with a newer release. Running AhsayCBS which is released after your maintenance expiry date will result in server stop running. Contact Sales to renew your maintenance."

    if [ -f "${filename}" ];
    then
        line=$(head -n 1 $filename)
        if [ -n "${line}" ];
        then
            result=$(echo ${line} | cut -d"," -f1)
            relase=$(echo ${line} | cut -d"," -f2)
            type=$(echo ${line} | cut -d"," -f3)
            maintenance=$(echo ${line} | cut -d"," -f4)
            free=$(echo ${line} | cut -d"," -f5)
            echo ""
            echo "-------------------License Information:-------------------"
            echo "Product Release Date:    ${relase}"
            echo "License Type:            ${type}"
            echo "Maintenance Expiry Date: ${maintenance}"
            echo "Free Upgrade Until:      ${free}"
            echo ""
            if [ "${result}" = "true" ];
            then
                while true;
                do
                    read -p "Continue to install?(y/n)" yn
                    case $yn in
                        [Yy]* ) exit 0;;
                        [Nn]* ) kill 0;;
                        * ) echo "Please answer yes or no.";;
                    esac
                done
            else
                echo "Your maintenance license is expired and the installation is terminated. Please contact Sales to renew your maintenance."
                kill 0
            fi
        else
            echo "Cannot check the license"
            kill 0
        fi
    else
        echo "Cannot check the license"
        kill 0
    fi

fi