#!/bin/sh

############################### RunRestore.sh ##################################
# You can use this shell to run the application                                #
################################################################################

######################### START: User Defined Section ##########################

# -------------------------------- DEBUG_MODE ----------------------------------
# | Enable/Disable debug mode                                                  |
# | e.g. DEBUG_MODE="--debug"                                                  |
# |  or  DEBUG_MODE=""                                                         |
# ------------------------------------------------------------------------------
DEBUG_MODE=""

########################## END: User Defined Section ###########################


################################################################################
#          R E T R I E V E     A P P _ H O M E     P A T H                     #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`
DEP_LIB_PATH=

OS_NAME=
case "${SYSTEM_OS}" in
  Linux* )
    OS_NAME="Lin"
    ;;
  *BSD* )
    OS_NAME="Fbd"
    ;;
  SunOS )
    OS_NAME="Sos"
    SYSTEM_ARCH=`isainfo -b`
    ;;
  * )
    echo "OS \"${SYSTEM_OS}\" is not supported. Exit now."
    exit 1
    ;;
esac

OS_ARCH=
if [ -z "${DEP_LIB_PATH}" ]; then
    case "${SYSTEM_ARCH}" in
        i[3-6]86 | 32)
            OS_ARCH="X86"
        ;;
        x86_64 | amd64 | 64)
            OS_ARCH="X64"
        ;;
        armv6*)
            OS_ARCH="Av6"
        ;;
        armv7*)
            OS_ARCH="Av7"
        ;;
        armv5*)
            OS_ARCH="Arm"
        ;;
        aarch64*)
            OS_ARCH="A64"
        ;;
        * )
            echo "Arch \"${SYSTEM_ARCH}\" is not supported. Exit now."
            exit 1
        ;;
    esac
    DEP_LIB_PATH=${OS_NAME}${OS_ARCH}
fi

# ------------------------------- SETTING_HOME ---------------------------------
# | Directory to your setting home.                                            |
# ------------------------------------------------------------------------------
SETTING_HOME="$APP_HOME/.obm"

xhost +SI:localuser:root
################################################################################
#          R E T R I E V E     J A V A _ H O M E     P A T H                   #
################################################################################

if [ "Darwin" = "${SYSTEM_OS}" ]; then
    JAVA_HOME="/System/Library/Frameworks/JavaVM.framework/Home"
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "'$APP_HOME/jvm' does not exist!"
    if [ ! -n "$JAVA_HOME" ]; then
        echo "Please set JAVA_HOME!"
        exit 0
    else
        ln -sf "$JAVA_HOME" "$APP_HOME/jvm"
        echo "Created JAVA_HOME symbolic link at '$APP_HOME/jvm'"
    fi
fi

if [ ! -x "$APP_HOME/jvm" ];
then
    echo "Please create symbolic link for '$JAVA_HOME' to '$APP_HOME/jvm'"
    exit 0
fi

JAVA_HOME="$APP_HOME/jvm"

# Use alternative executable name to define the GUI execution
if [ "Darwin" = "${SYSTEM_OS}" ]; then
    JAVA_EXE="$JAVA_HOME/bin/java"
else
    JAVA_EXE="$JAVA_HOME/bin/bJW"
fi

# Verify the JAVA_EXE whether it is a valid JAVA Executable or not.
STRING_JAVA_VERSION="java version,openjdk version"
OUTPUT_JAVA_VERSION=`"${JAVA_EXE}" -version 2>&1`
OUTPUT_JVM_SUPPORT=0
BACKUP_IFS=$IFS
IFS=","
for word in $STRING_JAVA_VERSION; do
    if [ `echo "${OUTPUT_JAVA_VERSION}" | grep "${word}" | grep -cv "grep ${word}"` -le 0 ]
    then
      #echo "The Java Executable \"${JAVA_EXE}\" is not a valid Java Executable. Exit \""`basename "$0"`"\" now."
      continue;
    else
      OUTPUT_JVM_SUPPORT=1
      break;
    fi
done
IFS=$BACKUP_IFS
if [ $OUTPUT_JVM_SUPPORT -eq 0 ]
then
    echo "The Java Executable \"${JAVA_EXE}\" is not a valid Java Executable. Exit \""`basename "$0"`"\" now."
    exit 1
fi

################################################################################
#                               S T A R T - U P                                #
################################################################################

# Set LD_LIBRARY_PATH for Lotus Notes on Linux
if [ "Linux" = "${SYSTEM_OS}" ]; then
    NOTES_PROGRAM=`cat "$APP_HOME/bin/notesenv"`
    LD_LIBRARY_PATH="$APP_HOME/bin:$NOTES_PROGRAM:$LD_LIBRARY_PATH"
    export NOTES_PROGRAM
else
    LD_LIBRARY_PATH="$APP_HOME/bin:$LD_LIBRARY_PATH"
fi

LD_LIBRARY_PATH="${APP_BIN}/${DEP_LIB_PATH}":".":"${LD_LIBRARY_PATH}"

SHLIB_PATH="$LD_LIBRARY_PATH"
export LD_LIBRARY_PATH SHLIB_PATH

# Change to APP_BIN for JAVA execution
cd "${APP_BIN}"

# Reference path will be used to avoid empty space in the parent directory
LIB_HOME=.
JAVA_OPTS="-Xrs -Xms128m -Xmx768m -XX:MaxDirectMemorySize=512m -client -Dsun.nio.PageAlignDirectMemory=true"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/${DEP_LIB_PATH}"
CLASSPATH="$LIB_HOME:$LIB_HOME/cb.jar"
MAIN_CLASS=Gui

# Execute Java VM Runtime for BackupManager
echo "Startup Ahsay Online Backup Manager ... "
"${JAVA_EXE}" $JAVA_OPTS $JNI_PATH -cp $CLASSPATH $MAIN_CLASS "--restore" "${DEBUG_MODE}" "${APP_HOME}" "${SETTING_HOME}"

################################################################################
#                   R E S E T          A N D          E X I T                  #
################################################################################

cd "${EXE_DIR}"
exit 0
