/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.collections.ListListenerHelper;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableIntegerProperty;
import javafx.css.StyleableProperty;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Skin;
import javafx.scene.control.TextInputControl;

public class TextArea
extends TextInputControl {
    public static final int DEFAULT_PREF_COLUMN_COUNT = 40;
    public static final int DEFAULT_PREF_ROW_COUNT = 10;
    public static final int DEFAULT_PARAGRAPH_CAPACITY = 32;
    private BooleanProperty wrapText = new StyleableBooleanProperty(false){

        @Override
        public Object getBean() {
            return TextArea.this;
        }

        @Override
        public String getName() {
            return "wrapText";
        }

        @Override
        public CssMetaData<TextArea, Boolean> getCssMetaData() {
            return StyleableProperties.WRAP_TEXT;
        }
    };
    private IntegerProperty prefColumnCount = new StyleableIntegerProperty(40){
        private int oldValue;
        {
            this.oldValue = this.get();
        }

        @Override
        protected void invalidated() {
            int value = this.get();
            if (value < 0) {
                if (this.isBound()) {
                    this.unbind();
                }
                this.set(this.oldValue);
                throw new IllegalArgumentException("value cannot be negative.");
            }
            this.oldValue = value;
        }

        @Override
        public CssMetaData<TextArea, Number> getCssMetaData() {
            return StyleableProperties.PREF_COLUMN_COUNT;
        }

        @Override
        public Object getBean() {
            return TextArea.this;
        }

        @Override
        public String getName() {
            return "prefColumnCount";
        }
    };
    private IntegerProperty prefRowCount = new StyleableIntegerProperty(10){
        private int oldValue;
        {
            this.oldValue = this.get();
        }

        @Override
        protected void invalidated() {
            int value = this.get();
            if (value < 0) {
                if (this.isBound()) {
                    this.unbind();
                }
                this.set(this.oldValue);
                throw new IllegalArgumentException("value cannot be negative.");
            }
            this.oldValue = value;
        }

        @Override
        public CssMetaData<TextArea, Number> getCssMetaData() {
            return StyleableProperties.PREF_ROW_COUNT;
        }

        @Override
        public Object getBean() {
            return TextArea.this;
        }

        @Override
        public String getName() {
            return "prefRowCount";
        }
    };
    private DoubleProperty scrollTop = new SimpleDoubleProperty(this, "scrollTop", 0.0);
    private DoubleProperty scrollLeft = new SimpleDoubleProperty(this, "scrollLeft", 0.0);

    public TextArea() {
        this("");
    }

    public TextArea(String text) {
        super(new TextAreaContent());
        this.getStyleClass().add("text-area");
        this.setAccessibleRole(AccessibleRole.TEXT_AREA);
        this.setText(text);
    }

    @Override
    final void textUpdated() {
        this.setScrollTop(0.0);
        this.setScrollLeft(0.0);
    }

    public ObservableList<CharSequence> getParagraphs() {
        return ((TextAreaContent)this.getContent()).paragraphList;
    }

    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    public final boolean isWrapText() {
        return this.wrapText.getValue();
    }

    public final void setWrapText(boolean value) {
        this.wrapText.setValue(value);
    }

    public final IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public final int getPrefColumnCount() {
        return this.prefColumnCount.getValue();
    }

    public final void setPrefColumnCount(int value) {
        this.prefColumnCount.setValue(value);
    }

    public final IntegerProperty prefRowCountProperty() {
        return this.prefRowCount;
    }

    public final int getPrefRowCount() {
        return this.prefRowCount.getValue();
    }

    public final void setPrefRowCount(int value) {
        this.prefRowCount.setValue(value);
    }

    public final DoubleProperty scrollTopProperty() {
        return this.scrollTop;
    }

    public final double getScrollTop() {
        return this.scrollTop.getValue();
    }

    public final void setScrollTop(double value) {
        this.scrollTop.setValue(value);
    }

    public final DoubleProperty scrollLeftProperty() {
        return this.scrollLeft;
    }

    public final double getScrollLeft() {
        return this.scrollLeft.getValue();
    }

    public final void setScrollLeft(double value) {
        this.scrollLeft.setValue(value);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new TextAreaSkin(this);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TextArea.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<TextArea, Number> PREF_COLUMN_COUNT = new CssMetaData<TextArea, Number>("-fx-pref-column-count", SizeConverter.getInstance(), (Number)40){

            @Override
            public boolean isSettable(TextArea n) {
                return !n.prefColumnCount.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TextArea n) {
                return (StyleableProperty)((Object)n.prefColumnCountProperty());
            }
        };
        private static final CssMetaData<TextArea, Number> PREF_ROW_COUNT = new CssMetaData<TextArea, Number>("-fx-pref-row-count", SizeConverter.getInstance(), (Number)10){

            @Override
            public boolean isSettable(TextArea n) {
                return !n.prefRowCount.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(TextArea n) {
                return (StyleableProperty)((Object)n.prefRowCountProperty());
            }
        };
        private static final CssMetaData<TextArea, Boolean> WRAP_TEXT = new CssMetaData<TextArea, Boolean>("-fx-wrap-text", StyleConverter.getBooleanConverter(), Boolean.valueOf(false)){

            @Override
            public boolean isSettable(TextArea n) {
                return !n.wrapText.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(TextArea n) {
                return (StyleableProperty)((Object)n.wrapTextProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(TextInputControl.getClassCssMetaData());
            styleables.add(PREF_COLUMN_COUNT);
            styleables.add(PREF_ROW_COUNT);
            styleables.add(WRAP_TEXT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    private static final class ParagraphListChange
    extends NonIterableChange<CharSequence> {
        private List<CharSequence> removed;

        protected ParagraphListChange(ObservableList<CharSequence> list, int from, int to, List<CharSequence> removed) {
            super(from, to, list);
            this.removed = removed;
        }

        @Override
        public List<CharSequence> getRemoved() {
            return this.removed;
        }

        @Override
        protected int[] getPermutation() {
            return new int[0];
        }
    }

    private static final class ParagraphList
    extends AbstractList<CharSequence>
    implements ObservableList<CharSequence> {
        private TextAreaContent content;

        private ParagraphList() {
        }

        @Override
        public CharSequence get(int index) {
            return (CharSequence)this.content.paragraphs.get(index);
        }

        @Override
        public boolean addAll(Collection<? extends CharSequence> paragraphs) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(CharSequence ... paragraphs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends CharSequence> paragraphs) {
            throw new UnsupportedOperationException();
        }

        public boolean setAll(CharSequence ... paragraphs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.content.paragraphs.size();
        }

        @Override
        public void addListener(ListChangeListener<? super CharSequence> listener) {
            this.content.listenerHelper = ListListenerHelper.addListener(this.content.listenerHelper, listener);
        }

        @Override
        public void removeListener(ListChangeListener<? super CharSequence> listener) {
            this.content.listenerHelper = ListListenerHelper.removeListener(this.content.listenerHelper, listener);
        }

        public boolean removeAll(CharSequence ... elements) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(CharSequence ... elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int from, int to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.content.listenerHelper = ListListenerHelper.addListener(this.content.listenerHelper, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.content.listenerHelper = ListListenerHelper.removeListener(this.content.listenerHelper, listener);
        }
    }

    private static final class TextAreaContent
    implements TextInputControl.Content {
        private ExpressionHelper<String> helper = null;
        private ArrayList<StringBuilder> paragraphs = new ArrayList();
        private int contentLength = 0;
        private ParagraphList paragraphList = new ParagraphList();
        private ListListenerHelper<CharSequence> listenerHelper;

        private TextAreaContent() {
            this.paragraphs.add(new StringBuilder(32));
            this.paragraphList.content = this;
        }

        @Override
        public String get(int start, int end) {
            StringBuilder paragraph;
            int offset;
            int count;
            int length = end - start;
            StringBuilder textBuilder = new StringBuilder(length);
            int paragraphCount = this.paragraphs.size();
            int paragraphIndex = 0;
            for (offset = start; paragraphIndex < paragraphCount && offset >= (count = (paragraph = this.paragraphs.get(paragraphIndex)).length() + 1); offset -= count, ++paragraphIndex) {
            }
            paragraph = this.paragraphs.get(paragraphIndex);
            for (int i = 0; i < length; ++i) {
                if (offset == paragraph.length() && i < this.contentLength) {
                    textBuilder.append('\n');
                    paragraph = this.paragraphs.get(++paragraphIndex);
                    offset = 0;
                    continue;
                }
                textBuilder.append(paragraph.charAt(offset++));
            }
            return textBuilder.toString();
        }

        @Override
        public void insert(int index, String text, boolean notifyListeners) {
            if (index < 0 || index > this.contentLength) {
                throw new IndexOutOfBoundsException();
            }
            if (text == null) {
                throw new IllegalArgumentException();
            }
            int length = (text = TextInputControl.filterInput(text, false, false)).length();
            if (length > 0) {
                ArrayList<StringBuilder> lines = new ArrayList<StringBuilder>();
                StringBuilder line = new StringBuilder(32);
                for (int i = 0; i < length; ++i) {
                    char c = text.charAt(i);
                    if (c == '\n') {
                        lines.add(line);
                        line = new StringBuilder(32);
                        continue;
                    }
                    line.append(c);
                }
                lines.add(line);
                int paragraphIndex = this.paragraphs.size();
                int offset = this.contentLength + 1;
                StringBuilder paragraph = null;
                while (index < (offset -= (paragraph = this.paragraphs.get(--paragraphIndex)).length() + 1)) {
                }
                int start = index - offset;
                int n = lines.size();
                if (n == 1) {
                    paragraph.insert(start, line);
                    this.fireParagraphListChangeEvent(paragraphIndex, paragraphIndex + 1, Collections.singletonList(paragraph));
                } else {
                    int end = paragraph.length();
                    CharSequence trailingText = paragraph.subSequence(start, end);
                    paragraph.delete(start, end);
                    StringBuilder first = (StringBuilder)lines.get(0);
                    paragraph.insert(start, first);
                    line.append(trailingText);
                    this.fireParagraphListChangeEvent(paragraphIndex, paragraphIndex + 1, Collections.singletonList(paragraph));
                    this.paragraphs.addAll(paragraphIndex + 1, lines.subList(1, n));
                    this.fireParagraphListChangeEvent(paragraphIndex + 1, paragraphIndex + n, Collections.EMPTY_LIST);
                }
                this.contentLength += length;
                if (notifyListeners) {
                    ExpressionHelper.fireValueChangedEvent(this.helper);
                }
            }
        }

        @Override
        public void delete(int start, int end, boolean notifyListeners) {
            if (start > end) {
                throw new IllegalArgumentException();
            }
            if (start < 0 || end > this.contentLength) {
                throw new IndexOutOfBoundsException();
            }
            int length = end - start;
            if (length > 0) {
                int paragraphIndex = this.paragraphs.size();
                int offset = this.contentLength + 1;
                StringBuilder paragraph = null;
                while (end < (offset -= (paragraph = this.paragraphs.get(--paragraphIndex)).length() + 1)) {
                }
                int trailingParagraphIndex = paragraphIndex++;
                int trailingOffset = offset;
                StringBuilder trailingParagraph = paragraph;
                offset += paragraph.length() + 1;
                while (start < (offset -= (paragraph = this.paragraphs.get(--paragraphIndex)).length() + 1)) {
                }
                int leadingParagraphIndex = paragraphIndex;
                int leadingOffset = offset;
                StringBuilder leadingParagraph = paragraph;
                if (leadingParagraphIndex == trailingParagraphIndex) {
                    leadingParagraph.delete(start - leadingOffset, end - leadingOffset);
                    this.fireParagraphListChangeEvent(leadingParagraphIndex, leadingParagraphIndex + 1, Collections.singletonList(leadingParagraph));
                } else {
                    CharSequence leadingSegment = leadingParagraph.subSequence(0, start - leadingOffset);
                    int trailingSegmentLength = start + length - trailingOffset;
                    trailingParagraph.delete(0, trailingSegmentLength);
                    this.fireParagraphListChangeEvent(trailingParagraphIndex, trailingParagraphIndex + 1, Collections.singletonList(trailingParagraph));
                    if (trailingParagraphIndex - leadingParagraphIndex > 0) {
                        ArrayList<CharSequence> removed = new ArrayList<CharSequence>(this.paragraphs.subList(leadingParagraphIndex, trailingParagraphIndex));
                        this.paragraphs.subList(leadingParagraphIndex, trailingParagraphIndex).clear();
                        this.fireParagraphListChangeEvent(leadingParagraphIndex, leadingParagraphIndex, removed);
                    }
                    trailingParagraph.insert(0, leadingSegment);
                    this.fireParagraphListChangeEvent(leadingParagraphIndex, leadingParagraphIndex + 1, Collections.singletonList(leadingParagraph));
                }
                this.contentLength -= length;
                if (notifyListeners) {
                    ExpressionHelper.fireValueChangedEvent(this.helper);
                }
            }
        }

        @Override
        public int length() {
            return this.contentLength;
        }

        @Override
        public String get() {
            return this.get(0, this.length());
        }

        @Override
        public void addListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super String> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public String getValue() {
            return this.get();
        }

        @Override
        public void addListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, listener);
        }

        @Override
        public void removeListener(InvalidationListener listener) {
            this.helper = ExpressionHelper.removeListener(this.helper, listener);
        }

        private void fireParagraphListChangeEvent(int from, int to, List<CharSequence> removed) {
            ParagraphListChange change = new ParagraphListChange(this.paragraphList, from, to, removed);
            ListListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
        }
    }
}

