/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.chart;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Bounds;
import javafx.geometry.Dimension2D;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.util.Duration;

public abstract class Axis<T>
extends Region {
    Text measure = new Text();
    private Orientation effectiveOrientation;
    private double effectiveTickLabelRotation = Double.NaN;
    private Label axisLabel = new Label();
    private final Path tickMarkPath = new Path();
    private double oldLength = 0.0;
    boolean rangeValid = false;
    boolean measureInvalid = false;
    boolean tickLabelsVisibleInvalid = false;
    private BitSet labelsToSkip = new BitSet();
    private final ObservableList<TickMark<T>> tickMarks = FXCollections.observableArrayList();
    private final ObservableList<TickMark<T>> unmodifiableTickMarks = FXCollections.unmodifiableObservableList(this.tickMarks);
    private ObjectProperty<Side> side = new StyleableObjectProperty<Side>(){

        @Override
        protected void invalidated() {
            Side edge = (Side)((Object)this.get());
            Axis.this.pseudoClassStateChanged(TOP_PSEUDOCLASS_STATE, edge == Side.TOP);
            Axis.this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS_STATE, edge == Side.RIGHT);
            Axis.this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS_STATE, edge == Side.BOTTOM);
            Axis.this.pseudoClassStateChanged(LEFT_PSEUDOCLASS_STATE, edge == Side.LEFT);
            Axis.this.requestAxisLayout();
        }

        @Override
        public CssMetaData<Axis<?>, Side> getCssMetaData() {
            return StyleableProperties.SIDE;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "side";
        }
    };
    private ObjectProperty<String> label = new ObjectPropertyBase<String>(){

        @Override
        protected void invalidated() {
            Axis.this.axisLabel.setText((String)this.get());
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "label";
        }
    };
    private BooleanProperty tickMarkVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            Axis.this.tickMarkPath.setVisible(this.get());
            Axis.this.requestAxisLayout();
        }

        @Override
        public CssMetaData<Axis<?>, Boolean> getCssMetaData() {
            return StyleableProperties.TICK_MARK_VISIBLE;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickMarkVisible";
        }
    };
    private BooleanProperty tickLabelsVisible = new StyleableBooleanProperty(true){

        @Override
        protected void invalidated() {
            for (TickMark tick : Axis.this.tickMarks) {
                tick.setTextVisible(this.get());
            }
            Axis.this.tickLabelsVisibleInvalid = true;
            Axis.this.requestAxisLayout();
        }

        @Override
        public CssMetaData<Axis<?>, Boolean> getCssMetaData() {
            return StyleableProperties.TICK_LABELS_VISIBLE;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelsVisible";
        }
    };
    private DoubleProperty tickLength = new StyleableDoubleProperty(8.0){

        @Override
        protected void invalidated() {
            if (Axis.this.tickLength.get() < 0.0 && !Axis.this.tickLength.isBound()) {
                Axis.this.tickLength.set(0.0);
            }
            Axis.this.requestAxisLayout();
        }

        @Override
        public CssMetaData<Axis<?>, Number> getCssMetaData() {
            return StyleableProperties.TICK_LENGTH;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLength";
        }
    };
    private BooleanProperty autoRanging = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            if (this.get()) {
                Axis.this.requestAxisLayout();
            }
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "autoRanging";
        }
    };
    private ObjectProperty<Font> tickLabelFont = new StyleableObjectProperty<Font>(Font.font("System", 8.0)){

        @Override
        protected void invalidated() {
            Font f = (Font)this.get();
            Axis.this.measure.setFont(f);
            for (TickMark tickMark : Axis.this.getTickMarks()) {
                tickMark.textNode.setFont(f);
            }
            Axis.this.measureInvalid = true;
            Axis.this.requestAxisLayout();
        }

        @Override
        public CssMetaData<Axis<?>, Font> getCssMetaData() {
            return StyleableProperties.TICK_LABEL_FONT;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelFont";
        }
    };
    private ObjectProperty<Paint> tickLabelFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

        @Override
        protected void invalidated() {
            for (TickMark tick : Axis.this.tickMarks) {
                tick.textNode.setFill(Axis.this.getTickLabelFill());
            }
        }

        @Override
        public CssMetaData<Axis<?>, Paint> getCssMetaData() {
            return StyleableProperties.TICK_LABEL_FILL;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelFill";
        }
    };
    private DoubleProperty tickLabelGap = new StyleableDoubleProperty(3.0){

        @Override
        protected void invalidated() {
            Axis.this.requestAxisLayout();
        }

        @Override
        public CssMetaData<Axis<?>, Number> getCssMetaData() {
            return StyleableProperties.TICK_LABEL_TICK_GAP;
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelGap";
        }
    };
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);
    private DoubleProperty tickLabelRotation = new DoublePropertyBase(0.0){

        @Override
        protected void invalidated() {
            if (Axis.this.isAutoRanging()) {
                Axis.this.invalidateRange();
            }
            Axis.this.requestAxisLayout();
        }

        @Override
        public Object getBean() {
            return Axis.this;
        }

        @Override
        public String getName() {
            return "tickLabelRotation";
        }
    };
    private static final PseudoClass TOP_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("bottom");
    private static final PseudoClass LEFT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("left");
    private static final PseudoClass RIGHT_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("right");

    public ObservableList<TickMark<T>> getTickMarks() {
        return this.unmodifiableTickMarks;
    }

    public final Side getSide() {
        return (Side)((Object)this.side.get());
    }

    public final void setSide(Side value) {
        this.side.set(value);
    }

    public final ObjectProperty<Side> sideProperty() {
        return this.side;
    }

    final void setEffectiveOrientation(Orientation orientation) {
        this.effectiveOrientation = orientation;
    }

    final Side getEffectiveSide() {
        Side side = this.getSide();
        if (side == null || side.isVertical() && this.effectiveOrientation == Orientation.HORIZONTAL || side.isHorizontal() && this.effectiveOrientation == Orientation.VERTICAL) {
            return this.effectiveOrientation == Orientation.VERTICAL ? Side.LEFT : Side.BOTTOM;
        }
        return side;
    }

    public final String getLabel() {
        return (String)this.label.get();
    }

    public final void setLabel(String value) {
        this.label.set(value);
    }

    public final ObjectProperty<String> labelProperty() {
        return this.label;
    }

    public final boolean isTickMarkVisible() {
        return this.tickMarkVisible.get();
    }

    public final void setTickMarkVisible(boolean value) {
        this.tickMarkVisible.set(value);
    }

    public final BooleanProperty tickMarkVisibleProperty() {
        return this.tickMarkVisible;
    }

    public final boolean isTickLabelsVisible() {
        return this.tickLabelsVisible.get();
    }

    public final void setTickLabelsVisible(boolean value) {
        this.tickLabelsVisible.set(value);
    }

    public final BooleanProperty tickLabelsVisibleProperty() {
        return this.tickLabelsVisible;
    }

    public final double getTickLength() {
        return this.tickLength.get();
    }

    public final void setTickLength(double value) {
        this.tickLength.set(value);
    }

    public final DoubleProperty tickLengthProperty() {
        return this.tickLength;
    }

    public final boolean isAutoRanging() {
        return this.autoRanging.get();
    }

    public final void setAutoRanging(boolean value) {
        this.autoRanging.set(value);
    }

    public final BooleanProperty autoRangingProperty() {
        return this.autoRanging;
    }

    public final Font getTickLabelFont() {
        return (Font)this.tickLabelFont.get();
    }

    public final void setTickLabelFont(Font value) {
        this.tickLabelFont.set(value);
    }

    public final ObjectProperty<Font> tickLabelFontProperty() {
        return this.tickLabelFont;
    }

    public final Paint getTickLabelFill() {
        return (Paint)this.tickLabelFill.get();
    }

    public final void setTickLabelFill(Paint value) {
        this.tickLabelFill.set(value);
    }

    public final ObjectProperty<Paint> tickLabelFillProperty() {
        return this.tickLabelFill;
    }

    public final double getTickLabelGap() {
        return this.tickLabelGap.get();
    }

    public final void setTickLabelGap(double value) {
        this.tickLabelGap.set(value);
    }

    public final DoubleProperty tickLabelGapProperty() {
        return this.tickLabelGap;
    }

    public final boolean getAnimated() {
        return this.animated.get();
    }

    public final void setAnimated(boolean value) {
        this.animated.set(value);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final double getTickLabelRotation() {
        return this.tickLabelRotation.getValue();
    }

    public final void setTickLabelRotation(double value) {
        this.tickLabelRotation.setValue(value);
    }

    public final DoubleProperty tickLabelRotationProperty() {
        return this.tickLabelRotation;
    }

    public Axis() {
        this.getStyleClass().setAll((String[])new String[]{"axis"});
        this.axisLabel.getStyleClass().add("axis-label");
        this.axisLabel.setAlignment(Pos.CENTER);
        this.tickMarkPath.getStyleClass().add("axis-tick-mark");
        this.getChildren().addAll((Node[])new Node[]{this.axisLabel, this.tickMarkPath});
    }

    protected final boolean isRangeValid() {
        return this.rangeValid;
    }

    protected final void invalidateRange() {
        this.rangeValid = false;
    }

    protected final boolean shouldAnimate() {
        return this.getAnimated() && this.impl_isTreeVisible() && this.getScene() != null;
    }

    @Override
    public void requestLayout() {
    }

    public void requestAxisLayout() {
        super.requestLayout();
    }

    public void invalidateRange(List<T> data) {
        this.invalidateRange();
        this.requestAxisLayout();
    }

    protected abstract Object autoRange(double var1);

    protected abstract void setRange(Object var1, boolean var2);

    protected abstract Object getRange();

    public abstract double getZeroPosition();

    public abstract double getDisplayPosition(T var1);

    public abstract T getValueForDisplay(double var1);

    public abstract boolean isValueOnAxis(T var1);

    public abstract double toNumericValue(T var1);

    public abstract T toRealValue(double var1);

    protected abstract List<T> calculateTickValues(double var1, Object var3);

    @Override
    protected double computePrefHeight(double width) {
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            return 100.0;
        }
        Object range = this.autoRange(width);
        double maxLabelHeight = 0.0;
        if (this.isTickLabelsVisible()) {
            List<T> newTickValues = this.calculateTickValues(width, range);
            for (T value : newTickValues) {
                maxLabelHeight = Math.max(maxLabelHeight, this.measureTickMarkSize(value, range).getHeight());
            }
        }
        double tickMarkLength = this.isTickMarkVisible() ? (this.getTickLength() > 0.0 ? this.getTickLength() : 0.0) : 0.0;
        double labelHeight = this.axisLabel.getText() == null || this.axisLabel.getText().length() == 0 ? 0.0 : this.axisLabel.prefHeight(-1.0);
        return maxLabelHeight + this.getTickLabelGap() + tickMarkLength + labelHeight;
    }

    @Override
    protected double computePrefWidth(double height) {
        Side side = this.getEffectiveSide();
        if (side.isVertical()) {
            Object range = this.autoRange(height);
            double maxLabelWidth = 0.0;
            if (this.isTickLabelsVisible()) {
                List<T> newTickValues = this.calculateTickValues(height, range);
                for (T value : newTickValues) {
                    maxLabelWidth = Math.max(maxLabelWidth, this.measureTickMarkSize(value, range).getWidth());
                }
            }
            double tickMarkLength = this.isTickMarkVisible() ? (this.getTickLength() > 0.0 ? this.getTickLength() : 0.0) : 0.0;
            double labelHeight = this.axisLabel.getText() == null || this.axisLabel.getText().length() == 0 ? 0.0 : this.axisLabel.prefHeight(-1.0);
            return maxLabelWidth + this.getTickLabelGap() + tickMarkLength + labelHeight;
        }
        return 100.0;
    }

    protected void tickMarksUpdated() {
    }

    @Override
    protected void layoutChildren() {
        boolean lengthDiffers;
        double width = this.getWidth();
        double height = this.getHeight();
        double tickMarkLength = this.isTickMarkVisible() && this.getTickLength() > 0.0 ? this.getTickLength() : 0.0;
        boolean isFirstPass = this.oldLength == 0.0;
        Side side = this.getEffectiveSide();
        double length = side.isVertical() ? height : width;
        boolean rangeInvalid = !this.isRangeValid();
        boolean bl = lengthDiffers = this.oldLength != length;
        if (lengthDiffers || rangeInvalid) {
            Object range;
            if (this.isAutoRanging()) {
                range = this.autoRange(length);
                this.setRange(range, this.getAnimated() && !isFirstPass && this.impl_isTreeVisible() && rangeInvalid);
            } else {
                range = this.getRange();
            }
            List<T> newTickValues = this.calculateTickValues(length, range);
            Iterator tickMarkIterator = this.tickMarks.iterator();
            while (tickMarkIterator.hasNext()) {
                TickMark tickMark;
                TickMark tm = tickMark = (TickMark)tickMarkIterator.next();
                if (this.shouldAnimate()) {
                    FadeTransition ft = new FadeTransition(Duration.millis(250.0), tickMark.textNode);
                    ft.setToValue(0.0);
                    ft.setOnFinished(actionEvent -> this.getChildren().remove(tm.textNode));
                    ft.play();
                } else {
                    this.getChildren().remove(tm.textNode);
                }
                tickMarkIterator.remove();
            }
            for (T newValue : newTickValues) {
                TickMark tick = new TickMark();
                tick.setValue(newValue);
                tick.textNode.setText(this.getTickMarkLabel(newValue));
                tick.textNode.setFont(this.getTickLabelFont());
                tick.textNode.setFill(this.getTickLabelFill());
                tick.setTextVisible(this.isTickLabelsVisible());
                if (this.shouldAnimate()) {
                    tick.textNode.setOpacity(0.0);
                }
                this.getChildren().add(tick.textNode);
                this.tickMarks.add(tick);
                if (!this.shouldAnimate()) continue;
                FadeTransition fadeTransition = new FadeTransition(Duration.millis(750.0), tick.textNode);
                fadeTransition.setFromValue(0.0);
                fadeTransition.setToValue(1.0);
                fadeTransition.play();
            }
            this.tickMarksUpdated();
            this.oldLength = length;
            this.rangeValid = true;
        }
        if (lengthDiffers || rangeInvalid || this.measureInvalid || this.tickLabelsVisibleInvalid) {
            this.measureInvalid = false;
            this.tickLabelsVisibleInvalid = false;
            this.labelsToSkip.clear();
            int numLabelsToSkip = 0;
            double totalLabelsSize = 0.0;
            double d = 0.0;
            for (TickMark tickMark : this.tickMarks) {
                tickMark.setPosition(this.getDisplayPosition(tickMark.getValue()));
                if (!tickMark.isTextVisible()) continue;
                double d2 = this.measureTickMarkSize(tickMark.getValue(), side);
                totalLabelsSize += d2;
                d = Math.round(Math.max(d, d2));
            }
            if (d > 0.0 && length < totalLabelsSize) {
                numLabelsToSkip = (int)((double)this.tickMarks.size() * d / length) + 1;
            }
            if (numLabelsToSkip > 0) {
                int tickIndex = 0;
                for (TickMark tickMark : this.tickMarks) {
                    if (!tickMark.isTextVisible()) continue;
                    tickMark.setTextVisible(tickIndex++ % numLabelsToSkip == 0);
                }
            }
            if (this.tickMarks.size() > 2) {
                TickMark tickMark;
                TickMark tickMark2;
                TickMark m1 = (TickMark)this.tickMarks.get(0);
                if (this.isTickLabelsOverlap(side, m1, tickMark2 = (TickMark)this.tickMarks.get(1), this.getTickLabelGap())) {
                    tickMark2.setTextVisible(false);
                }
                if (this.isTickLabelsOverlap(side, m1 = (TickMark)this.tickMarks.get(this.tickMarks.size() - 2), tickMark = (TickMark)this.tickMarks.get(this.tickMarks.size() - 1), this.getTickLabelGap())) {
                    m1.setTextVisible(false);
                }
            }
        }
        this.tickMarkPath.getElements().clear();
        double effectiveLabelRotation = this.getEffectiveTickLabelRotation();
        if (Side.LEFT.equals((Object)side)) {
            this.tickMarkPath.setLayoutX(-0.5);
            this.tickMarkPath.setLayoutY(0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().setAll((Transform[])new Transform[]{new Translate(0.0, height), new Rotate(-90.0, 0.0, 0.0)});
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(0.0);
                this.axisLabel.resize(height, Math.ceil(this.axisLabel.prefHeight(width)));
            }
            for (TickMark tickMark : this.tickMarks) {
                this.positionTextNode(tickMark.textNode, width - this.getTickLabelGap() - tickMarkLength, tickMark.getPosition(), effectiveLabelRotation, side);
                this.updateTickMark(tickMark, length, width - tickMarkLength, tickMark.getPosition(), width, tickMark.getPosition());
            }
        } else if (Side.RIGHT.equals((Object)side)) {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(0.5);
            if (this.getLabel() != null) {
                double axisLabelWidth = Math.ceil(this.axisLabel.prefHeight(width));
                this.axisLabel.getTransforms().setAll((Transform[])new Transform[]{new Translate(0.0, height), new Rotate(-90.0, 0.0, 0.0)});
                this.axisLabel.setLayoutX(width - axisLabelWidth);
                this.axisLabel.setLayoutY(0.0);
                this.axisLabel.resize(height, axisLabelWidth);
            }
            for (TickMark tickMark : this.tickMarks) {
                this.positionTextNode(tickMark.textNode, this.getTickLabelGap() + tickMarkLength, tickMark.getPosition(), effectiveLabelRotation, side);
                this.updateTickMark(tickMark, length, 0.0, tickMark.getPosition(), tickMarkLength, tickMark.getPosition());
            }
        } else if (Side.TOP.equals((Object)side)) {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(-0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().clear();
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(0.0);
                this.axisLabel.resize(width, Math.ceil(this.axisLabel.prefHeight(width)));
            }
            for (TickMark tickMark : this.tickMarks) {
                this.positionTextNode(tickMark.textNode, tickMark.getPosition(), height - tickMarkLength - this.getTickLabelGap(), effectiveLabelRotation, side);
                this.updateTickMark(tickMark, length, tickMark.getPosition(), height, tickMark.getPosition(), height - tickMarkLength);
            }
        } else {
            this.tickMarkPath.setLayoutX(0.5);
            this.tickMarkPath.setLayoutY(0.5);
            if (this.getLabel() != null) {
                this.axisLabel.getTransforms().clear();
                double labelHeight = Math.ceil(this.axisLabel.prefHeight(width));
                this.axisLabel.setLayoutX(0.0);
                this.axisLabel.setLayoutY(height - labelHeight);
                this.axisLabel.resize(width, labelHeight);
            }
            for (TickMark tickMark : this.tickMarks) {
                this.positionTextNode(tickMark.textNode, tickMark.getPosition(), tickMarkLength + this.getTickLabelGap(), effectiveLabelRotation, side);
                this.updateTickMark(tickMark, length, tickMark.getPosition(), 0.0, tickMark.getPosition(), tickMarkLength);
            }
        }
    }

    private boolean isTickLabelsOverlap(Side side, TickMark<T> m1, TickMark<T> m2, double gap) {
        if (!m1.isTextVisible() || !m2.isTextVisible()) {
            return false;
        }
        double m1Size = this.measureTickMarkSize(m1.getValue(), side);
        double m2Size = this.measureTickMarkSize(m2.getValue(), side);
        double m1Start = m1.getPosition() - m1Size / 2.0;
        double m1End = m1.getPosition() + m1Size / 2.0;
        double m2Start = m2.getPosition() - m2Size / 2.0;
        double m2End = m2.getPosition() + m2Size / 2.0;
        return side.isVertical() ? m1Start - m2End <= gap : m2Start - m1End <= gap;
    }

    private void positionTextNode(Text node, double posX, double posY, double angle, Side side) {
        node.setLayoutX(0.0);
        node.setLayoutY(0.0);
        node.setRotate(angle);
        Bounds bounds = node.getBoundsInParent();
        if (Side.LEFT.equals((Object)side)) {
            node.setLayoutX(posX - bounds.getWidth() - bounds.getMinX());
            node.setLayoutY(posY - bounds.getHeight() / 2.0 - bounds.getMinY());
        } else if (Side.RIGHT.equals((Object)side)) {
            node.setLayoutX(posX - bounds.getMinX());
            node.setLayoutY(posY - bounds.getHeight() / 2.0 - bounds.getMinY());
        } else if (Side.TOP.equals((Object)side)) {
            node.setLayoutX(posX - bounds.getWidth() / 2.0 - bounds.getMinX());
            node.setLayoutY(posY - bounds.getHeight() - bounds.getMinY());
        } else {
            node.setLayoutX(posX - bounds.getWidth() / 2.0 - bounds.getMinX());
            node.setLayoutY(posY - bounds.getMinY());
        }
    }

    private void updateTickMark(TickMark<T> tick, double length, double startX, double startY, double endX, double endY) {
        if (tick.getPosition() >= 0.0 && tick.getPosition() <= Math.ceil(length)) {
            tick.textNode.setVisible(tick.isTextVisible());
            this.tickMarkPath.getElements().addAll((PathElement[])new PathElement[]{new MoveTo(startX, startY), new LineTo(endX, endY)});
        } else {
            tick.textNode.setVisible(false);
        }
    }

    protected abstract String getTickMarkLabel(T var1);

    protected final Dimension2D measureTickMarkLabelSize(String labelText, double rotation) {
        this.measure.setRotate(rotation);
        this.measure.setText(labelText);
        Bounds bounds = this.measure.getBoundsInParent();
        return new Dimension2D(bounds.getWidth(), bounds.getHeight());
    }

    protected final Dimension2D measureTickMarkSize(T value, double rotation) {
        return this.measureTickMarkLabelSize(this.getTickMarkLabel(value), rotation);
    }

    protected Dimension2D measureTickMarkSize(T value, Object range) {
        return this.measureTickMarkSize(value, this.getEffectiveTickLabelRotation());
    }

    private double measureTickMarkSize(T value, Side side) {
        Dimension2D size = this.measureTickMarkSize(value, this.getEffectiveTickLabelRotation());
        return side.isVertical() ? size.getHeight() : size.getWidth();
    }

    final double getEffectiveTickLabelRotation() {
        return !this.isAutoRanging() || Double.isNaN(this.effectiveTickLabelRotation) ? this.getTickLabelRotation() : this.effectiveTickLabelRotation;
    }

    final void setEffectiveTickLabelRotation(double rotation) {
        this.effectiveTickLabelRotation = rotation;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Axis.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Axis<?>, Side> SIDE = new CssMetaData<Axis<?>, Side>("-fx-side", new EnumConverter<Side>(Side.class)){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).side == null || !((Axis)n).side.isBound();
            }

            @Override
            public StyleableProperty<Side> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.sideProperty());
            }
        };
        private static final CssMetaData<Axis<?>, Number> TICK_LENGTH = new CssMetaData<Axis<?>, Number>("-fx-tick-length", SizeConverter.getInstance(), 8.0){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).tickLength == null || !((Axis)n).tickLength.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.tickLengthProperty());
            }
        };
        private static final CssMetaData<Axis<?>, Font> TICK_LABEL_FONT = new FontCssMetaData<Axis<?>>("-fx-tick-label-font", Font.font("system", 8.0)){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).tickLabelFont == null || !((Axis)n).tickLabelFont.isBound();
            }

            @Override
            public StyleableProperty<Font> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.tickLabelFontProperty());
            }
        };
        private static final CssMetaData<Axis<?>, Paint> TICK_LABEL_FILL = new CssMetaData<Axis<?>, Paint>("-fx-tick-label-fill", PaintConverter.getInstance(), Color.BLACK){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).tickLabelFill == null | !((Axis)n).tickLabelFill.isBound();
            }

            @Override
            public StyleableProperty<Paint> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.tickLabelFillProperty());
            }
        };
        private static final CssMetaData<Axis<?>, Number> TICK_LABEL_TICK_GAP = new CssMetaData<Axis<?>, Number>("-fx-tick-label-gap", SizeConverter.getInstance(), 3.0){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).tickLabelGap == null || !((Axis)n).tickLabelGap.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.tickLabelGapProperty());
            }
        };
        private static final CssMetaData<Axis<?>, Boolean> TICK_MARK_VISIBLE = new CssMetaData<Axis<?>, Boolean>("-fx-tick-mark-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).tickMarkVisible == null || !((Axis)n).tickMarkVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.tickMarkVisibleProperty());
            }
        };
        private static final CssMetaData<Axis<?>, Boolean> TICK_LABELS_VISIBLE = new CssMetaData<Axis<?>, Boolean>("-fx-tick-labels-visible", BooleanConverter.getInstance(), Boolean.TRUE){

            @Override
            public boolean isSettable(Axis<?> n) {
                return ((Axis)n).tickLabelsVisible == null || !((Axis)n).tickLabelsVisible.isBound();
            }

            @Override
            public StyleableProperty<Boolean> getStyleableProperty(Axis<?> n) {
                return (StyleableProperty)((Object)n.tickLabelsVisibleProperty());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            styleables.add(SIDE);
            styleables.add(TICK_LENGTH);
            styleables.add(TICK_LABEL_FONT);
            styleables.add(TICK_LABEL_FILL);
            styleables.add(TICK_LABEL_TICK_GAP);
            styleables.add(TICK_MARK_VISIBLE);
            styleables.add(TICK_LABELS_VISIBLE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static final class TickMark<T> {
        private StringProperty label = new StringPropertyBase(){

            @Override
            protected void invalidated() {
                textNode.setText(this.getValue());
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "label";
            }
        };
        private ObjectProperty<T> value = new SimpleObjectProperty(this, "value");
        private DoubleProperty position = new SimpleDoubleProperty(this, "position");
        Text textNode = new Text();
        private BooleanProperty textVisible = new BooleanPropertyBase(true){

            @Override
            protected void invalidated() {
                if (!this.get()) {
                    textNode.setVisible(false);
                }
            }

            @Override
            public Object getBean() {
                return this;
            }

            @Override
            public String getName() {
                return "textVisible";
            }
        };

        public final String getLabel() {
            return (String)this.label.get();
        }

        public final void setLabel(String value) {
            this.label.set(value);
        }

        public final StringExpression labelProperty() {
            return this.label;
        }

        public final T getValue() {
            return this.value.get();
        }

        public final void setValue(T v) {
            this.value.set(v);
        }

        public final ObjectExpression<T> valueProperty() {
            return this.value;
        }

        public final double getPosition() {
            return this.position.get();
        }

        public final void setPosition(double value) {
            this.position.set(value);
        }

        public final DoubleExpression positionProperty() {
            return this.position;
        }

        public final boolean isTextVisible() {
            return this.textVisible.get();
        }

        public final void setTextVisible(boolean value) {
            this.textVisible.set(value);
        }

        public String toString() {
            return this.value.get().toString();
        }
    }
}

