/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.DataFlavorUtils;
import javafx.scene.input.Clipboard;
import javafx.scene.input.DataFormat;

class CachingTransferable
implements Transferable {
    private Map<String, Object> mimeType2Data = Collections.EMPTY_MAP;

    CachingTransferable() {
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedEncodingException {
        String mimeType = DataFlavorUtils.getFxMimeType(flavor);
        return DataFlavorUtils.adjustFxData(flavor, this.getData(mimeType));
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        String[] mimeTypes = this.getMimeTypes();
        return DataFlavorUtils.getDataFlavors(mimeTypes);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.isMimeTypeAvailable(DataFlavorUtils.getFxMimeType(flavor));
    }

    void updateData(Transferable t, boolean fetchData) {
        Map<String, DataFlavor> mimeType2DataFlavor = DataFlavorUtils.adjustSwingDataFlavors(t.getTransferDataFlavors());
        try {
            this.mimeType2Data = DataFlavorUtils.readAllData(t, mimeType2DataFlavor, fetchData);
        }
        catch (Exception e) {
            this.mimeType2Data = Collections.EMPTY_MAP;
        }
    }

    void updateData(Clipboard cb, boolean fetchData) {
        this.mimeType2Data = new HashMap<String, Object>();
        for (DataFormat f : cb.getContentTypes()) {
            this.mimeType2Data.put(DataFlavorUtils.getMimeType(f), fetchData ? cb.getContent(f) : null);
        }
    }

    public Object getData(String mimeType) {
        return this.mimeType2Data.get(mimeType);
    }

    public String[] getMimeTypes() {
        return this.mimeType2Data.keySet().toArray(new String[0]);
    }

    public boolean isMimeTypeAvailable(String mimeType) {
        return Arrays.asList(this.getMimeTypes()).contains(mimeType);
    }
}

