/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.java;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.BoxRenderState;
import com.sun.scenario.effect.impl.sw.java.JSWEffectPeer;

public class JSWBoxBlurPeer
extends JSWEffectPeer<BoxRenderState> {
    public JSWBoxBlurPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    public ImageData filter(Effect effect, BoxRenderState brstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        this.setRenderState(brstate);
        boolean horizontal = this.getPass() == 0;
        int hinc = horizontal ? brstate.getBoxPixelSize(0) - 1 : 0;
        int vinc = horizontal ? 0 : brstate.getBoxPixelSize(1) - 1;
        int iterations = brstate.getBlurPasses();
        if (iterations < 1 || hinc < 1 && vinc < 1) {
            inputs[0].addref();
            return inputs[0];
        }
        int growx = hinc * iterations + 1 & 0xFFFFFFFE;
        int growy = vinc * iterations + 1 & 0xFFFFFFFE;
        HeapImage src = (HeapImage)inputs[0].getUntransformedImage();
        Rectangle srcr = inputs[0].getUntransformedBounds();
        HeapImage cur = src;
        int curw = srcr.width;
        int curh = srcr.height;
        int curscan = cur.getScanlineStride();
        int[] curPixels = cur.getPixelArray();
        int finalw = curw + growx;
        int finalh = curh + growy;
        while (curw < finalw || curh < finalh) {
            int neww = curw + hinc;
            int newh = curh + vinc;
            if (neww > finalw) {
                neww = finalw;
            }
            if (newh > finalh) {
                newh = finalh;
            }
            HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(neww, newh));
            int newscan = dst.getScanlineStride();
            int[] newPixels = dst.getPixelArray();
            if (horizontal) {
                this.filterHorizontal(newPixels, neww, newh, newscan, curPixels, curw, curh, curscan);
            } else {
                this.filterVertical(newPixels, neww, newh, newscan, curPixels, curw, curh, curscan);
            }
            if (cur != src) {
                this.getRenderer().releaseCompatibleImage(cur);
            }
            cur = dst;
            curw = neww;
            curh = newh;
            curPixels = newPixels;
            curscan = newscan;
        }
        Rectangle resBounds = new Rectangle(srcr.x - growx / 2, srcr.y - growy / 2, curw, curh);
        return new ImageData(this.getFilterContext(), cur, resBounds);
    }

    protected void filterHorizontal(int[] dstPixels, int dstw, int dsth, int dstscan, int[] srcPixels, int srcw, int srch, int srcscan) {
        int hsize = dstw - srcw + 1;
        int kscale = Integer.MAX_VALUE / (hsize * 255);
        int srcoff = 0;
        int dstoff = 0;
        for (int y = 0; y < dsth; ++y) {
            int suma = 0;
            int sumr = 0;
            int sumg = 0;
            int sumb = 0;
            for (int x = 0; x < dstw; ++x) {
                int rgb = x >= hsize ? srcPixels[srcoff + x - hsize] : 0;
                suma -= rgb >>> 24;
                sumr -= rgb >> 16 & 0xFF;
                sumg -= rgb >> 8 & 0xFF;
                sumb -= rgb & 0xFF;
                rgb = x < srcw ? srcPixels[srcoff + x] : 0;
                dstPixels[dstoff + x] = ((suma += rgb >>> 24) * kscale >> 23 << 24) + ((sumr += rgb >> 16 & 0xFF) * kscale >> 23 << 16) + ((sumg += rgb >> 8 & 0xFF) * kscale >> 23 << 8) + ((sumb += rgb & 0xFF) * kscale >> 23);
            }
            srcoff += srcscan;
            dstoff += dstscan;
        }
    }

    protected void filterVertical(int[] dstPixels, int dstw, int dsth, int dstscan, int[] srcPixels, int srcw, int srch, int srcscan) {
        int vsize = dsth - srch + 1;
        int kscale = Integer.MAX_VALUE / (vsize * 255);
        int voff = vsize * srcscan;
        for (int x = 0; x < dstw; ++x) {
            int suma = 0;
            int sumr = 0;
            int sumg = 0;
            int sumb = 0;
            int srcoff = x;
            int dstoff = x;
            for (int y = 0; y < dsth; ++y) {
                int rgb = srcoff >= voff ? srcPixels[srcoff - voff] : 0;
                suma -= rgb >>> 24;
                sumr -= rgb >> 16 & 0xFF;
                sumg -= rgb >> 8 & 0xFF;
                sumb -= rgb & 0xFF;
                rgb = y < srch ? srcPixels[srcoff] : 0;
                dstPixels[dstoff] = ((suma += rgb >>> 24) * kscale >> 23 << 24) + ((sumr += rgb >> 16 & 0xFF) * kscale >> 23 << 16) + ((sumg += rgb >> 8 & 0xFF) * kscale >> 23 << 8) + ((sumb += rgb & 0xFF) * kscale >> 23);
                srcoff += srcscan;
                dstoff += dstscan;
            }
        }
    }
}

