/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.locator;

import com.sun.media.jfxmedia.locator.HLSConnectionHolder;
import com.sun.media.jfxmedia.locator.Locator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Map;

public abstract class ConnectionHolder {
    private static int DEFAULT_BUFFER_SIZE = 4096;
    ReadableByteChannel channel;
    ByteBuffer buffer = ByteBuffer.allocateDirect(DEFAULT_BUFFER_SIZE);

    static ConnectionHolder createMemoryConnectionHolder(ByteBuffer buffer) {
        return new MemoryConnectionHolder(buffer);
    }

    static ConnectionHolder createURIConnectionHolder(URI uri, Map<String, Object> connectionProperties) throws IOException {
        return new URIConnectionHolder(uri, connectionProperties);
    }

    static ConnectionHolder createFileConnectionHolder(URI uri) throws IOException {
        return new FileConnectionHolder(uri);
    }

    static ConnectionHolder createHLSConnectionHolder(URI uri) throws IOException {
        return new HLSConnectionHolder(uri);
    }

    public int readNextBlock() throws IOException {
        this.buffer.rewind();
        if (this.buffer.limit() < this.buffer.capacity()) {
            this.buffer.limit(this.buffer.capacity());
        }
        if (null == this.channel) {
            throw new ClosedChannelException();
        }
        return this.channel.read(this.buffer);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    abstract int readBlock(long var1, int var3) throws IOException;

    abstract boolean needBuffer();

    abstract boolean isSeekable();

    abstract boolean isRandomAccess();

    public abstract long seek(long var1);

    public void closeConnection() {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.channel = null;
        }
    }

    int property(int prop, int value) {
        return 0;
    }

    int getStreamSize() {
        return -1;
    }

    private static class MemoryConnectionHolder
    extends ConnectionHolder {
        private final ByteBuffer backingBuffer;

        public MemoryConnectionHolder(ByteBuffer buf) {
            if (null == buf) {
                throw new IllegalArgumentException("Can't connect to null buffer...");
            }
            if (buf.isDirect()) {
                this.backingBuffer = buf.duplicate();
            } else {
                this.backingBuffer = ByteBuffer.allocateDirect(buf.capacity());
                this.backingBuffer.put(buf);
            }
            this.backingBuffer.rewind();
            this.channel = new ReadableByteChannel(){

                @Override
                public int read(ByteBuffer bb) throws IOException {
                    int actual;
                    if (backingBuffer.remaining() <= 0) {
                        return -1;
                    }
                    if (bb.equals(buffer)) {
                        actual = Math.min(DEFAULT_BUFFER_SIZE, backingBuffer.remaining());
                        if (actual > 0) {
                            buffer = backingBuffer.slice();
                            buffer.limit(actual);
                        }
                    } else {
                        actual = Math.min(bb.remaining(), backingBuffer.remaining());
                        if (actual > 0) {
                            backingBuffer.limit(backingBuffer.position() + actual);
                            bb.put(backingBuffer);
                            backingBuffer.limit(backingBuffer.capacity());
                        }
                    }
                    return actual;
                }

                @Override
                public boolean isOpen() {
                    return true;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }

        @Override
        int readBlock(long position, int size) throws IOException {
            if (null == this.channel) {
                throw new ClosedChannelException();
            }
            if ((int)position > this.backingBuffer.capacity()) {
                return -1;
            }
            this.backingBuffer.position((int)position);
            this.buffer = this.backingBuffer.slice();
            int actual = Math.min(this.backingBuffer.remaining(), size);
            this.buffer.limit(actual);
            this.backingBuffer.position(this.backingBuffer.position() + actual);
            return actual;
        }

        @Override
        boolean needBuffer() {
            return false;
        }

        @Override
        boolean isSeekable() {
            return true;
        }

        @Override
        boolean isRandomAccess() {
            return true;
        }

        @Override
        public long seek(long position) {
            if ((int)position < this.backingBuffer.capacity()) {
                this.backingBuffer.limit(this.backingBuffer.capacity());
                this.backingBuffer.position((int)position);
                return position;
            }
            return -1L;
        }

        @Override
        public void closeConnection() {
            this.channel = null;
        }
    }

    private static class URIConnectionHolder
    extends ConnectionHolder {
        private URI uri;
        private URLConnection urlConnection;

        URIConnectionHolder(URI uri, Map<String, Object> connectionProperties) throws IOException {
            this.uri = uri;
            this.urlConnection = uri.toURL().openConnection();
            if (connectionProperties != null) {
                for (Map.Entry<String, Object> entry : connectionProperties.entrySet()) {
                    Object value = entry.getValue();
                    if (!(value instanceof String)) continue;
                    this.urlConnection.setRequestProperty(entry.getKey(), (String)value);
                }
            }
            this.channel = this.openChannel(null);
        }

        @Override
        boolean needBuffer() {
            String scheme = this.uri.getScheme().toLowerCase();
            return "http".equals(scheme) || "https".equals(scheme);
        }

        @Override
        boolean isSeekable() {
            return this.urlConnection instanceof HttpURLConnection || this.urlConnection instanceof JarURLConnection;
        }

        @Override
        boolean isRandomAccess() {
            return false;
        }

        @Override
        int readBlock(long position, int size) throws IOException {
            throw new IOException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long seek(long position) {
            if (this.urlConnection instanceof HttpURLConnection) {
                URLConnection tmpURLConnection = null;
                try {
                    tmpURLConnection = this.uri.toURL().openConnection();
                    HttpURLConnection httpConnection = (HttpURLConnection)tmpURLConnection;
                    httpConnection.setRequestMethod("GET");
                    httpConnection.setUseCaches(false);
                    httpConnection.setRequestProperty("Range", "bytes=" + position + "-");
                    if (httpConnection.getResponseCode() == 206) {
                        this.closeConnection();
                        this.urlConnection = tmpURLConnection;
                        tmpURLConnection = null;
                        this.channel = this.openChannel(null);
                        long l = position;
                        return l;
                    }
                    long l = -1L;
                    return l;
                }
                catch (IOException ioex) {
                    long l = -1L;
                    return l;
                }
                finally {
                    if (tmpURLConnection != null) {
                        Locator.closeConnection(tmpURLConnection);
                    }
                }
            }
            if (this.urlConnection instanceof JarURLConnection) {
                try {
                    long skip;
                    this.closeConnection();
                    this.urlConnection = this.uri.toURL().openConnection();
                    long skip_left = position;
                    InputStream inputStream = this.urlConnection.getInputStream();
                    while ((skip_left -= (skip = inputStream.skip(skip_left))) > 0L) {
                    }
                    this.channel = this.openChannel(inputStream);
                    return position;
                }
                catch (IOException ioex) {
                    return -1L;
                }
            }
            return -1L;
        }

        @Override
        public void closeConnection() {
            super.closeConnection();
            Locator.closeConnection(this.urlConnection);
            this.urlConnection = null;
        }

        private ReadableByteChannel openChannel(InputStream inputStream) throws IOException {
            return inputStream == null ? Channels.newChannel(this.urlConnection.getInputStream()) : Channels.newChannel(inputStream);
        }
    }

    private static class FileConnectionHolder
    extends ConnectionHolder {
        private RandomAccessFile file = null;

        FileConnectionHolder(URI uri) throws IOException {
            this.channel = this.openFile(uri);
        }

        @Override
        boolean needBuffer() {
            return false;
        }

        @Override
        boolean isRandomAccess() {
            return true;
        }

        @Override
        boolean isSeekable() {
            return true;
        }

        @Override
        public long seek(long position) {
            try {
                ((FileChannel)this.channel).position(position);
                return position;
            }
            catch (IOException ioex) {
                return -1L;
            }
        }

        @Override
        int readBlock(long position, int size) throws IOException {
            if (null == this.channel) {
                throw new ClosedChannelException();
            }
            if (this.buffer.capacity() < size) {
                this.buffer = ByteBuffer.allocateDirect(size);
            }
            this.buffer.rewind().limit(size);
            return ((FileChannel)this.channel).read(this.buffer, position);
        }

        private ReadableByteChannel openFile(URI uri) throws IOException {
            if (this.file != null) {
                this.file.close();
            }
            this.file = new RandomAccessFile(new File(uri), "r");
            return this.file.getChannel();
        }

        @Override
        public void closeConnection() {
            super.closeConnection();
            if (this.file != null) {
                try {
                    this.file.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.file = null;
                }
            }
        }
    }
}

