/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.control.Labeled;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LabeledText
extends Text {
    private final Labeled labeled;
    private StyleablePropertyMirror<Font> fontMirror = null;
    private static final CssMetaData<LabeledText, Font> FONT = new FontCssMetaData<LabeledText>("-fx-font", Font.getDefault()){

        @Override
        public boolean isSettable(LabeledText node) {
            return node.labeled != null ? !node.labeled.fontProperty().isBound() : true;
        }

        @Override
        public StyleableProperty<Font> getStyleableProperty(LabeledText node) {
            return node.fontMirror();
        }
    };
    private StyleablePropertyMirror<Paint> fillMirror;
    private static final CssMetaData<LabeledText, Paint> FILL = new CssMetaData<LabeledText, Paint>("-fx-fill", PaintConverter.getInstance(), (Paint)Color.BLACK){

        @Override
        public boolean isSettable(LabeledText node) {
            return !node.labeled.textFillProperty().isBound();
        }

        @Override
        public StyleableProperty<Paint> getStyleableProperty(LabeledText node) {
            return node.fillMirror();
        }
    };
    private StyleablePropertyMirror<TextAlignment> textAlignmentMirror;
    private static final CssMetaData<LabeledText, TextAlignment> TEXT_ALIGNMENT = new CssMetaData<LabeledText, TextAlignment>("-fx-text-alignment", new EnumConverter<TextAlignment>(TextAlignment.class), TextAlignment.LEFT){

        @Override
        public boolean isSettable(LabeledText node) {
            return !node.labeled.textAlignmentProperty().isBound();
        }

        @Override
        public StyleableProperty<TextAlignment> getStyleableProperty(LabeledText node) {
            return node.textAlignmentMirror();
        }
    };
    private StyleablePropertyMirror<Boolean> underlineMirror;
    private static final CssMetaData<LabeledText, Boolean> UNDERLINE = new CssMetaData<LabeledText, Boolean>("-fx-underline", BooleanConverter.getInstance(), Boolean.FALSE){

        @Override
        public boolean isSettable(LabeledText node) {
            return !node.labeled.underlineProperty().isBound();
        }

        @Override
        public StyleableProperty<Boolean> getStyleableProperty(LabeledText node) {
            return node.underlineMirror();
        }
    };
    private StyleablePropertyMirror<Number> lineSpacingMirror;
    private static final CssMetaData<LabeledText, Number> LINE_SPACING = new CssMetaData<LabeledText, Number>("-fx-line-spacing", SizeConverter.getInstance(), (Number)0){

        @Override
        public boolean isSettable(LabeledText node) {
            return !node.labeled.lineSpacingProperty().isBound();
        }

        @Override
        public StyleableProperty<Number> getStyleableProperty(LabeledText node) {
            return node.lineSpacingMirror();
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public LabeledText(Labeled labeled) {
        if (labeled == null) {
            throw new IllegalArgumentException("labeled cannot be null");
        }
        this.labeled = labeled;
        this.setFill(this.labeled.getTextFill());
        this.setFont(this.labeled.getFont());
        this.setTextAlignment(this.labeled.getTextAlignment());
        this.setUnderline(this.labeled.isUnderline());
        this.setLineSpacing(this.labeled.getLineSpacing());
        this.fillProperty().bind(this.labeled.textFillProperty());
        this.fontProperty().bind(this.labeled.fontProperty());
        this.textAlignmentProperty().bind(this.labeled.textAlignmentProperty());
        this.underlineProperty().bind(this.labeled.underlineProperty());
        this.lineSpacingProperty().bind(this.labeled.lineSpacingProperty());
        this.getStyleClass().addAll((String[])new String[]{"text"});
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return LabeledText.getClassCssMetaData();
    }

    private StyleableProperty<Font> fontMirror() {
        if (this.fontMirror == null) {
            this.fontMirror = new StyleablePropertyMirror(FONT, "fontMirror", Font.getDefault(), (StyleableProperty)((Object)this.labeled.fontProperty()));
            this.fontProperty().addListener(this.fontMirror);
        }
        return this.fontMirror;
    }

    private StyleableProperty<Paint> fillMirror() {
        if (this.fillMirror == null) {
            this.fillMirror = new StyleablePropertyMirror(FILL, "fillMirror", Color.BLACK, (StyleableProperty)((Object)this.labeled.textFillProperty()));
            this.fillProperty().addListener(this.fillMirror);
        }
        return this.fillMirror;
    }

    private StyleableProperty<TextAlignment> textAlignmentMirror() {
        if (this.textAlignmentMirror == null) {
            this.textAlignmentMirror = new StyleablePropertyMirror(TEXT_ALIGNMENT, "textAlignmentMirror", (Object)TextAlignment.LEFT, (StyleableProperty)((Object)this.labeled.textAlignmentProperty()));
            this.textAlignmentProperty().addListener(this.textAlignmentMirror);
        }
        return this.textAlignmentMirror;
    }

    private StyleableProperty<Boolean> underlineMirror() {
        if (this.underlineMirror == null) {
            this.underlineMirror = new StyleablePropertyMirror(UNDERLINE, "underLineMirror", Boolean.FALSE, (StyleableProperty)((Object)this.labeled.underlineProperty()));
            this.underlineProperty().addListener(this.underlineMirror);
        }
        return this.underlineMirror;
    }

    private StyleableProperty<Number> lineSpacingMirror() {
        if (this.lineSpacingMirror == null) {
            this.lineSpacingMirror = new StyleablePropertyMirror(LINE_SPACING, "lineSpacingMirror", 0.0, (StyleableProperty)((Object)this.labeled.lineSpacingProperty()));
            this.lineSpacingProperty().addListener(this.lineSpacingMirror);
        }
        return this.lineSpacingMirror;
    }

    static {
        ArrayList styleables = new ArrayList(Text.getClassCssMetaData());
        int nMax = styleables.size();
        for (int n = 0; n < nMax; ++n) {
            String prop = ((CssMetaData)styleables.get(n)).getProperty();
            if ("-fx-fill".equals(prop)) {
                styleables.set(n, FILL);
                continue;
            }
            if ("-fx-font".equals(prop)) {
                styleables.set(n, FONT);
                continue;
            }
            if ("-fx-text-alignment".equals(prop)) {
                styleables.set(n, TEXT_ALIGNMENT);
                continue;
            }
            if ("-fx-underline".equals(prop)) {
                styleables.set(n, UNDERLINE);
                continue;
            }
            if (!"-fx-line-spacing".equals(prop)) continue;
            styleables.set(n, LINE_SPACING);
        }
        STYLEABLES = Collections.unmodifiableList(styleables);
    }

    private class StyleablePropertyMirror<T>
    extends SimpleStyleableObjectProperty<T>
    implements InvalidationListener {
        boolean applying;
        private final StyleableProperty<T> property;

        private StyleablePropertyMirror(CssMetaData<LabeledText, T> cssMetaData, String name, T initialValue, StyleableProperty<T> property) {
            super(cssMetaData, LabeledText.this, name, initialValue);
            this.property = property;
            this.applying = false;
        }

        @Override
        public void invalidated(Observable observable) {
            if (!this.applying) {
                super.applyStyle(null, ((ObservableValue)observable).getValue());
            }
        }

        @Override
        public void applyStyle(StyleOrigin newOrigin, T value) {
            this.applying = true;
            StyleOrigin propOrigin = this.property.getStyleOrigin();
            if (propOrigin == null || (newOrigin != null ? propOrigin.compareTo(newOrigin) <= 0 : propOrigin != StyleOrigin.USER)) {
                super.applyStyle(newOrigin, value);
                this.property.applyStyle(newOrigin, value);
            }
            this.applying = false;
        }

        @Override
        public StyleOrigin getStyleOrigin() {
            return this.property.getStyleOrigin();
        }
    }
}

