/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;

public class PickRay {
    private Vec3d origin = new Vec3d();
    private Vec3d direction = new Vec3d();
    private double nearClip = 0.0;
    private double farClip = Double.POSITIVE_INFINITY;
    static final double EPS = (double)1.0E-5f;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;

    public PickRay() {
    }

    public PickRay(Vec3d origin, Vec3d direction, double nearClip, double farClip) {
        this.set(origin, direction, nearClip, farClip);
    }

    public PickRay(double x, double y, double z, double nearClip, double farClip) {
        this.set(x, y, z, nearClip, farClip);
    }

    public static PickRay computePerspectivePickRay(double x, double y, boolean fixedEye, double viewWidth, double viewHeight, double fieldOfViewRadians, boolean verticalFieldOfView, Affine3D cameraTransform, double nearClip, double farClip, PickRay pickRay) {
        if (pickRay == null) {
            pickRay = new PickRay();
        }
        Vec3d direction = pickRay.getDirectionNoClone();
        double halfViewWidth = viewWidth / 2.0;
        double halfViewHeight = viewHeight / 2.0;
        double halfViewDim = verticalFieldOfView ? halfViewHeight : halfViewWidth;
        double distanceZ = halfViewDim / Math.tan(fieldOfViewRadians / 2.0);
        direction.x = x - halfViewWidth;
        direction.y = y - halfViewHeight;
        direction.z = distanceZ;
        Vec3d eye = pickRay.getOriginNoClone();
        if (fixedEye) {
            eye.set(0.0, 0.0, 0.0);
        } else {
            eye.set(halfViewWidth, halfViewHeight, -distanceZ);
        }
        pickRay.nearClip = nearClip * (direction.length() / (fixedEye ? distanceZ : 1.0));
        pickRay.farClip = farClip * (direction.length() / (fixedEye ? distanceZ : 1.0));
        pickRay.transform(cameraTransform);
        return pickRay;
    }

    public static PickRay computeParallelPickRay(double x, double y, double viewHeight, Affine3D cameraTransform, double nearClip, double farClip, PickRay pickRay) {
        if (pickRay == null) {
            pickRay = new PickRay();
        }
        double distanceZ = viewHeight / 2.0 / Math.tan(Math.toRadians(15.0));
        pickRay.set(x, y, distanceZ, nearClip * distanceZ, farClip * distanceZ);
        if (cameraTransform != null) {
            pickRay.transform(cameraTransform);
        }
        return pickRay;
    }

    public final void set(Vec3d origin, Vec3d direction, double nearClip, double farClip) {
        this.setOrigin(origin);
        this.setDirection(direction);
        this.nearClip = nearClip;
        this.farClip = farClip;
    }

    public final void set(double x, double y, double z, double nearClip, double farClip) {
        this.setOrigin(x, y, -z);
        this.setDirection(0.0, 0.0, z);
        this.nearClip = nearClip;
        this.farClip = farClip;
    }

    public void setPickRay(PickRay other) {
        this.setOrigin(other.origin);
        this.setDirection(other.direction);
        this.nearClip = other.nearClip;
        this.farClip = other.farClip;
    }

    public PickRay copy() {
        return new PickRay(this.origin, this.direction, this.nearClip, this.farClip);
    }

    public void setOrigin(Vec3d origin) {
        this.origin.set(origin);
    }

    public void setOrigin(double x, double y, double z) {
        this.origin.set(x, y, z);
    }

    public Vec3d getOrigin(Vec3d rv) {
        if (rv == null) {
            rv = new Vec3d();
        }
        rv.set(this.origin);
        return rv;
    }

    public Vec3d getOriginNoClone() {
        return this.origin;
    }

    public void setDirection(Vec3d direction) {
        this.direction.set(direction);
    }

    public void setDirection(double x, double y, double z) {
        this.direction.set(x, y, z);
    }

    public Vec3d getDirection(Vec3d rv) {
        if (rv == null) {
            rv = new Vec3d();
        }
        rv.set(this.direction);
        return rv;
    }

    public Vec3d getDirectionNoClone() {
        return this.direction;
    }

    public double getNearClip() {
        return this.nearClip;
    }

    public double getFarClip() {
        return this.farClip;
    }

    public double distance(Vec3d iPnt) {
        double x = iPnt.x - this.origin.x;
        double y = iPnt.y - this.origin.y;
        double z = iPnt.z - this.origin.z;
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Point2D projectToZeroPlane(BaseTransform inversetx, boolean perspective, Vec3d tmpvec, Point2D ret) {
        if (tmpvec == null) {
            tmpvec = new Vec3d();
        }
        inversetx.transform(this.origin, tmpvec);
        double origX = tmpvec.x;
        double origY = tmpvec.y;
        double origZ = tmpvec.z;
        tmpvec.add(this.origin, this.direction);
        inversetx.transform(tmpvec, tmpvec);
        double dirX = tmpvec.x - origX;
        double dirY = tmpvec.y - origY;
        double dirZ = tmpvec.z - origZ;
        if (PickRay.almostZero(dirZ)) {
            return null;
        }
        double t = -origZ / dirZ;
        if (perspective && t < 0.0) {
            return null;
        }
        if (ret == null) {
            ret = new Point2D();
        }
        ret.setLocation((float)(origX + dirX * t), (float)(origY + dirY * t));
        return ret;
    }

    static boolean almostZero(double a) {
        return a < 1.0E-5 && a > -1.0E-5;
    }

    private static boolean isNonZero(double v) {
        return v > (double)1.0E-5f || v < (double)-1.0E-5f;
    }

    public void transform(BaseTransform t) {
        t.transform(this.origin, this.origin);
        t.deltaTransform(this.direction, this.direction);
    }

    public void inverseTransform(BaseTransform t) throws NoninvertibleTransformException {
        t.inverseTransform(this.origin, this.origin);
        t.inverseDeltaTransform(this.direction, this.direction);
    }

    public PickRay project(BaseTransform inversetx, boolean perspective, Vec3d tmpvec, Point2D ret) {
        if (tmpvec == null) {
            tmpvec = new Vec3d();
        }
        inversetx.transform(this.origin, tmpvec);
        double origX = tmpvec.x;
        double origY = tmpvec.y;
        double origZ = tmpvec.z;
        tmpvec.add(this.origin, this.direction);
        inversetx.transform(tmpvec, tmpvec);
        double dirX = tmpvec.x - origX;
        double dirY = tmpvec.y - origY;
        double dirZ = tmpvec.z - origZ;
        PickRay pr = new PickRay();
        pr.origin.x = origX;
        pr.origin.y = origY;
        pr.origin.z = origZ;
        pr.direction.x = dirX;
        pr.direction.y = dirY;
        pr.direction.z = dirZ;
        return pr;
    }

    public String toString() {
        return "origin: " + this.origin + "  direction: " + this.direction;
    }
}

