/*
 * Decompiled with CFR 0.152.
 */
package net.extg.cabinetmaker;

import java.util.Vector;

public class CFHeader {
    private int[] signature = new int[4];
    private int reserved1;
    private int cbCabinet;
    private int reserved2;
    private int coffFiles;
    private int reserved3;
    private int versionMinor;
    private int versionMajor;
    private int cFolders;
    private int cFiles;
    private int flags;
    private int setID;
    private int iCabinet;

    public CFHeader() {
        this.signature[0] = 77;
        this.signature[1] = 83;
        this.signature[2] = 67;
        this.signature[3] = 70;
        this.reserved1 = 0;
        this.reserved2 = 0;
        this.reserved3 = 0;
        this.versionMinor = 3;
        this.versionMajor = 1;
        this.flags = 0;
        this.setID = 0;
        this.iCabinet = 0;
    }

    public void setCbCabinet(int cbCabinet) {
        this.cbCabinet = cbCabinet;
    }

    public void setCoffFiles(int coffFiles) {
        this.coffFiles = coffFiles;
    }

    public void setCFolders(int cFolders) {
        this.cFolders = cFolders;
    }

    public void setCFiles(int cFiles) {
        this.cFiles = cFiles;
    }

    public Vector<Byte> makeByteArray() {
        Vector<Byte> b = new Vector<Byte>();
        b.addAll(this.convertToByte(this.signature[0], 1));
        b.addAll(this.convertToByte(this.signature[1], 1));
        b.addAll(this.convertToByte(this.signature[2], 1));
        b.addAll(this.convertToByte(this.signature[3], 1));
        b.addAll(this.convertToByte(this.reserved1, 4));
        b.addAll(this.convertToByte(this.cbCabinet, 4));
        b.addAll(this.convertToByte(this.reserved2, 4));
        b.addAll(this.convertToByte(this.coffFiles, 4));
        b.addAll(this.convertToByte(this.reserved3, 4));
        b.addAll(this.convertToByte(this.versionMinor, 1));
        b.addAll(this.convertToByte(this.versionMajor, 1));
        b.addAll(this.convertToByte(this.cFolders, 2));
        b.addAll(this.convertToByte(this.cFiles, 2));
        b.addAll(this.convertToByte(this.flags, 2));
        b.addAll(this.convertToByte(this.setID, 2));
        b.addAll(this.convertToByte(this.iCabinet, 2));
        return b;
    }

    private Vector<Byte> convertToByte(int val, int numBytes) {
        Vector<Byte> b = new Vector<Byte>();
        if (numBytes == 1) {
            Integer tempInt = new Integer(val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 2) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 3) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF0000 & val) >>> 16);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 4) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF0000 & val) >>> 16);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF000000 & val) >>> 24);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else {
            b.add(new Byte("255"));
        }
        return b;
    }
}

