/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Sha1;
import com.backblaze.b2.util.B2StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public class B2Sha1InputStream
extends InputStream {
    private final InputStream in;
    private final MessageDigest digest;

    public B2Sha1InputStream(InputStream in) {
        this.in = in;
        this.digest = B2Sha1.createSha1MessageDigest();
    }

    public byte[] digest() {
        return this.digest.digest();
    }

    public String hexDigest() {
        return B2StringUtil.toHexString(this.digest());
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c != -1) {
            this.digest.update((byte)c);
        }
        return c;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int byteCount = this.in.read(buffer, offset, length);
        if (byteCount != -1) {
            this.digest.update(buffer, offset, byteCount);
        }
        return byteCount;
    }

    @Override
    public long skip(long bytesToSkip) throws IOException {
        int bytesToRead;
        long bytesSkipped;
        int bytesRead;
        byte[] buffer = new byte[4096];
        for (bytesSkipped = 0L; bytesSkipped < bytesToSkip && (bytesRead = this.read(buffer, 0, bytesToRead = (int)Math.min(bytesToSkip - bytesSkipped, (long)buffer.length))) >= 0; bytesSkipped += (long)bytesRead) {
        }
        return bytesSkipped;
    }
}

