/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Sha1InputStream;
import com.backblaze.b2.util.B2StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class B2Sha1AppenderInputStream {
    public static InputStream create(InputStream original) {
        B2Sha1InputStream wrappedOriginal = new B2Sha1InputStream(original);
        return new SequenceInputStream(wrappedOriginal, new LazySha1Stream(wrappedOriginal));
    }

    private static class LazySha1Stream
    extends InputStream {
        private final B2Sha1InputStream original;
        private InputStream sha1Stream;

        private LazySha1Stream(B2Sha1InputStream original) {
            this.original = original;
        }

        @Override
        public int read() throws IOException {
            return this.getSha1Stream().read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getSha1Stream().read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.getSha1Stream().available();
        }

        @Override
        public void close() throws IOException {
            this.getSha1Stream().close();
        }

        private InputStream getSha1Stream() {
            if (this.sha1Stream == null) {
                byte[] sha1 = B2StringUtil.getUtf8Bytes(this.original.hexDigest());
                this.sha1Stream = new ByteArrayInputStream(sha1);
            }
            return this.sha1Stream;
        }
    }
}

