/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Preconditions;
import com.backblaze.b2.util.B2StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public interface B2Sha1 {
    public static final int SHA1_SIZE = 20;
    public static final int HEX_SHA1_SIZE = 40;

    public static MessageDigest createSha1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No SHA-1 installed!", e);
        }
    }

    public static byte[] binarySha1OfBytes(byte[] data) {
        MessageDigest digest = B2Sha1.createSha1MessageDigest();
        digest.update(data);
        return digest.digest();
    }

    public static String hexSha1OfBytes(byte[] data) {
        return B2StringUtil.toHexString(B2Sha1.binarySha1OfBytes(data));
    }

    public static String hexSha1OfInputStream(InputStream in) throws IOException {
        return B2StringUtil.toHexString(B2Sha1.binarySha1OfInputStream(in));
    }

    public static byte[] binarySha1OfInputStream(InputStream in) throws IOException {
        int bytesRead;
        MessageDigest digest = B2Sha1.createSha1MessageDigest();
        byte[] bytesBuffer = new byte[1024];
        while ((bytesRead = in.read(bytesBuffer)) != -1) {
            digest.update(bytesBuffer, 0, bytesRead);
        }
        return digest.digest();
    }

    public static boolean equalHexSha1s(String sha1a, String sha1b) {
        B2Preconditions.checkArgument(sha1a != null);
        B2Preconditions.checkArgument(sha1b != null);
        String lowerA = sha1a.toLowerCase();
        String lowerB = sha1b.toLowerCase();
        return lowerA.equals(lowerB);
    }
}

