/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2ClockImpl;
import com.backblaze.b2.util.B2ClockSim;
import com.backblaze.b2.util.B2Preconditions;
import java.time.LocalDateTime;

public abstract class B2Clock {
    private static B2Clock theClock;

    public static B2ClockSim useSimulator(LocalDateTime desiredNow) {
        if (theClock == null) {
            theClock = new B2ClockSim(desiredNow);
        }
        B2Preconditions.checkState(theClock instanceof B2ClockSim, "theClock must be a B2ClockSim, but it's a " + theClock.getClass().getSimpleName());
        B2ClockSim sim = (B2ClockSim)theClock;
        sim.resetBoth(desiredNow);
        return sim;
    }

    public static synchronized B2Clock get() {
        if (theClock == null) {
            theClock = new B2ClockImpl();
        }
        return theClock;
    }

    public abstract long monotonicMillis();

    public abstract long wallClockMillis();
}

