/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonInitializedTypeHandler;

public abstract class B2JsonTypeHandlerWithDefaults<T>
extends B2JsonInitializedTypeHandler<T> {
    private DefaultValueState defaultValueState = DefaultValueState.NOT_CHECKED;
    private String errorMessage;

    protected synchronized void throwIfBadDefaultValue() throws B2JsonException {
        if (this.defaultValueState == DefaultValueState.BAD) {
            throw new B2JsonException(this.errorMessage);
        }
    }

    synchronized void checkDefaultValuesAndRememberResult() {
        try {
            this.checkDefaultValues();
            this.defaultValueState = DefaultValueState.GOOD;
        }
        catch (B2JsonException e) {
            this.setDefaultValueBad(e.getMessage());
        }
    }

    synchronized void setDefaultValueBad(String errorMessage) {
        this.defaultValueState = DefaultValueState.BAD;
        this.errorMessage = errorMessage;
    }

    protected abstract void checkDefaultValues() throws B2JsonException;

    private static enum DefaultValueState {
        NOT_CHECKED,
        GOOD,
        BAD;

    }
}

