/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import java.io.IOException;
import java.io.Reader;

public class B2JsonReader {
    private final Reader in;
    private int currentChar;
    private static final int EOF = -1;
    private final StringBuilder builder = new StringBuilder();

    public B2JsonReader(Reader in) throws IOException {
        this.in = in;
        this.currentChar = in.read();
    }

    public char peekNextNotWhitespaceChar() throws IOException, B2JsonException {
        this.skipWhitespace();
        if (this.currentChar == -1) {
            throw new B2JsonException("unexpected EOF");
        }
        return (char)this.currentChar;
    }

    public void skipValue() throws IOException, B2JsonException {
        this.skipWhitespace();
        if (this.currentChar == -1) {
            throw new B2JsonException("expected value but found EOF");
        }
        if (this.currentChar == 34) {
            this.readString();
        } else if (this.currentChar == 45 || this.isDigit(this.currentChar)) {
            this.readNumberAsString();
        } else if (this.currentChar == 110) {
            this.readNull();
        } else if (this.currentChar == 116) {
            this.readTrue();
        } else if (this.currentChar == 102) {
            this.readFalse();
        } else if (this.currentChar == 123) {
            if (this.startObjectAndCheckForContents()) {
                do {
                    this.readObjectFieldNameAndColon();
                    this.skipValue();
                } while (this.objectHasMoreFields());
            }
            this.finishObject();
        } else if (this.currentChar == 91) {
            if (this.startArrayAndCheckForContents()) {
                do {
                    this.skipValue();
                } while (this.arrayHasMoreValues());
            }
            this.finishArray();
        } else {
            throw new B2JsonException("Expected value but found char: " + (char)this.currentChar);
        }
    }

    public String readNumberAsString() throws IOException, B2JsonException {
        this.skipWhitespace();
        this.builder.setLength(0);
        if (this.currentChar == 45) {
            this.appendAndNext();
        }
        if (!this.isDigit(this.currentChar)) {
            throw new B2JsonException("Bad number");
        }
        if (this.currentChar == 48) {
            this.appendAndNext();
            if (this.isDigit(this.currentChar)) {
                throw new B2JsonException("Number cannot start with 0 and then have another digit");
            }
        } else {
            while (this.isDigit(this.currentChar)) {
                this.appendAndNext();
            }
        }
        if (this.currentChar == 46) {
            this.appendAndNext();
            while (this.isDigit(this.currentChar)) {
                this.appendAndNext();
            }
        }
        if (this.currentChar == 101 || this.currentChar == 69) {
            this.appendAndNext();
            if (this.currentChar == 43 || this.currentChar == 45) {
                this.appendAndNext();
            }
            if (!this.isDigit(this.currentChar)) {
                throw new B2JsonException("Bad number");
            }
            while (this.isDigit(this.currentChar)) {
                this.appendAndNext();
            }
        }
        return this.builder.toString();
    }

    public String readString() throws B2JsonException, IOException {
        this.skipWhitespace();
        if (this.currentChar != 34) {
            throw new B2JsonException("string does not start with quote");
        }
        this.next();
        this.builder.setLength(0);
        while (this.currentChar != 34) {
            if (this.currentChar == -1) {
                throw new B2JsonException("eof inside string");
            }
            if (this.currentChar < 32) {
                throw new B2JsonException("control character in string");
            }
            if (this.currentChar == 92) {
                this.handleBackslashInString();
                continue;
            }
            this.appendAndNext();
        }
        this.next();
        return this.builder.toString();
    }

    private void handleBackslashInString() throws IOException, B2JsonException {
        this.next();
        int charAfterBackslash = this.currentChar;
        this.next();
        switch (charAfterBackslash) {
            case 34: 
            case 47: 
            case 92: {
                this.builder.append((char)charAfterBackslash);
                break;
            }
            case 98: {
                this.builder.append('\b');
                break;
            }
            case 102: {
                this.builder.append('\f');
                break;
            }
            case 110: {
                this.builder.append('\n');
                break;
            }
            case 114: {
                this.builder.append('\r');
                break;
            }
            case 116: {
                this.builder.append('\t');
                break;
            }
            case 117: {
                this.handleFourDigitHexUnicode();
                break;
            }
            default: {
                throw new B2JsonException("bad char after backslash");
            }
        }
    }

    private void handleFourDigitHexUnicode() throws IOException, B2JsonException {
        int d;
        int c;
        int b;
        int a = this.readHexDigit();
        int value = (a << 12) + ((b = this.readHexDigit()) << 8) + ((c = this.readHexDigit()) << 4) + (d = this.readHexDigit());
        if (value < 55296 || 57343 < value) {
            this.builder.append((char)value);
        } else {
            if (56320 <= value) {
                throw new B2JsonException("second element of surrogate pair came first");
            }
            if (this.currentChar != 92) {
                throw new B2JsonException("first of surrogate pair must be followed by \\u");
            }
            this.next();
            if (this.currentChar != 117) {
                throw new B2JsonException("first of surrogate pair must be followed by \\u");
            }
            this.next();
            int e = this.readHexDigit();
            int f = this.readHexDigit();
            int g = this.readHexDigit();
            int h = this.readHexDigit();
            int value2 = (e << 12) + (f << 8) + (g << 4) + h;
            if (value2 < 56320 || 57343 < value2) {
                throw new B2JsonException("first of surrogate pair not followed by second");
            }
            this.builder.appendCodePoint(Character.toCodePoint((char)value, (char)value2));
        }
    }

    public boolean startObjectAndCheckForContents() throws B2JsonException, IOException {
        if (!this.nextNonWhitespaceIs('{')) {
            throw new B2JsonException("object should start with brace but found: " + (char)this.currentChar);
        }
        this.next();
        return !this.nextNonWhitespaceIs('}');
    }

    public boolean objectHasMoreFields() throws IOException, B2JsonException {
        if (this.nextNonWhitespaceIs(',')) {
            this.next();
            return true;
        }
        return false;
    }

    private boolean nextNonWhitespaceIs(char c) throws IOException, B2JsonException {
        this.skipWhitespace();
        return this.currentChar == c;
    }

    public boolean nextNonWhitespaceIsEof() throws IOException, B2JsonException {
        this.skipWhitespace();
        return this.currentChar == -1;
    }

    public String readObjectFieldNameAndColon() throws B2JsonException, IOException {
        String result = this.readString();
        this.skipObjectColon();
        return result;
    }

    public void skipObjectColon() throws IOException, B2JsonException {
        this.skipWhitespace();
        if (this.currentChar != 58) {
            throw new B2JsonException("no ':' after field name in object");
        }
        this.next();
    }

    public void finishObject() throws B2JsonException, IOException {
        this.skipWhitespace();
        if (this.currentChar != 125) {
            throw new B2JsonException("object should end with brace but found: " + (char)this.currentChar);
        }
        this.next();
    }

    public boolean startArrayAndCheckForContents() throws IOException, B2JsonException {
        if (!this.nextNonWhitespaceIs('[')) {
            throw new B2JsonException("array should start with bracket but found: " + (char)this.currentChar);
        }
        this.next();
        return !this.nextNonWhitespaceIs(']');
    }

    public boolean arrayHasMoreValues() throws IOException, B2JsonException {
        if (this.nextNonWhitespaceIs(',')) {
            this.next();
            return true;
        }
        return false;
    }

    public void finishArray() throws B2JsonException, IOException {
        this.skipWhitespace();
        if (this.currentChar != 93) {
            throw new B2JsonException("array should end with bracket but found: " + (char)this.currentChar);
        }
        this.next();
    }

    public void readNull() throws IOException, B2JsonException {
        if (this.currentChar != 110) {
            throw new B2JsonException("expected 'null'");
        }
        this.next();
        if (this.currentChar != 117) {
            throw new B2JsonException("expected 'null'");
        }
        this.next();
        if (this.currentChar != 108) {
            throw new B2JsonException("expected 'null'");
        }
        this.next();
        if (this.currentChar != 108) {
            throw new B2JsonException("expected 'null'");
        }
        this.next();
    }

    public void readFalse() throws IOException, B2JsonException {
        if (this.currentChar != 102) {
            throw new B2JsonException("expected 'false'");
        }
        this.next();
        if (this.currentChar != 97) {
            throw new B2JsonException("expected 'false'");
        }
        this.next();
        if (this.currentChar != 108) {
            throw new B2JsonException("expected 'false'");
        }
        this.next();
        if (this.currentChar != 115) {
            throw new B2JsonException("expected 'false'");
        }
        this.next();
        if (this.currentChar != 101) {
            throw new B2JsonException("expected 'false'");
        }
        this.next();
    }

    public void readTrue() throws IOException, B2JsonException {
        if (this.currentChar != 116) {
            throw new B2JsonException("expected 'true'");
        }
        this.next();
        if (this.currentChar != 114) {
            throw new B2JsonException("expected 'true'");
        }
        this.next();
        if (this.currentChar != 117) {
            throw new B2JsonException("expected 'true'");
        }
        this.next();
        if (this.currentChar != 101) {
            throw new B2JsonException("expected 'true'");
        }
        this.next();
    }

    private int readHexDigit() throws IOException, B2JsonException {
        int c = this.currentChar;
        if (48 <= c && c <= 57) {
            this.next();
            return c - 48;
        }
        if (97 <= c && c <= 102) {
            this.next();
            return 10 + c - 97;
        }
        if (65 <= c && c <= 70) {
            this.next();
            return 10 + c - 65;
        }
        throw new B2JsonException("bad hex digit: " + (char)c);
    }

    /*
     * Unable to fully structure code
     */
    private void skipWhitespace() throws IOException, B2JsonException {
        block3: {
            block0: while (true) {
                if (this.currentChar == 9 || this.currentChar == 10 || this.currentChar == 13 || this.currentChar == 32) {
                    this.next();
                    continue;
                }
                if (this.currentChar != 47) break block3;
                this.next();
                if (this.currentChar != 47) break;
                this.next();
                while (true) {
                    if (this.currentChar != 10 && this.currentChar != -1) ** break;
                    continue block0;
                    this.next();
                }
                break;
            }
            throw new B2JsonException("invalid comment: single slash");
        }
    }

    private void appendAndNext() throws IOException {
        if (this.currentChar == -1) {
            throw new IllegalStateException();
        }
        this.builder.append((char)this.currentChar);
        this.currentChar = this.in.read();
    }

    private void next() throws IOException {
        this.currentChar = this.in.read();
    }

    private boolean isDigit(int c) {
        return 48 <= c && c <= 57;
    }
}

