/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class B2JsonIntegerHandler
implements B2JsonTypeHandler<Integer> {
    private final boolean isPrimitive;

    public B2JsonIntegerHandler(boolean isPrimitive) {
        this.isPrimitive = isPrimitive;
    }

    @Override
    public Type getHandledType() {
        return Integer.class;
    }

    @Override
    public void serialize(Integer obj, B2JsonOptions options, B2JsonWriter out) throws IOException {
        out.writeText(obj.toString());
    }

    @Override
    public Integer deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        String str = in.readNumberAsString();
        return this.deserializeUrlParam(str);
    }

    @Override
    public Integer deserializeUrlParam(String value) throws B2JsonException {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new B2JsonException("bad integer: " + value);
        }
    }

    @Override
    public Integer defaultValueForOptional() {
        if (this.isPrimitive) {
            return 0;
        }
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

