/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonBadValueException;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class B2JsonFloatArrayHandler
extends B2JsonNonUrlTypeHandler<float[]> {
    private final B2JsonTypeHandler itemHandler;

    public B2JsonFloatArrayHandler(B2JsonTypeHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public Type getHandledType() {
        return float[].class;
    }

    @Override
    public void serialize(float[] array, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.setAllowNewlines(false);
        out.startArray();
        float[] fArray = array;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float item = Float.valueOf(fArray[i]);
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, item, out, options);
        }
        out.finishArray();
        out.setAllowNewlines(true);
    }

    @Override
    public float[] deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList<Float> result = new ArrayList<Float>();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add((Float)B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        int nElts = result.size();
        float[] array = new float[nElts];
        int i = 0;
        for (Float elt : result) {
            if (elt == null) {
                throw new B2JsonBadValueException("can't put null in a float[].");
            }
            array[i] = elt.floatValue();
            ++i;
        }
        return array;
    }

    @Override
    public float[] defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

