/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.json.B2JsonBadValueException;
import com.backblaze.b2.json.B2JsonException;
import com.backblaze.b2.json.B2JsonNonUrlTypeHandler;
import com.backblaze.b2.json.B2JsonOptions;
import com.backblaze.b2.json.B2JsonReader;
import com.backblaze.b2.json.B2JsonTypeHandler;
import com.backblaze.b2.json.B2JsonUtil;
import com.backblaze.b2.json.B2JsonWriter;
import java.io.IOException;
import java.util.ArrayList;

public class B2JsonBooleanArrayHandler
extends B2JsonNonUrlTypeHandler<boolean[]> {
    private final B2JsonTypeHandler<Boolean> itemHandler;

    public B2JsonBooleanArrayHandler(B2JsonTypeHandler itemHandler) {
        this.itemHandler = itemHandler;
    }

    @Override
    public Class<boolean[]> getHandledType() {
        return boolean[].class;
    }

    @Override
    public void serialize(boolean[] array, B2JsonOptions options, B2JsonWriter out) throws IOException, B2JsonException {
        out.setAllowNewlines(false);
        out.startArray();
        boolean[] blArray = array;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean item = blArray[i];
            out.startArrayValue();
            B2JsonUtil.serializeMaybeNull(this.itemHandler, item, out, options);
        }
        out.finishArray();
        out.setAllowNewlines(true);
    }

    @Override
    public boolean[] deserialize(B2JsonReader in, B2JsonOptions options) throws B2JsonException, IOException {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        if (in.startArrayAndCheckForContents()) {
            do {
                result.add(B2JsonUtil.deserializeMaybeNull(this.itemHandler, in, options));
            } while (in.arrayHasMoreValues());
        }
        in.finishArray();
        int nElts = result.size();
        boolean[] array = new boolean[nElts];
        int i = 0;
        for (Boolean elt : result) {
            if (elt == null) {
                throw new B2JsonBadValueException("can't put null in a boolean[].");
            }
            array[i] = elt;
            ++i;
        }
        return array;
    }

    @Override
    public boolean[] defaultValueForOptional() {
        return null;
    }

    @Override
    public boolean isStringInJson() {
        return false;
    }
}

