/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import java.util.Objects;

public class B2UploadPartRequest {
    private final int partNumber;
    private final B2ContentSource contentSource;

    private B2UploadPartRequest(int partNumber, B2ContentSource contentSource) {
        this.partNumber = partNumber;
        this.contentSource = contentSource;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public B2ContentSource getContentSource() {
        return this.contentSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2UploadPartRequest that = (B2UploadPartRequest)o;
        return this.getPartNumber() == that.getPartNumber() && Objects.equals(this.getContentSource(), that.getContentSource());
    }

    public int hashCode() {
        return Objects.hash(this.getPartNumber(), this.getContentSource());
    }

    public static Builder builder(int partNumber, B2ContentSource source) {
        return new Builder(partNumber, source);
    }

    public static class Builder {
        private final int partNumber;
        private final B2ContentSource source;

        Builder(int partNumber, B2ContentSource source) {
            this.partNumber = partNumber;
            this.source = source;
        }

        public B2UploadPartRequest build() {
            return new B2UploadPartRequest(this.partNumber, this.source);
        }
    }
}

