/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.json.B2Json;
import com.backblaze.b2.util.B2Collections;
import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class B2StartLargeFileRequest {
    @B2Json.required
    private final String bucketId;
    @B2Json.required
    private final String fileName;
    @B2Json.required
    private final String contentType;
    @B2Json.optional
    private final Map<String, String> fileInfo;

    @B2Json.constructor(params="bucketId,fileName,contentType,fileInfo")
    private B2StartLargeFileRequest(String bucketId, String fileName, String contentType, Map<String, String> fileInfo) {
        this.bucketId = bucketId;
        this.fileName = fileName;
        this.contentType = contentType;
        this.fileInfo = B2Collections.unmodifiableMap(fileInfo);
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2StartLargeFileRequest that = (B2StartLargeFileRequest)o;
        return Objects.equals(this.getBucketId(), that.getBucketId()) && Objects.equals(this.getFileName(), that.getFileName()) && Objects.equals(this.getContentType(), that.getContentType()) && Objects.equals(this.getFileInfo(), that.getFileInfo());
    }

    public int hashCode() {
        return Objects.hash(this.getBucketId(), this.getFileName(), this.getContentType(), this.getFileInfo());
    }

    public static B2StartLargeFileRequest buildFrom(B2UploadFileRequest orig) throws B2Exception {
        try {
            Builder builder = new Builder(orig.getBucketId(), orig.getFileName(), orig.getContentType());
            builder.setCustomFields(orig.getFileInfo());
            String largeFileSha1 = orig.getContentSource().getSha1OrNull();
            if (largeFileSha1 != null) {
                String origLargeFileSha1 = orig.getFileInfo().get("large_file_sha1");
                B2Preconditions.checkArgument(origLargeFileSha1 == null || Objects.equals(largeFileSha1, origLargeFileSha1), "already have largeFileSha1 and it doesn't match?");
                builder.setCustomField("large_file_sha1", largeFileSha1);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new B2LocalException("local", "failed to get large file's sha1 from contentSource: " + e.getMessage(), e);
        }
    }

    public static Builder builder(String bucketId, String fileName, String contentType) {
        return new Builder(bucketId, fileName, contentType);
    }

    public static class Builder {
        private String bucketId;
        private String fileName;
        private String contentType;
        private Map<String, String> fileInfo;

        Builder(String bucketId, String fileName, String contentType) {
            this.bucketId = bucketId;
            this.fileName = fileName;
            this.contentType = contentType;
            this.fileInfo = new TreeMap<String, String>();
        }

        public Builder setSrcLastModifiedMillisOrNull(long lastModifiedMillis) {
            this.setCustomField("src_last_modified_millis", Long.toString(lastModifiedMillis));
            return this;
        }

        public Builder setCustomField(String name, String value) {
            B2Preconditions.checkArgumentIsNotNull(value, "value");
            this.fileInfo.put(name, value);
            return this;
        }

        public Builder setLargeFileSha1(String largeFileSha1) {
            return this.setCustomField("large_file_sha1", largeFileSha1);
        }

        public Builder setCustomFields(Map<String, String> newFileInfo) {
            B2Preconditions.checkArgumentIsNotNull(newFileInfo, "newFileInfo");
            newFileInfo.forEach(this::setCustomField);
            return this;
        }

        public B2StartLargeFileRequest build() {
            return new B2StartLargeFileRequest(this.bucketId, this.fileName, this.contentType, this.fileInfo);
        }
    }
}

