/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2HideFileRequest {
    @B2Json.required
    private final String bucketId;
    @B2Json.required
    private final String fileName;

    @B2Json.constructor(params="bucketId,fileName")
    private B2HideFileRequest(String bucketId, String fileName) {
        this.bucketId = bucketId;
        this.fileName = fileName;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2HideFileRequest that = (B2HideFileRequest)o;
        return Objects.equals(this.getBucketId(), that.getBucketId()) && Objects.equals(this.getFileName(), that.getFileName());
    }

    public int hashCode() {
        return Objects.hash(this.getBucketId(), this.getFileName());
    }

    public static Builder builder(String bucketId, String fileName) {
        return new Builder(bucketId, fileName);
    }

    public static class Builder {
        private final String bucketId;
        private final String fileName;

        public Builder(String bucketId, String fileName) {
            this.bucketId = bucketId;
            this.fileName = fileName;
        }

        public B2HideFileRequest build() {
            return new B2HideFileRequest(this.bucketId, this.fileName);
        }
    }
}

