/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.util.B2Preconditions;
import java.util.Objects;

public class B2GetFileInfoByNameRequest {
    private final String bucketName;
    private final String fileName;

    public B2GetFileInfoByNameRequest(String bucketName, String fileName) {
        B2Preconditions.checkArgument(bucketName != null);
        B2Preconditions.checkArgument(fileName != null);
        this.bucketName = bucketName;
        this.fileName = fileName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2GetFileInfoByNameRequest that = (B2GetFileInfoByNameRequest)o;
        return Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.fileName, that.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.fileName);
    }

    public static Builder builder(String bucketName, String fileName) {
        return new Builder(bucketName, fileName);
    }

    public static class Builder {
        private final String bucketName;
        private final String fileName;

        private Builder(String bucketName, String fileName) {
            this.bucketName = bucketName;
            this.fileName = fileName;
        }

        public B2GetFileInfoByNameRequest build() {
            return new B2GetFileInfoByNameRequest(this.bucketName, this.fileName);
        }
    }
}

