/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2DeleteFileVersionRequest {
    @B2Json.required
    private final String fileName;
    @B2Json.required
    private final String fileId;

    @B2Json.constructor(params="fileName,fileId")
    public B2DeleteFileVersionRequest(String fileName, String fileId) {
        this.fileName = fileName;
        this.fileId = fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileId() {
        return this.fileId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2DeleteFileVersionRequest that = (B2DeleteFileVersionRequest)o;
        return Objects.equals(this.getFileName(), that.getFileName()) && Objects.equals(this.getFileId(), that.getFileId());
    }

    public int hashCode() {
        return Objects.hash(this.getFileName(), this.getFileId());
    }

    public static Builder builder(String fileName, String fileId) {
        return new Builder(fileName, fileId);
    }

    public static class Builder {
        private final String fileName;
        private final String fileId;

        public Builder(String fileName, String fileId) {
            this.fileName = fileName;
            this.fileId = fileId;
        }

        public B2DeleteFileVersionRequest build() {
            return new B2DeleteFileVersionRequest(this.fileName, this.fileId);
        }
    }
}

