/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.contentSources;

import com.backblaze.b2.client.contentSources.B2Headers;
import com.backblaze.b2.util.B2Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class B2HeadersImpl
implements B2Headers {
    private Map<String, String> pairs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    private B2HeadersImpl(Map<String, String> pairs) {
        this.pairs.putAll(pairs);
        B2Preconditions.checkArgument(this.pairs.size() == pairs.size(), "argument contained keys that only differed by case!");
    }

    @Override
    public Collection<String> getNames() {
        return Collections.unmodifiableCollection(this.pairs.keySet());
    }

    @Override
    public String getValueOrNull(String name) {
        return this.pairs.get(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(B2Headers headersOrNull) {
        Builder builder = new Builder();
        if (headersOrNull != null) {
            for (String name : headersOrNull.getNames()) {
                builder.set(name, headersOrNull.getValueOrNull(name));
            }
        }
        return builder;
    }

    public String toString() {
        return "B2HeadersImpl{pairs=" + this.pairs + '}';
    }

    public static class Builder {
        private final Map<String, String> pairs = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

        public Builder set(String name, String value) {
            B2Preconditions.checkArgument(!this.pairs.containsKey(name), "already have a value for " + name);
            this.pairs.put(name, value);
            return this;
        }

        public B2HeadersImpl build() {
            return new B2HeadersImpl(this.pairs);
        }
    }
}

