/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2PartSpec;
import com.backblaze.b2.client.structures.B2UploadProgress;
import com.backblaze.b2.client.structures.B2UploadState;

interface B2UploadProgressUtil {
    public static B2UploadProgress forPart(B2PartSpec partSpec, int numParts, long bytesSoFar, B2UploadState uploadState) {
        return new B2UploadProgress(partSpec.getPartNumber() - 1, numParts, partSpec.getStart(), partSpec.getLength(), bytesSoFar, uploadState);
    }

    public static B2UploadProgress forPartSucceeded(B2PartSpec partSpec, int numParts) {
        return B2UploadProgressUtil.forPart(partSpec, numParts, partSpec.getLength(), B2UploadState.SUCCEEDED);
    }

    public static B2UploadProgress forPartFailed(B2PartSpec partSpec, int numParts, long bytesSoFar) {
        return B2UploadProgressUtil.forPart(partSpec, numParts, bytesSoFar, B2UploadState.FAILED);
    }

    public static B2UploadProgress forSmallFile(long contentLength, long bytesSoFar, B2UploadState state) {
        return new B2UploadProgress(0, 1, 0L, contentLength, bytesSoFar, state);
    }

    public static B2UploadProgress forSmallFileWaitingToStart(long contentLen) {
        return B2UploadProgressUtil.forSmallFile(contentLen, 0L, B2UploadState.WAITING_TO_START);
    }

    public static B2UploadProgress forSmallFileStarting(long contentLen) {
        return B2UploadProgressUtil.forSmallFile(contentLen, 0L, B2UploadState.STARTING);
    }

    public static B2UploadProgress forSmallFileSucceeded(long contentLen) {
        return B2UploadProgressUtil.forSmallFile(contentLen, contentLen, B2UploadState.SUCCEEDED);
    }

    public static B2UploadProgress forSmallFileFailed(long contentLength, long bytesSoFar) {
        return B2UploadProgressUtil.forSmallFile(contentLength, bytesSoFar, B2UploadState.FAILED);
    }
}

