/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizationCache;
import com.backblaze.b2.client.B2ClientConfig;
import com.backblaze.b2.client.B2FilePolicy;
import com.backblaze.b2.client.B2LargeFileStorer;
import com.backblaze.b2.client.B2LargeFileUploader;
import com.backblaze.b2.client.B2ListFileNamesIterable;
import com.backblaze.b2.client.B2ListFileVersionsIterable;
import com.backblaze.b2.client.B2ListFilesIterable;
import com.backblaze.b2.client.B2ListKeysIterable;
import com.backblaze.b2.client.B2ListPartsIterable;
import com.backblaze.b2.client.B2ListPartsIterableImpl;
import com.backblaze.b2.client.B2ListUnfinishedLargeFilesIterable;
import com.backblaze.b2.client.B2PartSizes;
import com.backblaze.b2.client.B2PartStorer;
import com.backblaze.b2.client.B2RetryPolicy;
import com.backblaze.b2.client.B2Retryer;
import com.backblaze.b2.client.B2Sleeper;
import com.backblaze.b2.client.B2StorageClient;
import com.backblaze.b2.client.B2StorageClientWebifier;
import com.backblaze.b2.client.B2UploadUrlCache;
import com.backblaze.b2.client.contentHandlers.B2ContentSink;
import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2LocalException;
import com.backblaze.b2.client.structures.B2AccountAuthorization;
import com.backblaze.b2.client.structures.B2ApplicationKey;
import com.backblaze.b2.client.structures.B2Bucket;
import com.backblaze.b2.client.structures.B2CancelLargeFileRequest;
import com.backblaze.b2.client.structures.B2CopyFileRequest;
import com.backblaze.b2.client.structures.B2CreateBucketRequest;
import com.backblaze.b2.client.structures.B2CreateBucketRequestReal;
import com.backblaze.b2.client.structures.B2CreateKeyRequest;
import com.backblaze.b2.client.structures.B2CreateKeyRequestReal;
import com.backblaze.b2.client.structures.B2CreatedApplicationKey;
import com.backblaze.b2.client.structures.B2DeleteBucketRequest;
import com.backblaze.b2.client.structures.B2DeleteBucketRequestReal;
import com.backblaze.b2.client.structures.B2DeleteFileVersionRequest;
import com.backblaze.b2.client.structures.B2DeleteKeyRequest;
import com.backblaze.b2.client.structures.B2DownloadAuthorization;
import com.backblaze.b2.client.structures.B2DownloadByIdRequest;
import com.backblaze.b2.client.structures.B2DownloadByNameRequest;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2FinishLargeFileRequest;
import com.backblaze.b2.client.structures.B2GetDownloadAuthorizationRequest;
import com.backblaze.b2.client.structures.B2GetFileInfoByNameRequest;
import com.backblaze.b2.client.structures.B2GetFileInfoRequest;
import com.backblaze.b2.client.structures.B2GetUploadPartUrlRequest;
import com.backblaze.b2.client.structures.B2GetUploadUrlRequest;
import com.backblaze.b2.client.structures.B2HideFileRequest;
import com.backblaze.b2.client.structures.B2ListBucketsRequest;
import com.backblaze.b2.client.structures.B2ListBucketsResponse;
import com.backblaze.b2.client.structures.B2ListFileNamesRequest;
import com.backblaze.b2.client.structures.B2ListFileNamesResponse;
import com.backblaze.b2.client.structures.B2ListFileVersionsRequest;
import com.backblaze.b2.client.structures.B2ListFileVersionsResponse;
import com.backblaze.b2.client.structures.B2ListKeysRequest;
import com.backblaze.b2.client.structures.B2ListKeysRequestReal;
import com.backblaze.b2.client.structures.B2ListKeysResponse;
import com.backblaze.b2.client.structures.B2ListPartsRequest;
import com.backblaze.b2.client.structures.B2ListPartsResponse;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesRequest;
import com.backblaze.b2.client.structures.B2ListUnfinishedLargeFilesResponse;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2StartLargeFileRequest;
import com.backblaze.b2.client.structures.B2UpdateBucketRequest;
import com.backblaze.b2.client.structures.B2UploadFileRequest;
import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.client.structures.B2UploadPartUrlResponse;
import com.backblaze.b2.client.structures.B2UploadUrlResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public class B2StorageClientImpl
implements B2StorageClient {
    private final B2StorageClientWebifier webifier;
    private final Supplier<B2RetryPolicy> retryPolicySupplier;
    private final B2Retryer retryer;
    private final B2AccountAuthorizationCache accountAuthCache;
    private final B2UploadUrlCache uploadUrlCache;
    private boolean closed;

    public B2StorageClientImpl(B2StorageClientWebifier webifier, B2ClientConfig config, Supplier<B2RetryPolicy> retryPolicySupplier) {
        this(webifier, config, retryPolicySupplier, new B2Retryer(new B2Sleeper()));
    }

    B2StorageClientImpl(B2StorageClientWebifier webifier, B2ClientConfig config, Supplier<B2RetryPolicy> retryPolicySupplier, B2Retryer retryer) {
        this.webifier = webifier;
        this.retryPolicySupplier = retryPolicySupplier;
        this.retryer = retryer;
        this.accountAuthCache = new B2AccountAuthorizationCache(webifier, config.getAccountAuthorizer());
        this.uploadUrlCache = new B2UploadUrlCache(webifier, this.accountAuthCache);
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.webifier.close();
        }
    }

    @Override
    public String getAccountId() throws B2Exception {
        return this.retryer.doRetry("getAccountId", this.accountAuthCache, this.accountAuthCache::getAccountId, this.retryPolicySupplier.get());
    }

    private String getAccountIdWithoutRetry() throws B2Exception {
        return this.accountAuthCache.getAccountId();
    }

    @Override
    public B2FilePolicy getFilePolicy() throws B2Exception {
        return this.getPartSizes();
    }

    @Override
    public B2StorageClientWebifier getWebifier() {
        return this.webifier;
    }

    @Override
    public B2Bucket createBucket(B2CreateBucketRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_create_bucket", this.accountAuthCache, () -> {
            B2CreateBucketRequestReal realRequest = new B2CreateBucketRequestReal(this.getAccountIdWithoutRetry(), request);
            return this.webifier.createBucket(this.accountAuthCache.get(), realRequest);
        }, this.retryPolicySupplier.get());
    }

    @Override
    public B2CreatedApplicationKey createKey(B2CreateKeyRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_create_key", this.accountAuthCache, () -> {
            B2CreateKeyRequestReal realRequest = new B2CreateKeyRequestReal(this.getAccountIdWithoutRetry(), request);
            return this.webifier.createKey(this.accountAuthCache.get(), realRequest);
        }, this.retryPolicySupplier.get());
    }

    @Override
    public B2ListKeysIterable applicationKeys(B2ListKeysRequest request) throws B2Exception {
        return new B2ListKeysIterable(this, request);
    }

    @Override
    public B2ApplicationKey deleteKey(B2DeleteKeyRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_delete_key", this.accountAuthCache, () -> this.webifier.deleteKey(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2ListBucketsResponse listBuckets(B2ListBucketsRequest listBucketsRequest) throws B2Exception {
        return this.retryer.doRetry("b2_list_buckets", this.accountAuthCache, () -> this.webifier.listBuckets(this.accountAuthCache.get(), listBucketsRequest), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion finishUploadingLargeFile(B2FileVersion fileVersion, B2UploadFileRequest request, ExecutorService executor) throws B2Exception {
        long contentLength = this.getContentLength(request.getContentSource());
        B2PartSizes partSizes = this.getPartSizes();
        B2LargeFileUploader uploader = new B2LargeFileUploader(this.retryer, this.webifier, this.accountAuthCache, this.retryPolicySupplier, executor, partSizes, request, contentLength);
        ArrayList<B2Part> alreadyUploadedParts = new ArrayList<B2Part>();
        for (B2Part part : this.parts(fileVersion.getFileId())) {
            alreadyUploadedParts.add(part);
        }
        return uploader.finishUploadingLargeFile(fileVersion, alreadyUploadedParts);
    }

    @Override
    public B2FileVersion uploadSmallFile(B2UploadFileRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_upload_file", this.accountAuthCache, isRetry -> {
            B2UploadUrlResponse uploadUrlResponse = this.uploadUrlCache.get(request.getBucketId(), isRetry);
            B2FileVersion version = this.webifier.uploadFile(uploadUrlResponse, request);
            this.uploadUrlCache.unget(uploadUrlResponse);
            return version;
        }, this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion copySmallFile(B2CopyFileRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_copy_file", this.accountAuthCache, isRetry -> this.webifier.copyFile(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion uploadLargeFile(B2UploadFileRequest request, ExecutorService executor) throws B2Exception {
        long contentLength = this.getContentLength(request.getContentSource());
        B2PartSizes partSizes = this.getPartSizes();
        return this.uploadLargeFileGuts(executor, partSizes, request, contentLength);
    }

    @Override
    public B2FileVersion storeLargeFileFromLocalContent(B2FileVersion fileVersion, B2ContentSource contentSource, B2UploadListener uploadListener, ExecutorService executor) throws B2Exception {
        return B2LargeFileStorer.forLocalContent(fileVersion, contentSource, this.getPartSizes(), this.accountAuthCache, this.webifier, this.retryer, this.retryPolicySupplier, executor).storeFile(uploadListener);
    }

    @Override
    public B2FileVersion storeLargeFile(B2FileVersion fileVersion, List<B2PartStorer> partStorers, B2UploadListener uploadListenerOrNull, ExecutorService executor) throws B2Exception {
        return new B2LargeFileStorer(fileVersion, partStorers, this.accountAuthCache, this.webifier, this.retryer, this.retryPolicySupplier, executor).storeFile(uploadListenerOrNull);
    }

    private B2FileVersion uploadLargeFileGuts(ExecutorService executor, B2PartSizes partSizes, B2UploadFileRequest request, long contentLength) throws B2Exception {
        B2LargeFileUploader uploader = new B2LargeFileUploader(this.retryer, this.webifier, this.accountAuthCache, this.retryPolicySupplier, executor, partSizes, request, contentLength);
        return uploader.uploadLargeFile();
    }

    private B2PartSizes getPartSizes() throws B2Exception {
        return B2PartSizes.from(this.retryer.doRetry("get_part_sizes", this.accountAuthCache, this.accountAuthCache::get, this.retryPolicySupplier.get()));
    }

    private long getContentLength(B2ContentSource contentSource) throws B2LocalException {
        try {
            return contentSource.getContentLength();
        }
        catch (IOException e) {
            throw new B2LocalException("read_failed", "failed to get contentLength from source: " + e, e);
        }
    }

    @Override
    public B2ListFilesIterable fileVersions(B2ListFileVersionsRequest request) throws B2Exception {
        return new B2ListFileVersionsIterable(this, request);
    }

    @Override
    public B2ListFilesIterable fileNames(B2ListFileNamesRequest request) throws B2Exception {
        return new B2ListFileNamesIterable(this, request);
    }

    @Override
    public B2ListFilesIterable unfinishedLargeFiles(B2ListUnfinishedLargeFilesRequest request) throws B2Exception {
        return new B2ListUnfinishedLargeFilesIterable(this, request);
    }

    @Override
    public B2ListPartsIterable parts(B2ListPartsRequest request) throws B2Exception {
        return new B2ListPartsIterableImpl(this, request);
    }

    @Override
    public void cancelLargeFile(B2CancelLargeFileRequest request) throws B2Exception {
        this.retryer.doRetry("b2_cancel_large_file", this.accountAuthCache, () -> {
            this.webifier.cancelLargeFile(this.accountAuthCache.get(), request);
            return 0;
        }, this.retryPolicySupplier.get());
    }

    @Override
    public void downloadById(B2DownloadByIdRequest request, B2ContentSink handler) throws B2Exception {
        this.retryer.doRetry("b2_download_file_by_id", this.accountAuthCache, () -> {
            B2AccountAuthorization accountAuth = this.accountAuthCache.get();
            this.webifier.downloadById(accountAuth, request, handler);
            return 0;
        }, this.retryPolicySupplier.get());
    }

    @Override
    public String getDownloadByIdUrl(B2DownloadByIdRequest request) throws B2Exception {
        return this.retryer.doRetry("getDownloadByIdUrl", this.accountAuthCache, () -> {
            B2AccountAuthorization accountAuth = this.accountAuthCache.get();
            return this.webifier.getDownloadByIdUrl(accountAuth, request);
        }, this.retryPolicySupplier.get());
    }

    @Override
    public String getDownloadByNameUrl(B2DownloadByNameRequest request) throws B2Exception {
        return this.retryer.doRetry("getDownloadByNameUrl", this.accountAuthCache, () -> {
            B2AccountAuthorization accountAuth = this.accountAuthCache.get();
            return this.webifier.getDownloadByNameUrl(accountAuth, request);
        }, this.retryPolicySupplier.get());
    }

    @Override
    public void downloadByName(B2DownloadByNameRequest request, B2ContentSink handler) throws B2Exception {
        this.retryer.doRetry("b2_download_file_by_name", this.accountAuthCache, () -> {
            B2AccountAuthorization accountAuth = this.accountAuthCache.get();
            this.webifier.downloadByName(accountAuth, request, handler);
            return 0;
        }, this.retryPolicySupplier.get());
    }

    @Override
    public void deleteFileVersion(B2DeleteFileVersionRequest request) throws B2Exception {
        this.retryer.doRetry("b2_delete_file_version", this.accountAuthCache, () -> {
            this.webifier.deleteFileVersion(this.accountAuthCache.get(), request);
            return 0;
        }, this.retryPolicySupplier.get());
    }

    @Override
    public B2DownloadAuthorization getDownloadAuthorization(B2GetDownloadAuthorizationRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_get_download_authorization", this.accountAuthCache, () -> this.webifier.getDownloadAuthorization(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion getFileInfo(B2GetFileInfoRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_get_file_info", this.accountAuthCache, () -> this.webifier.getFileInfo(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion getFileInfoByName(B2GetFileInfoByNameRequest request) throws B2Exception {
        return this.retryer.doRetry("get_file_info_by_name", this.accountAuthCache, () -> this.webifier.getFileInfoByName(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion hideFile(B2HideFileRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_hide_file", this.accountAuthCache, () -> this.webifier.hideFile(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2Bucket updateBucket(B2UpdateBucketRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_update_bucket", this.accountAuthCache, () -> this.webifier.updateBucket(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2Bucket deleteBucket(B2DeleteBucketRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_delete_bucket", this.accountAuthCache, () -> {
            B2DeleteBucketRequestReal realRequest = new B2DeleteBucketRequestReal(this.getAccountIdWithoutRetry(), request.getBucketId());
            return this.webifier.deleteBucket(this.accountAuthCache.get(), realRequest);
        }, this.retryPolicySupplier.get());
    }

    @Override
    public B2AccountAuthorization getAccountAuthorization() throws B2Exception {
        return this.retryer.doRetry("b2_authorize_account", this.accountAuthCache, this.accountAuthCache::get, this.retryPolicySupplier.get());
    }

    @Override
    public void invalidateAccountAuthorization() {
        this.accountAuthCache.clear();
    }

    @Override
    public B2UploadUrlResponse getUploadUrl(B2GetUploadUrlRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_get_upload_url", this.accountAuthCache, () -> this.webifier.getUploadUrl(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2UploadPartUrlResponse getUploadPartUrl(B2GetUploadPartUrlRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_get_upload_part_url", this.accountAuthCache, () -> this.webifier.getUploadPartUrl(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion startLargeFile(B2StartLargeFileRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_start_large_file", this.accountAuthCache, () -> this.webifier.startLargeFile(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    @Override
    public B2FileVersion finishLargeFile(B2FinishLargeFileRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_finish_large_file", this.accountAuthCache, () -> this.webifier.finishLargeFile(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    B2ListFileVersionsResponse listFileVersions(B2ListFileVersionsRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_list_file_versions", this.accountAuthCache, () -> this.webifier.listFileVersions(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    B2ListFileNamesResponse listFileNames(B2ListFileNamesRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_list_file_names", this.accountAuthCache, () -> this.webifier.listFileNames(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    B2ListKeysResponse listKeys(B2ListKeysRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_list_keys", this.accountAuthCache, () -> {
            B2ListKeysRequestReal realRequest = new B2ListKeysRequestReal(this.getAccountIdWithoutRetry(), request.getMaxKeyCount(), request.getStartApplicationKeyId());
            return this.webifier.listKeys(this.accountAuthCache.get(), realRequest);
        }, this.retryPolicySupplier.get());
    }

    B2ListUnfinishedLargeFilesResponse listUnfinishedLargeFiles(B2ListUnfinishedLargeFilesRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_list_unfinished_large_files", this.accountAuthCache, () -> this.webifier.listUnfinishedLargeFiles(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }

    B2ListPartsResponse listParts(B2ListPartsRequest request) throws B2Exception {
        return this.retryer.doRetry("b2_list_parts", this.accountAuthCache, () -> this.webifier.listParts(this.accountAuthCache.get(), request), this.retryPolicySupplier.get());
    }
}

