/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2AccountAuthorizationCache;
import com.backblaze.b2.client.B2RetryPolicy;
import com.backblaze.b2.client.B2Sleeper;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2InternalErrorException;
import com.backblaze.b2.client.exceptions.B2NetworkBaseException;
import com.backblaze.b2.client.exceptions.B2RequestTimeoutException;
import com.backblaze.b2.client.exceptions.B2ServiceUnavailableException;
import com.backblaze.b2.client.exceptions.B2TooManyRequestsException;
import com.backblaze.b2.client.exceptions.B2UnauthorizedException;
import com.backblaze.b2.util.B2Clock;
import java.util.concurrent.Callable;

class B2Retryer {
    private final B2Sleeper sleeper;

    B2Retryer(B2Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    <T> T doRetry(String operation, B2AccountAuthorizationCache accountAuthCache, Callable<T> callable, B2RetryPolicy retryPolicy) throws B2Exception {
        return (T)this.doRetry(operation, accountAuthCache, (boolean isRetry) -> callable.call(), retryPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T doRetry(String operation, B2AccountAuthorizationCache accountAuthCache, RetryableCallable<T> callable, B2RetryPolicy retryPolicy) throws B2Exception {
        B2Clock clock = B2Clock.get();
        int attemptsSoFar = 0;
        block13: while (true) {
            long beforeMonoMillis = clock.monotonicMillis();
            long tookMillis = -1L;
            try {
                try {
                    boolean isRetry = attemptsSoFar != 0;
                    T value = callable.call(isRetry);
                    tookMillis = clock.monotonicMillis() - beforeMonoMillis;
                    retryPolicy.succeeded(operation, ++attemptsSoFar, tookMillis);
                    T t = value;
                    return t;
                }
                finally {
                    tookMillis = clock.monotonicMillis() - beforeMonoMillis;
                }
            }
            catch (B2UnauthorizedException e) {
                switch (e.getRequestCategory()) {
                    case ACCOUNT_AUTHORIZATION: {
                        retryPolicy.gotUnretryable(operation, attemptsSoFar, tookMillis, e);
                        throw e;
                    }
                    case UPLOADING: {
                        if (retryPolicy.gotRetryableImmediately(operation, attemptsSoFar, tookMillis, e)) continue block13;
                        throw e;
                    }
                    case OTHER: {
                        accountAuthCache.clear();
                        if (retryPolicy.gotRetryableImmediately(operation, attemptsSoFar, tookMillis, e)) continue block13;
                        throw e;
                    }
                }
                continue;
            }
            catch (B2InternalErrorException | B2NetworkBaseException | B2RequestTimeoutException | B2ServiceUnavailableException | B2TooManyRequestsException e) {
                Integer waitSeconds = retryPolicy.gotRetryableAfterDelay(operation, attemptsSoFar, tookMillis, e);
                if (waitSeconds == null) {
                    throw e;
                }
                this.sleeper.sleepSeconds(waitSeconds);
                continue;
            }
            catch (B2Exception e) {
                retryPolicy.gotUnretryable(operation, attemptsSoFar, tookMillis, e);
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                retryPolicy.gotUnexpectedUnretryable(operation, attemptsSoFar, tookMillis, e);
                throw new B2Exception("unexpected", 500, null, "unexpected: " + e, e);
            }
            break;
        }
    }

    static interface RetryableCallable<T> {
        public T call(boolean var1) throws Exception;
    }
}

