/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.exceptions.B2RuntimeException;
import com.backblaze.b2.client.structures.B2ApplicationKey;
import com.backblaze.b2.client.structures.B2ListKeysRequest;
import com.backblaze.b2.client.structures.B2ListKeysResponse;
import java.util.Iterator;
import java.util.List;

public class B2ListKeysIterator
implements Iterator<B2ApplicationKey> {
    private final B2StorageClientImpl b2Client;
    private B2ListKeysRequest nextRequest;
    private List<B2ApplicationKey> currentList;
    private int nextIndex = 0;

    B2ListKeysIterator(B2StorageClientImpl b2Client, B2ListKeysRequest request) {
        this.b2Client = b2Client;
        this.nextRequest = request;
        this.advance();
    }

    private void advance() {
        try {
            B2ListKeysResponse response = this.b2Client.listKeys(this.nextRequest);
            this.nextRequest = response.getNextApplicationKeyId() != null ? new B2ListKeysRequest(this.nextRequest.getMaxKeyCount(), response.getNextApplicationKeyId()) : null;
            this.currentList = response.getKeys();
            this.nextIndex = 0;
        }
        catch (B2Exception e) {
            throw new B2RuntimeException("failed to advance iterator: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currentList.size() <= this.nextIndex && this.nextRequest != null) {
            this.advance();
        }
        return this.nextIndex < this.currentList.size();
    }

    @Override
    public B2ApplicationKey next() {
        B2ApplicationKey result = this.currentList.get(this.nextIndex);
        ++this.nextIndex;
        return result;
    }
}

