/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2ListFilesIterableBase;
import com.backblaze.b2.client.B2StorageClientImpl;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2FileVersion;
import com.backblaze.b2.client.structures.B2ListFileVersionsRequest;
import com.backblaze.b2.client.structures.B2ListFileVersionsResponse;
import com.backblaze.b2.client.structures.B2ListFilesResponse;
import java.util.Iterator;

public class B2ListFileVersionsIterable
extends B2ListFilesIterableBase {
    private final B2ListFileVersionsRequest request;

    public B2ListFileVersionsIterable(B2StorageClientImpl b2Client, B2ListFileVersionsRequest request) {
        super(b2Client);
        this.request = request;
    }

    @Override
    Iterator<B2FileVersion> createIter() throws B2Exception {
        return new Iter();
    }

    private class Iter
    extends B2ListFilesIterableBase.IterBase {
        private B2ListFileVersionsResponse currentResponse;

        Iter() throws B2Exception {
        }

        @Override
        protected B2ListFilesResponse getCurrentResponseOrNull() {
            return this.currentResponse;
        }

        @Override
        protected void advance() throws B2Exception {
            B2ListFileVersionsRequest.Builder builder = B2ListFileVersionsRequest.builder(B2ListFileVersionsIterable.this.request);
            if (this.currentResponse != null) {
                builder.setStart(this.currentResponse.getNextFileName(), this.currentResponse.getNextFileId());
            }
            this.currentResponse = B2ListFileVersionsIterable.this.getClient().listFileVersions(builder.build());
        }
    }
}

