/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2LargeFileStorer;
import com.backblaze.b2.client.B2PartStorer;
import com.backblaze.b2.client.exceptions.B2CannotComputeException;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.client.structures.B2Part;
import com.backblaze.b2.client.structures.B2UploadListener;
import com.backblaze.b2.util.B2ByteRange;
import java.util.Objects;

public class B2CopyingPartStorer
implements B2PartStorer {
    private final int partNumber;
    private final String sourceFileId;
    private final B2ByteRange byteRangeOrNull;

    public B2CopyingPartStorer(int partNumber, String sourceFileId) {
        this(partNumber, sourceFileId, null);
    }

    public B2CopyingPartStorer(int partNumber, String sourceFileId, B2ByteRange byteRangeOrNull) {
        this.partNumber = partNumber;
        this.sourceFileId = sourceFileId;
        this.byteRangeOrNull = byteRangeOrNull;
    }

    @Override
    public int getPartNumber() {
        return this.partNumber;
    }

    @Override
    public long getPartSizeOrThrow() throws B2CannotComputeException {
        throw new B2CannotComputeException("cannot determine copied part size.");
    }

    @Override
    public B2Part storePart(B2LargeFileStorer largeFileCreationManager, B2UploadListener uploadListener) throws B2Exception {
        return largeFileCreationManager.copyPart(this.partNumber, this.sourceFileId, this.byteRangeOrNull, uploadListener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2CopyingPartStorer that = (B2CopyingPartStorer)o;
        return this.partNumber == that.partNumber && Objects.equals(this.sourceFileId, that.sourceFileId) && Objects.equals(this.byteRangeOrNull, that.byteRangeOrNull);
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.sourceFileId, this.byteRangeOrNull);
    }
}

