/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.contentSources.B2ContentSource;
import com.backblaze.b2.client.exceptions.B2Exception;
import com.backblaze.b2.util.B2ByteProgressListener;
import com.backblaze.b2.util.B2InputStreamWithByteProgressListener;
import com.backblaze.b2.util.B2Preconditions;
import java.io.IOException;
import java.io.InputStream;

class B2ContentSourceWithByteProgressListener
implements B2ContentSource {
    private final B2ContentSource source;
    private final B2ByteProgressListener listener;

    B2ContentSourceWithByteProgressListener(B2ContentSource source, B2ByteProgressListener listener) {
        B2Preconditions.checkArgumentIsNotNull(listener, "listener");
        this.source = source;
        this.listener = listener;
    }

    @Override
    public long getContentLength() throws IOException {
        return this.source.getContentLength();
    }

    @Override
    public String getSha1OrNull() throws IOException {
        return this.source.getSha1OrNull();
    }

    @Override
    public Long getSrcLastModifiedMillisOrNull() throws IOException {
        return this.source.getSrcLastModifiedMillisOrNull();
    }

    @Override
    public InputStream createInputStream() throws IOException, B2Exception {
        InputStream inputStream = this.source.createInputStream();
        return new B2InputStreamWithByteProgressListener(inputStream, this.listener);
    }

    public String toString() {
        return "B2ContentSourceWithByteProgressListener{" + this.source + "}";
    }
}

